/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.common.AbstractTimephasedWorkNormaliser;
import net.sf.mpxj.common.DateHelper;

public abstract class MPPAbstractTimephasedWorkNormaliser
extends AbstractTimephasedWorkNormaliser {
    private static final double EQUALITY_DELTA = 0.1;

    @Override
    public void normalise(ResourceAssignment assignment, List<TimephasedWork> list) {
        if (list.isEmpty()) {
            return;
        }
        ProjectCalendar calendar = this.getCalendar(assignment);
        this.splitDays(calendar, list);
        this.mergeSameDay(calendar, list);
        this.mergeSameWork(list);
        this.convertToHours(list);
    }

    protected abstract ProjectCalendar getCalendar(ResourceAssignment var1);

    private void splitDays(ProjectCalendar calendar, List<TimephasedWork> list) {
        ArrayList<TimephasedWork> result = new ArrayList<TimephasedWork>();
        boolean remainderInserted = false;
        block0: for (TimephasedWork assignment : list) {
            if (remainderInserted) {
                assignment.setStart(DateHelper.addDays(assignment.getStart(), 1));
                remainderInserted = false;
            }
            Duration calendarWork = calendar.getWork(assignment.getStart(), assignment.getFinish(), TimeUnit.MINUTES);
            while (assignment != null) {
                Date startDay = DateHelper.getDayStartDate(assignment.getStart());
                Date finishDay = DateHelper.getDayStartDate(assignment.getFinish());
                if (assignment.getFinish().getTime() == finishDay.getTime()) {
                    finishDay = DateHelper.addDays(finishDay, -1);
                }
                if (startDay.getTime() == finishDay.getTime()) {
                    Duration totalWork = (Duration)assignment.getTotalAmount();
                    Duration assignmentWork = this.getAssignmentWork(calendar, assignment);
                    if (totalWork.getDuration() - assignmentWork.getDuration() > 0.1) {
                        assignment.setTotalAmount(assignmentWork);
                        result.add(assignment);
                        Duration remainingWork = Duration.getInstance(totalWork.getDuration() - assignmentWork.getDuration(), TimeUnit.MINUTES);
                        Date remainderStart = DateHelper.addDays(finishDay, 1);
                        Date remainderFinish = DateHelper.addDays(remainderStart, 1);
                        TimephasedWork remainder = new TimephasedWork();
                        remainder.setStart(remainderStart);
                        remainder.setFinish(remainderFinish);
                        remainder.setTotalAmount(remainingWork);
                        result.add(remainder);
                        remainderInserted = true;
                        continue block0;
                    }
                    result.add(assignment);
                    continue block0;
                }
                TimephasedWork[] split = this.splitFirstDay(calendar, assignment, calendarWork);
                if (split[0] != null) {
                    TimephasedWork firstDayAssignment = split[0];
                    result.add(firstDayAssignment);
                    Duration firstDayCalendarWork = calendar.getWork(firstDayAssignment.getStart(), firstDayAssignment.getFinish(), TimeUnit.MINUTES);
                    calendarWork = Duration.getInstance(calendarWork.getDuration() - firstDayCalendarWork.getDuration(), TimeUnit.MINUTES);
                }
                if (assignment.equals(split[1])) continue block0;
                assignment = split[1];
            }
        }
        list.clear();
        list.addAll(result);
    }

    private TimephasedWork[] splitFirstDay(ProjectCalendar calendar, TimephasedWork assignment, Duration calendarWork) {
        TimephasedWork[] result = new TimephasedWork[2];
        Date assignmentStart = assignment.getStart();
        Date assignmentFinish = assignment.getFinish();
        Duration assignmentWork = (Duration)assignment.getTotalAmount();
        if (calendarWork.getDuration() != 0.0) {
            TimephasedWork split;
            double splitMinutes;
            Date splitFinish;
            if (calendar.isWorkingDate(assignmentStart)) {
                Date splitFinishTime = calendar.getFinishTime(assignmentStart);
                splitFinish = DateHelper.setTime(assignmentStart, splitFinishTime);
                Duration calendarSplitWork = calendar.getWork(assignmentStart, splitFinish, TimeUnit.MINUTES);
                Duration assignmentWorkPerDay = (Duration)assignment.getAmountPerDay();
                splitMinutes = assignmentWorkPerDay.getDuration();
                splitMinutes *= calendarSplitWork.getDuration();
                Duration splitWork = Duration.getInstance(splitMinutes /= 480.0, TimeUnit.MINUTES);
                TimephasedWork split2 = new TimephasedWork();
                split2.setStart(assignmentStart);
                split2.setFinish(splitFinish);
                split2.setTotalAmount(splitWork);
                result[0] = split2;
            } else {
                splitFinish = assignmentStart;
                splitMinutes = 0.0;
            }
            Date splitStart = calendar.getNextWorkStart(splitFinish);
            splitFinish = assignmentFinish;
            if (splitStart.getTime() > splitFinish.getTime()) {
                split = null;
            } else {
                splitMinutes = assignmentWork.getDuration() - splitMinutes;
                Duration splitWork = Duration.getInstance(splitMinutes, TimeUnit.MINUTES);
                split = new TimephasedWork();
                split.setStart(splitStart);
                split.setFinish(splitFinish);
                split.setTotalAmount(splitWork);
                split.setAmountPerDay(assignment.getAmountPerDay());
            }
            result[1] = split;
        }
        return result;
    }

    protected abstract void mergeSameDay(ProjectCalendar var1, List<TimephasedWork> var2);

    private Duration getAssignmentWork(ProjectCalendar calendar, TimephasedWork assignment) {
        Date splitFinishTime = calendar.getFinishTime(assignment.getStart());
        Date splitFinish = DateHelper.setTime(assignment.getStart(), splitFinishTime);
        Duration calendarSplitWork = calendar.getWork(assignment.getStart(), splitFinish, TimeUnit.MINUTES);
        Duration assignmentWorkPerDay = (Duration)assignment.getAmountPerDay();
        double splitMinutes = assignmentWorkPerDay.getDuration();
        splitMinutes *= calendarSplitWork.getDuration();
        Duration splitWork = Duration.getInstance(splitMinutes /= 480.0, TimeUnit.MINUTES);
        return splitWork;
    }
}

