/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MultiMap<V>
extends LinkedHashMap<String, List<V>> {
    public MultiMap() {
    }

    public MultiMap(Map<String, List<V>> map2) {
        super(map2);
    }

    public MultiMap(MultiMap<V> map2) {
        super(map2);
    }

    public List<V> getValues(String name2) {
        List vals2 = (List)super.get(name2);
        if (vals2 == null || vals2.isEmpty()) {
            return null;
        }
        return vals2;
    }

    public V getValue(String name2, int i) {
        List<V> vals2 = this.getValues(name2);
        if (vals2 == null) {
            return null;
        }
        if (i == 0 && vals2.isEmpty()) {
            return null;
        }
        return vals2.get(i);
    }

    public String getString(String name2) {
        List vals2 = (List)this.get(name2);
        if (vals2 == null || vals2.isEmpty()) {
            return null;
        }
        if (vals2.size() == 1) {
            return vals2.get(0).toString();
        }
        StringBuilder values = new StringBuilder(128);
        for (Object e2 : vals2) {
            if (e2 == null) continue;
            if (values.length() > 0) {
                values.append(',');
            }
            values.append(e2.toString());
        }
        return values.toString();
    }

    @Override
    public List<V> put(String name2, V value) {
        if (value == null) {
            return super.put(name2, null);
        }
        ArrayList<V> vals2 = new ArrayList<V>();
        vals2.add(value);
        return this.put(name2, vals2);
    }

    public void putAllValues(Map<String, V> input) {
        for (Map.Entry<String, V> entry : input.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public List<V> putValues(String name2, List<V> values) {
        return super.put(name2, values);
    }

    @SafeVarargs
    public final List<V> putValues(String name2, V ... values) {
        ArrayList<V> list = new ArrayList<V>();
        list.addAll(Arrays.asList(values));
        return super.put(name2, list);
    }

    public void add(String name2, V value) {
        ArrayList<V> lo = (ArrayList<V>)this.get(name2);
        if (lo == null) {
            lo = new ArrayList<V>();
        }
        lo.add(value);
        super.put(name2, lo);
    }

    public void addValues(String name2, List<V> values) {
        ArrayList<V> lo = (ArrayList<V>)this.get(name2);
        if (lo == null) {
            lo = new ArrayList<V>();
        }
        lo.addAll(values);
        this.put(name2, lo);
    }

    public void addValues(String name2, V[] values) {
        ArrayList<V> lo = (ArrayList<V>)this.get(name2);
        if (lo == null) {
            lo = new ArrayList<V>();
        }
        lo.addAll(Arrays.asList(values));
        this.put(name2, lo);
    }

    public boolean addAllValues(MultiMap<V> map2) {
        boolean merged = false;
        if (map2 == null || map2.isEmpty()) {
            return merged;
        }
        for (Map.Entry entry : map2.entrySet()) {
            String name2 = (String)entry.getKey();
            List values = (List)entry.getValue();
            if (this.containsKey(name2)) {
                merged = true;
            }
            this.addValues(name2, values);
        }
        return merged;
    }

    public boolean removeValue(String name2, V value) {
        List lo = (List)this.get(name2);
        if (lo == null || lo.isEmpty()) {
            return false;
        }
        boolean ret = lo.remove(value);
        if (lo.isEmpty()) {
            this.remove(name2);
        } else {
            this.put(name2, lo);
        }
        return ret;
    }

    public boolean containsSimpleValue(V value) {
        for (List vals2 : this.values()) {
            if (vals2.size() != 1 || !vals2.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        Iterator iter = this.entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean delim = false;
        while (iter.hasNext()) {
            Map.Entry e2 = iter.next();
            if (delim) {
                sb.append(", ");
            }
            String key2 = (String)e2.getKey();
            List vals2 = (List)e2.getValue();
            sb.append(key2);
            sb.append('=');
            if (vals2.size() == 1) {
                sb.append(vals2.get(0));
            } else {
                sb.append(vals2);
            }
            delim = true;
        }
        sb.append('}');
        return sb.toString();
    }

    public Map<String, String[]> toStringArrayMap() {
        LinkedHashMap<String, String[]> map2 = new LinkedHashMap<String, String[]>(this.size() * 3 / 2){

            @Override
            public String toString() {
                StringBuilder b = new StringBuilder();
                b.append('{');
                for (String k : super.keySet()) {
                    if (b.length() > 1) {
                        b.append(',');
                    }
                    b.append(k);
                    b.append('=');
                    b.append(Arrays.asList((String[])super.get(k)));
                }
                b.append('}');
                return b.toString();
            }
        };
        for (Map.Entry entry : this.entrySet()) {
            String[] a = null;
            if (entry.getValue() != null) {
                a = new String[((List)entry.getValue()).size()];
                a = ((List)entry.getValue()).toArray(a);
            }
            map2.put((String)entry.getKey(), a);
        }
        return map2;
    }
}

