/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.internal.MarkerAdapter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerNode;
import org.eclipse.ui.views.markers.internal.MarkerSelectionProviderAction;
import org.eclipse.ui.views.markers.internal.MarkerView;

public class ActionSelectAll
extends MarkerSelectionProviderAction {
    private MarkerView view;

    public ActionSelectAll(MarkerView markerView) {
        super((ISelectionProvider)markerView.getViewer(), MarkerMessages.selectAllAction_title);
        this.setEnabled(true);
        this.view = markerView;
    }

    public void run() {
        if (this.view.getMarkerAdapter().isBuilding()) {
            return;
        }
        IRunnableWithProgress selectionRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(MarkerMessages.selectAllAction_title, 100);
                    monitor.subTask(MarkerMessages.selectAllAction_calculating);
                    if (ActionSelectAll.this.view.getMarkerAdapter().isShowingHierarchy()) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        monitor.worked(10);
                        PlatformUI.getWorkbench().getDisplay().readAndDispatch();
                        MarkerAdapter.MarkerCategory[] categories = ActionSelectAll.this.view.getMarkerAdapter().getCategories();
                        int totalSize = 0;
                        int i = 0;
                        while (i < categories.length) {
                            MarkerAdapter.MarkerCategory markerCategory = categories[i];
                            totalSize += markerCategory.getDisplayedSize();
                            ++i;
                        }
                        monitor.worked(10);
                        PlatformUI.getWorkbench().getDisplay().readAndDispatch();
                        Object[] selection = new Object[totalSize];
                        int index = 0;
                        int i2 = 0;
                        while (i2 < categories.length) {
                            MarkerNode[] children = categories[i2].getChildren();
                            System.arraycopy(children, 0, selection, index, children.length);
                            index += children.length;
                            ++i2;
                        }
                        monitor.worked(10);
                        if (monitor.isCanceled()) {
                            return;
                        }
                        PlatformUI.getWorkbench().getDisplay().readAndDispatch();
                        monitor.subTask(MarkerMessages.selectAllAction_applying);
                        ActionSelectAll.this.getSelectionProvider().setSelection((ISelection)new StructuredSelection(selection));
                    } else {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        monitor.worked(10);
                        List selection = ActionSelectAll.this.view.getMarkerAdapter().getCurrentMarkers().asList();
                        monitor.worked(10);
                        monitor.subTask(MarkerMessages.selectAllAction_applying);
                        PlatformUI.getWorkbench().getDisplay().readAndDispatch();
                        ActionSelectAll.this.getSelectionProvider().setSelection((ISelection)new StructuredSelection(selection));
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, selectionRunnableWithProgress);
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, e.getLocalizedMessage(), (Throwable)e), 1);
        }
        catch (InterruptedException e) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, e.getLocalizedMessage(), (Throwable)e), 1);
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(!selection.isEmpty());
    }
}

