/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.correction;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.text.correction.CCorrectionProcessor;
import org.eclipse.cdt.internal.ui.text.correction.CorrectionContext;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.viewsupport.ISelectionListenerWithAST;
import org.eclipse.cdt.internal.ui.viewsupport.SelectionListenerWithASTManager;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ITextEditor;

public class QuickAssistLightBulbUpdater {
    private final Annotation fAnnotation;
    private boolean fIsAnnotationShown;
    private ITextEditor fEditor;
    private ITextViewer fViewer;
    private ISelectionListenerWithAST fListener;
    private IPropertyChangeListener fPropertyChangeListener;

    public QuickAssistLightBulbUpdater(ITextEditor part, ITextViewer viewer) {
        this.fEditor = part;
        this.fViewer = viewer;
        this.fAnnotation = new AssistAnnotation();
        this.fIsAnnotationShown = false;
        this.fPropertyChangeListener = null;
    }

    public boolean isSetInPreferences() {
        return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.quickassist.lightbulb");
    }

    private void installSelectionListener() {
        this.fListener = new ISelectionListenerWithAST(){

            @Override
            public void selectionChanged(IEditorPart part, ITextSelection selection, IASTTranslationUnit astRoot) {
                QuickAssistLightBulbUpdater.this.doSelectionChanged(selection.getOffset(), selection.getLength(), astRoot);
            }
        };
        SelectionListenerWithASTManager.getDefault().addListener(this.fEditor, this.fListener);
    }

    private void uninstallSelectionListener() {
        IAnnotationModel model;
        if (this.fListener != null) {
            SelectionListenerWithASTManager.getDefault().removeListener(this.fEditor, this.fListener);
            this.fListener = null;
        }
        if ((model = this.getAnnotationModel()) != null) {
            this.removeLightBulb(model);
        }
    }

    public void install() {
        if (this.isSetInPreferences()) {
            this.installSelectionListener();
        }
        if (this.fPropertyChangeListener == null) {
            this.fPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    QuickAssistLightBulbUpdater.this.doPropertyChanged(event.getProperty());
                }
            };
            PreferenceConstants.getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    public void uninstall() {
        this.uninstallSelectionListener();
        if (this.fPropertyChangeListener != null) {
            PreferenceConstants.getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
    }

    protected void doPropertyChanged(String property) {
        if (property.equals("org.eclipse.cdt.quickassist.lightbulb")) {
            if (this.isSetInPreferences()) {
                IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
                if (workingCopy != null) {
                    this.installSelectionListener();
                    final Point point = this.fViewer.getSelectedRange();
                    ASTProvider.getASTProvider().runOnAST((ICElement)workingCopy, ASTProvider.WAIT_IF_OPEN, null, new ASTCache.ASTRunnable(){

                        public IStatus runOnAST(ILanguage lang, IASTTranslationUnit astRoot) {
                            if (astRoot != null) {
                                QuickAssistLightBulbUpdater.this.doSelectionChanged(point.x, point.y, astRoot);
                            }
                            return Status.OK_STATUS;
                        }
                    });
                }
            } else {
                this.uninstallSelectionListener();
            }
        }
    }

    private ITranslationUnit getTranslationUnit() {
        ICElement elem = EditorUtility.getEditorInputCElement((IEditorPart)this.fEditor);
        if (elem instanceof ITranslationUnit) {
            return (ITranslationUnit)elem;
        }
        return null;
    }

    private IAnnotationModel getAnnotationModel() {
        return CUIPlugin.getDefault().getDocumentProvider().getAnnotationModel(this.fEditor.getEditorInput());
    }

    private IDocument getDocument() {
        return CUIPlugin.getDefault().getDocumentProvider().getDocument(this.fEditor.getEditorInput());
    }

    private void doSelectionChanged(int offset, int length, IASTTranslationUnit astRoot) {
        IAnnotationModel model = this.getAnnotationModel();
        ITranslationUnit tu = this.getTranslationUnit();
        if (model == null || tu == null) {
            return;
        }
        CorrectionContext context = new CorrectionContext(tu, offset, length);
        boolean hasQuickFix = this.hasQuickFixLightBulb(model, context.getSelectionOffset());
        if (hasQuickFix) {
            this.removeLightBulb(model);
            return;
        }
        this.calculateLightBulb(model, context);
    }

    private void calculateLightBulb(IAnnotationModel model, CorrectionContext context) {
        boolean needsAnnotation = CCorrectionProcessor.hasAssists(context);
        if (this.fIsAnnotationShown) {
            model.removeAnnotation(this.fAnnotation);
        }
        if (needsAnnotation) {
            model.addAnnotation(this.fAnnotation, new Position(context.getSelectionOffset(), context.getSelectionLength()));
        }
        this.fIsAnnotationShown = needsAnnotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLightBulb(IAnnotationModel model) {
        QuickAssistLightBulbUpdater quickAssistLightBulbUpdater = this;
        synchronized (quickAssistLightBulbUpdater) {
            if (this.fIsAnnotationShown) {
                model.removeAnnotation(this.fAnnotation);
                this.fIsAnnotationShown = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasQuickFixLightBulb(IAnnotationModel model, int offset) {
        try {
            int startLine;
            Position pos;
            Annotation annot;
            IDocument document = this.getDocument();
            if (document == null) {
                return false;
            }
            int currLine = document.getLineOfOffset(offset);
            Iterator iter = model.getAnnotationIterator();
            do {
                if (iter.hasNext()) continue;
                return false;
            } while (!CCorrectionProcessor.isQuickFixableType(annot = (Annotation)iter.next()) || (pos = model.getPosition(annot)) == null || (startLine = document.getLineOfOffset(pos.getOffset())) != currLine || !CCorrectionProcessor.hasCorrections(annot));
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
        return false;
    }

    public static class AssistAnnotation
    extends Annotation
    implements IAnnotationPresentation {
        private static final int LAYER;
        private Image fImage;

        static {
            Annotation annotation = new Annotation("org.eclipse.jdt.ui.warning", false, null);
            AnnotationPreference preference = EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
            LAYER = preference != null ? preference.getPresentationLayer() - 1 : 0;
        }

        public int getLayer() {
            return LAYER;
        }

        private Image getImage() {
            if (this.fImage == null) {
                this.fImage = CDTSharedImages.getImage("icons/obj16/quickassist_obj.gif");
            }
            return this.fImage;
        }

        public void paint(GC gc, Canvas canvas, Rectangle r) {
            ImageUtilities.drawImage((Image)this.getImage(), (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
        }
    }
}

