/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.jni.CuptiMetric;
import com.nvidia.viper.jni.CuptiMetricEvaluationMode;
import com.nvidia.viper.jni.CuptiMetricValueKind;
import com.nvidia.viper.jni.NativeCupti;
import com.nvidia.viper.model.Metric;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MetricManager {
    public static final String ACHIEVED_OCCUPANCY_METRIC_NAME = "achieved_occupancy";
    public static final String SM_ACTIVITY_INSTANCE_METRIC_NAME = "sm_efficiency_instance";
    public static final String SM_ACTIVITY_METRIC_NAME = "sm_efficiency";
    public static final String GLD_EFFICIENCY_METRIC_NAME = "gld_efficiency";
    public static final String GST_EFFICIENCY_METRIC_NAME = "gst_efficiency";
    public static final String SHARED_EFFICIENCY_METRIC_NAME = "shared_efficiency";
    public static final String LOCAL_MEMORY_OVERHEAD_NAME = "local_memory_overhead";
    public static final String WARP_EXECUTION_EFFICIENCY_METRIC_NAME = "warp_execution_efficiency";
    public static final String WARP_NONPRED_EXECUTION_EFFICIENCY_METRIC_NAME = "warp_nonpred_execution_efficiency";
    public static final String DRAM_READ_TRANSACTIONS_METRIC_NAME = "dram_read_transactions";
    public static final String DRAM_WRITE_TRANSACTIONS_METRIC_NAME = "dram_write_transactions";
    public static final String SYSRAM_READ_TRANSACTIONS_METRIC_NAME = "sysmem_read_transactions";
    public static final String SYSRAM_WRITE_TRANSACTIONS_METRIC_NAME = "sysmem_write_transactions";
    public static final String L2_READ_TRANSACTIONS_METRIC_NAME = "l2_read_transactions";
    public static final String L2_WRITE_TRANSACTIONS_METRIC_NAME = "l2_write_transactions";
    public static final String L2_l1_READ_TRANSACTIONS_METRIC_NAME = "l2_l1_read_transactions";
    public static final String L2_l1_WRITE_TRANSACTIONS_METRIC_NAME = "l2_l1_write_transactions";
    public static final String L2_TEX_READ_TRANSACTIONS_METRIC_NAME = "l2_tex_read_transactions";
    public static final String L2_TEX_WRITE_TRANSACTIONS_METRIC_NAME = "l2_tex_write_transactions";
    public static final String L2_ATOMIC_TRANSACTIONS_METRIC_NAME = "l2_atomic_transactions";
    public static final String NC_L2_READ_TRANSACTIONS_METRIC_NAME = "nc_l2_read_transactions";
    public static final String TEX_CACHE_TRANSACTIONS_METRIC_NAME = "tex_cache_transactions";
    public static final String SHARED_READ_TRANSACTIONS_METRIC_NAME = "shared_load_transactions";
    public static final String SHARED_WRITE_TRANSACTIONS_METRIC_NAME = "shared_store_transactions";
    public static final String LOCAL_READ_TRANSACTIONS_METRIC_NAME = "local_load_transactions";
    public static final String LOCAL_WRITE_TRANSACTIONS_METRIC_NAME = "local_store_transactions";
    public static final String GLOBAL_READ_TRANSACTIONS_METRIC_NAME = "gld_transactions";
    public static final String GLOBAL_WRITE_TRANSACTIONS_METRIC_NAME = "gst_transactions";
    public static final String ECC_TRANSACTIONS_METRIC_NAME = "ecc_transactions";
    public static final String ATOMIC_TRANSACTIONS_METRIC_NAME = "atomic_transactions";
    public static final String DRAM_READ_THROUGHPUT_METRIC_NAME = "dram_read_throughput";
    public static final String DRAM_WRITE_THROUGHPUT_METRIC_NAME = "dram_write_throughput";
    public static final String SYSRAM_READ_THROUGHPUT_METRIC_NAME = "sysmem_read_throughput";
    public static final String SYSRAM_WRITE_THROUGHPUT_METRIC_NAME = "sysmem_write_throughput";
    public static final String L2_READ_THROUGHPUT_METRIC_NAME = "l2_read_throughput";
    public static final String L2_WRITE_THROUGHPUT_METRIC_NAME = "l2_write_throughput";
    public static final String L2_L1_READ_THROUGHPUT_METRIC_NAME = "l2_l1_read_throughput";
    public static final String L2_L1_WRITE_THROUGHPUT_METRIC_NAME = "l2_l1_write_throughput";
    public static final String L2_TEX_READ_THROUGHPUT_METRIC_NAME = "l2_texture_read_throughput";
    public static final String L2_TEX_WRITE_THROUGHPUT_METRIC_NAME = "l2_tex_write_throughput";
    public static final String L2_ATOMIC_THROUGHPUT_METRIC_NAME = "l2_atomic_throughput";
    public static final String NC_L2_READ_THROUGHPUT_METRIC_NAME = "nc_l2_read_throughput";
    public static final String TEX_CACHE_THROUGHPUT_METRIC_NAME = "tex_cache_throughput";
    public static final String SHARED_READ_THROUGHPUT_METRIC_NAME = "shared_load_throughput";
    public static final String SHARED_WRITE_THROUGHPUT_METRIC_NAME = "shared_store_throughput";
    public static final String LOCAL_READ_THROUGHPUT_METRIC_NAME = "local_load_throughput";
    public static final String LOCAL_WRITE_THROUGHPUT_METRIC_NAME = "local_store_throughput";
    public static final String GLOBAL_READ_THROUGHPUT_METRIC_NAME = "gld_throughput";
    public static final String GLOBAL_WRITE_THROUGHPUT_METRIC_NAME = "gst_throughput";
    public static final String ECC_THROUGHPUT_METRIC_NAME = "ecc_throughput";
    public static final String ATOMIC_THROUGHPUT_METRIC_NAME = "atomic_throughput";
    public static final String STALL_INST_FETCH_METRIC_NAME = "stall_inst_fetch";
    public static final String STALL_EXEC_DEPENDENCY_METRIC_NAME = "stall_exec_dependency";
    public static final String STALL_DATA_REQUEST_METRIC_NAME = "stall_data_request";
    public static final String STALL_TEXTURE_METRIC_NAME = "stall_texture";
    public static final String STALL_SYNC_METRIC_NAME = "stall_sync";
    public static final String STALL_COMPUTE_METRIC_NAME = "stall_compute";
    public static final String STALL_IMC_METRIC_NAME = "stall_imc";
    public static final String STALL_OTHER_METRIC_NAME = "stall_other";
    public static final String STALL_MEMORY_THROTTLE_METRIC_NAME = "stall_memory_throttle";
    public static final String STALL_NOT_SELECTED_METRIC_NAME = "stall_not_selected";
    public static final String STALL_PIPE_BUSY_METRIC_NAME = "stall_pipe_busy";
    public static final String STALL_CONSTANT_MEMORY_DEPENDENCY_METRIC_NAME = "stall_constant_memory_dependency";
    public static final String STALL_MEMORY_DEPENDENCY_METRIC_NAME = "stall_memory_dependency";
    public static final String INST_ISSUED_METRIC_NAME = "inst_issued";
    public static final String ISSUE_SLOTS_METRIC_NAME = "issue_slots";
    public static final String INST_SLOT_UTILIZATION_METRIC_NAME = "issue_slot_utilization";
    public static final String CF_ISSUED_METRIC_NAME = "cf_issued";
    public static final String LDST_ISSUED_METRIC_NAME = "ldst_issued";
    public static final String INST_EXECUTED_METRIC_NAME = "inst_executed";
    public static final String L1_SHARED_UTILIZATION_METRIC_NAME = "l1_shared_utilization";
    public static final String SHARED_UTILIZATION_METRIC_NAME = "shared_utilization";
    public static final String L2_UTILIZATION_METRIC_NAME = "l2_utilization";
    public static final String TEX_UTILIZATION_METRIC_NAME = "tex_utilization";
    public static final String DRAM_UTILIZATION_METRIC_NAME = "dram_utilization";
    public static final String SMEM_UTILIZATION_METRIC_NAME = "sysmem_utilization";
    public static final String SMEM_READ_UTILIZATION_METRIC_NAME = "sysmem_read_utilization";
    public static final String SMEM_WRITE_UTILIZATION_METRIC_NAME = "sysmem_write_utilization";
    public static final String LDST_FU_BUSY_METRIC_NAME = "ldst_fu_utilization";
    public static final String ALU_FU_BUSY_METRIC_NAME = "alu_fu_utilization";
    public static final String CF_FU_BUSY_METRIC_NAME = "cf_fu_utilization";
    public static final String TEX_FU_BUSY_METRIC_NAME = "tex_fu_utilization";
    public static final String SPECIAL_FU_BUSY_METRIC_NAME = "special_fu_utilization";
    public static final String SINGLE_PREC_FU_BUSY_METRIC_NAME = "single_precision_fu_utilization";
    public static final String DOUBLE_PREC_FU_BUSY_METRIC_NAME = "double_precision_fu_utilization";
    public static final String HALF_PREC_FU_BUSY_METRIC_NAME = "half_precision_fu_utilization";
    public static final String FP32_FLOPS_METRIC_NAME = "flops_sp";
    public static final String FP32ADD_FLOPS_METRIC_NAME = "flops_sp_add";
    public static final String FP32MUL_FLOPS_METRIC_NAME = "flops_sp_mul";
    public static final String FP32FMA_FLOPS_METRIC_NAME = "flops_sp_fma";
    public static final String FP32SPEC_FLOPS_METRIC_NAME = "flops_sp_special";
    public static final String FP64_FLOPS_METRIC_NAME = "flops_dp";
    public static final String FP64ADD_FLOPS_METRIC_NAME = "flops_dp_add";
    public static final String FP64MUL_FLOPS_METRIC_NAME = "flops_dp_mul";
    public static final String FP64FMA_FLOPS_METRIC_NAME = "flops_dp_fma";
    public static final String FP32_FLOP_COUNT_METRIC_NAME = "flop_count_sp";
    public static final String FP32ADD_FLOP_COUNT_METRIC_NAME = "flop_count_sp_add";
    public static final String FP32MUL_FLOP_COUNT_METRIC_NAME = "flop_count_sp_mul";
    public static final String FP32FMA_FLOP_COUNT_METRIC_NAME = "flop_count_sp_fma";
    public static final String FP32SPEC_FLOP_COUNT_METRIC_NAME = "flop_count_sp_special";
    public static final String FP64_FLOP_COUNT_METRIC_NAME = "flop_count_dp";
    public static final String FP64ADD_FLOP_COUNT_METRIC_NAME = "flop_count_dp_add";
    public static final String FP64MUL_FLOP_COUNT_METRIC_NAME = "flop_count_dp_mul";
    public static final String FP64FMA_FLOP_COUNT_METRIC_NAME = "flop_count_dp_fma";
    public static final String FP16_FLOP_COUNT_METRIC_NAME = "flop_count_hp";
    public static final String FP16ADD_FLOP_COUNT_METRIC_NAME = "flop_count_hp_add";
    public static final String FP16MUL_FLOP_COUNT_METRIC_NAME = "flop_count_hp_mul";
    public static final String FP16FMA_FLOP_COUNT_METRIC_NAME = "flop_count_hp_fma";
    public static final String FP32_INST_CLASS_METRIC_NAME = "inst_fp_32";
    public static final String FP64_INST_CLASS_METRIC_NAME = "inst_fp_64";
    public static final String FP16_INST_CLASS_METRIC_NAME = "inst_fp_16";
    public static final String INT_INST_CLASS_METRIC_NAME = "inst_integer";
    public static final String BITCONVERT_INST_CLASS_METRIC_NAME = "inst_bit_convert";
    public static final String CONTROL_INST_CLASS_METRIC_NAME = "inst_control";
    public static final String LDST_INST_CLASS_METRIC_NAME = "inst_compute_ld_st";
    public static final String COMM_INST_CLASS_METRIC_NAME = "inst_inter_thread_communication";
    public static final String MISC_INST_CLASS_METRIC_NAME = "inst_misc";
    public static final String NVLINK_TRANSMIT_THROUGHPUT = "nvlink_transmit_throughput";
    public static final String NVLINK_RECEIVE_THROUGHPUT = "nvlink_receive_throughput";
    public static final String NVLINK_TOTAL_DATA_TRANSMITTED = "nvlink_total_data_transmitted";
    public static final String NVLINK_TOTAL_DATA_RECEIVED = "nvlink_total_data_received";
    public static final String INST_EXECUTED_TEX_OPS = "inst_executed_tex_ops";
    public static final String INST_EXECUTED_LOCAL_LOADS = "inst_executed_local_loads";
    public static final String INST_EXECUTED_LOCAL_STORES = "inst_executed_local_stores";
    public static final String INST_EXECUTED_GLOBAL_LOADS = "inst_executed_global_loads";
    public static final String INST_EXECUTED_GLOBAL_STORES = "inst_executed_global_stores";
    public static final String INST_EXECUTED_GLOBAL_ATOMICS = "inst_executed_global_atomics";
    public static final String INST_EXECUTED_GLOBAL_REDUCTIONS = "inst_executed_global_reductions";
    public static final String INST_EXECUTED_SHARED_LOADS = "inst_executed_shared_loads";
    public static final String INST_EXECUTED_SHARED_STORES = "inst_executed_shared_stores";
    public static final String INST_EXECUTED_SHARED_ATOMICS = "inst_executed_shared_atomics";
    public static final String LOCAL_LOAD_REQUESTS = "local_load_requests";
    public static final String LOCAL_STORE_REQUESTS = "local_store_requests";
    public static final String GLOBAL_LOAD_REQUESTS = "global_load_requests";
    public static final String GLOBAL_ATOMIC_REQUESTS = "global_atomic_requests";
    public static final String GLOBAL_STORE_REQUESTS = "global_store_requests";
    public static final String GLOBAL_RED_REQUESTS = "global_reduction_requests";
    public static final String SHARED_LOAD_TRANSACTIONS = "shared_load_transactions";
    public static final String SHARED_STORE_TRANSACTIONS = "shared_store_transactions";
    public static final String L2_GLOBAL_ATOMIC_STORE_BYTES = "l2_global_atomic_store_bytes";
    public static final String L2_GLOBAL_LOAD_BYTES = "l2_global_load_bytes";
    public static final String L2_LOCAL_LOAD_BYTES = "l2_local_load_bytes";
    public static final String L2_SURFACE_LOAD_BYTES = "l2_surface_load_bytes";
    public static final String L2_SURFACE_ATOMIC_STORE_BYTES = "l2_surface_atomic_store_bytes";
    public static final String L2_GLOBAL_RED_BYTES = "l2_global_reduction_bytes";
    public static final String L2_LOCAL_GLOBAL_STORE_BYTES = "l2_local_global_store_bytes";
    public static final String L2_SURFACE_STORE_BYTES = "l2_surface_store_bytes";
    public static final String L2_SURFACE_RED_BYTES = "l2_surface_reduction_bytes";
    public static final String DRAM_READ_BYTES = "dram_read_bytes";
    public static final String DRAM_WRITE_BYTES = "dram_write_bytes";
    public static final String SURFACE_LOAD_REQUESTS = "surface_load_requests";
    public static final String SURFACE_ATOMIC_REQUESTS = "surface_atomic_requests";
    public static final String SURFACE_STORE_REQUESTS = "surface_store_requests";
    public static final String SURFACE_RED_REQUESTS = "surface_reduction_requests";
    public static final String TEX_CACHE_HIT_RATE = "tex_cache_hit_rate";
    public static final String INST_EXECUTED_SURFACE_ATOMICS = "inst_executed_surface_atomics";
    public static final String INST_EXECUTED_SURFACE_LOADS = "inst_executed_surface_loads";
    public static final String INST_EXECUTED_SURFACE_STORES = "inst_executed_surface_stores";
    public static final String INST_EXECUTED_SURFACE_REDUCTIONS = "inst_executed_surface_reductions";
    public static final String L2_TEX_HIT_RATE = "l2_tex_hit_rate";
    public static final String SYSMEM_READ_BYTES = "sysmem_read_bytes";
    public static final String SYSMEM_WRITE_BYTES = "sysmem_write_bytes";
    public static final String TEXTURE_LOAD_REQUESTS = "texture_load_requests";
    private static Map<Integer, Metric> metrics = new HashMap<Integer, Metric>();
    private static Map<String, Set<Metric>> metricNameMap = new HashMap<String, Set<Metric>>();
    private static Map<String, String> oldNewMetricNamesMap = new HashMap<String, String>();

    static {
        try {
            ArrayList<CuptiMetric> cuptiMetrics = NativeCupti.cuptiGetMetrics();
            for (CuptiMetric m : cuptiMetrics) {
                if (MetricManager.getMetric(m.id) != null) continue;
                MetricManager.createMetric(m.id, m.name, m.shortDesc, m.longDesc, CuptiMetricValueKind.valueOf(m.valueKind), CuptiMetricEvaluationMode.valueOf(m.evaluationMode));
            }
        }
        catch (Exception e2) {
            ViperException e2;
            if (!(e2 instanceof ViperException)) {
                e2 = new ViperException(e2);
            }
            ViperExceptionHandler.handle(ViperMessages.MetricManager_Fail_Title, ViperMessages.MetricManager_Fail_Message, e2);
        }
        oldNewMetricNamesMap.put(STALL_COMPUTE_METRIC_NAME, STALL_PIPE_BUSY_METRIC_NAME);
        oldNewMetricNamesMap.put(STALL_DATA_REQUEST_METRIC_NAME, STALL_MEMORY_DEPENDENCY_METRIC_NAME);
        oldNewMetricNamesMap.put(STALL_IMC_METRIC_NAME, STALL_CONSTANT_MEMORY_DEPENDENCY_METRIC_NAME);
        oldNewMetricNamesMap.put(FP32_FLOPS_METRIC_NAME, FP32_FLOP_COUNT_METRIC_NAME);
        oldNewMetricNamesMap.put(FP32ADD_FLOPS_METRIC_NAME, FP32ADD_FLOP_COUNT_METRIC_NAME);
        oldNewMetricNamesMap.put(FP32MUL_FLOPS_METRIC_NAME, FP32MUL_FLOP_COUNT_METRIC_NAME);
        oldNewMetricNamesMap.put(FP32FMA_FLOPS_METRIC_NAME, FP32FMA_FLOP_COUNT_METRIC_NAME);
        oldNewMetricNamesMap.put(FP32SPEC_FLOPS_METRIC_NAME, FP32SPEC_FLOP_COUNT_METRIC_NAME);
        oldNewMetricNamesMap.put(FP64_FLOPS_METRIC_NAME, FP64_FLOP_COUNT_METRIC_NAME);
        oldNewMetricNamesMap.put(FP64ADD_FLOPS_METRIC_NAME, FP64ADD_FLOP_COUNT_METRIC_NAME);
        oldNewMetricNamesMap.put(FP64MUL_FLOPS_METRIC_NAME, FP64MUL_FLOP_COUNT_METRIC_NAME);
        oldNewMetricNamesMap.put(FP64FMA_FLOPS_METRIC_NAME, FP64FMA_FLOP_COUNT_METRIC_NAME);
    }

    public static Metric createMetric(int id, String name, String shortDesc, String longDesc, CuptiMetricValueKind valueKind, CuptiMetricEvaluationMode evalMode) {
        Metric metric = metrics.get(id);
        if (metric == null) {
            metric = new Metric(id, name, shortDesc, longDesc, valueKind, evalMode);
            metrics.put(id, metric);
            if (name != null && !name.isEmpty()) {
                Set<Metric> metricSet = metricNameMap.get(name);
                if (metricSet == null) {
                    metricSet = new HashSet<Metric>();
                    metricNameMap.put(name, metricSet);
                }
                metricSet.add(metric);
            }
        }
        return metric;
    }

    public static Metric getMetric(int id) {
        return metrics.get(id);
    }

    public static Set<Metric> getMetrics(String metricName) {
        String newMetricName = oldNewMetricNamesMap.containsKey(metricName) ? oldNewMetricNamesMap.get(metricName) : metricName;
        Set<Metric> metricSet = metricNameMap.get(newMetricName);
        if (metricSet == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(metricSet);
    }
}

