/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public enum CuptiEnvironmentClocksThrottleReason {
    CUPTI_CLOCKS_THROTTLE_REASON_NONE(0, "No throttling"),
    CUPTI_CLOCKS_THROTTLE_REASON_GPU_IDLE(1, "GPU Idle"),
    CUPTI_CLOCKS_THROTTLE_REASON_USER_DEFINED_CLOCKS(2, "User defined"),
    CUPTI_CLOCKS_THROTTLE_REASON_SW_POWER_CAP(4, "SW power cap"),
    CUPTI_CLOCKS_THROTTLE_REASON_HW_SLOWDOWN(8, "HW showdown"),
    CUPTI_CLOCKS_THROTTLE_REASON_UNKNOWN(Integer.MIN_VALUE, "Unknown"),
    CUPTI_CLOCKS_THROTTLE_REASON_UNSUPPORTED(0x40000000, "Unsupported");

    private int code;
    private String name;
    private static Map<Integer, CuptiEnvironmentClocksThrottleReason> codeMap;

    static {
        codeMap = new HashMap<Integer, CuptiEnvironmentClocksThrottleReason>();
        CuptiEnvironmentClocksThrottleReason[] cuptiEnvironmentClocksThrottleReasonArray = CuptiEnvironmentClocksThrottleReason.values();
        int n = cuptiEnvironmentClocksThrottleReasonArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuptiEnvironmentClocksThrottleReason res = cuptiEnvironmentClocksThrottleReasonArray[n2];
            codeMap.put(res.getCode(), res);
            ++n2;
        }
    }

    private CuptiEnvironmentClocksThrottleReason(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static CuptiEnvironmentClocksThrottleReason[] getReasons(int clocksThrottleReasons) {
        ArrayList<CuptiEnvironmentClocksThrottleReason> list = new ArrayList<CuptiEnvironmentClocksThrottleReason>();
        for (Map.Entry<Integer, CuptiEnvironmentClocksThrottleReason> entry : codeMap.entrySet()) {
            int bit = clocksThrottleReasons & entry.getKey();
            if (bit <= 0) continue;
            list.add(entry.getValue());
        }
        return list.toArray(new CuptiEnvironmentClocksThrottleReason[list.size()]);
    }
}

