/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.ConnectionControl;
import com.nvidia.viper.ui.ImportMultipleFilesControl;
import com.nvidia.viper.ui.SessionEditor;
import com.nvidia.viper.ui.SessionEditorInput;
import com.nvidia.viper.ui.analysis.AnalysisViewMode;
import java.io.File;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ImportRebelReportWizard
extends Wizard
implements IImportWizard {
    private ImportRebelReportPage importPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        Session session = new Session();
        session.setAnalysis(new Analysis());
        try {
            SessionEditor editor;
            IWorkbenchPage activePage;
            IWorkbenchWindow workbenchWindow;
            String[] filenames = this.importPage.multipleFilesControl.getFiles();
            session.setRebelReportPath(filenames[0]);
            File file = new File(filenames[0]);
            session.setName(file.getName());
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (activePage = workbenchWindow.getActivePage()) != null && (editor = (SessionEditor)activePage.openEditor((IEditorInput)new SessionEditorInput(session), "com.nvidia.viper.sessioneditor")) != null) {
                editor.scaleToFit();
                editor.setDirty(true);
                session.setDirty(true);
            }
            session.getAnalysis().setCurrentAnalysisMode(AnalysisViewMode.rebelreport);
        }
        catch (ViperException e) {
            ViperExceptionHandler.handle("Import Failed", e.getMessage(), e);
        }
        catch (Exception e2) {
            ViperException e2;
            if (!(e2 instanceof ViperException)) {
                e2 = new ViperException(e2);
            }
            ViperExceptionHandler.handle("Import Failed", e2.getMessage(), e2);
        }
        Viper.setWelcomePageStandby(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        return true;
    }

    public void addPages() {
        this.importPage = new ImportRebelReportPage("Import Rebel Report");
        this.addPage((IWizardPage)this.importPage);
        super.addPages();
    }

    class ImportRebelReportPage
    extends WizardPage
    implements Listener {
        private ImportMultipleFilesControl multipleFilesControl;
        private ConnectionControl connectionControl;

        protected ImportRebelReportPage(String pageName) {
            super(pageName);
            this.setTitle("Rebel report");
            this.setDescription("Select one or more rebel report files for import.");
        }

        public void createControl(Composite parent) {
            this.setPageComplete(false);
            Composite mainComposite = new Composite(parent, 0);
            mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout mainLayout = new GridLayout(2, false);
            mainComposite.setLayout((Layout)mainLayout);
            Label labelConnection = new Label(mainComposite, 0);
            labelConnection.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            labelConnection.setText(ViperMessages.Connection_Label);
            this.connectionControl = new ConnectionControl(mainComposite);
            this.connectionControl.setLayoutData(new GridData(4, 4, false, false));
            Label multipleFilesLable = new Label(mainComposite, 0);
            multipleFilesLable.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
            multipleFilesLable.setText("Rebel report files:");
            this.multipleFilesControl = new ImportMultipleFilesControl(mainComposite, this.connectionControl);
            this.multipleFilesControl.setLayoutData(new GridData(4, 4, true, true, 2, 1));
            this.multipleFilesControl.getMultipleFilesListControl().addListener(9, (Listener)this);
            this.setControl((Control)mainComposite);
        }

        public void handleEvent(Event event) {
            Widget widget = event.widget;
            if (widget == this.multipleFilesControl.getMultipleFilesListControl()) {
                this.multipleFilesControl.getMultipleFilesListControl().getItemCount();
                if (this.multipleFilesControl.getMultipleFilesListControl().getItemCount() > 0) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                } else {
                    this.setPageComplete(false);
                }
            }
        }
    }
}

