/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.TimeFormatter;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;

public class TimeRectangleFigure
extends RoundedRectangle {
    protected static final int X_MARGIN = 2;
    protected static final int Y_MARGIN = 2;
    private String timeStr = null;
    private Point center = null;

    public void setTime(long time) {
        TimeFormatter formatter = new TimeFormatter(time);
        this.timeStr = formatter.format(time, true);
        this.updateBounds();
    }

    public void setCenter(int x, int y) {
        this.center = new Point(x, y);
        this.updateBounds();
    }

    protected void updateBounds() {
        if (this.center != null && this.timeStr != null) {
            int leading = FigureUtilities.getFontMetrics((Font)this.getFont()).getLeading();
            Dimension textSize = FigureUtilities.getStringExtents((String)this.timeStr, (Font)this.getFont());
            if (textSize.width % 2 == 0) {
                ++textSize.width;
            }
            textSize.expand(4, leading + 4);
            this.setBounds(new Rectangle(this.center.x - textSize.width / 2, this.center.y - textSize.height / 2, textSize.width, textSize.height));
        }
    }

    protected void fillShape(Graphics g) {
        super.fillShape(g);
        Rectangle textArea = this.getClientArea();
        Point textLoc = new Point(textArea.x + 2, textArea.y + 2);
        g.drawText(this.timeStr, textLoc);
    }
}

