/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.internal.core.index.FileContentKey;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.pdom.ASTFilePathResolver;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.YieldableIndexLock;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.db.DBProperties;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacro;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroReferenceName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.core.runtime.CoreException;

public class WritablePDOM
extends PDOM
implements IWritableIndexFragment {
    private boolean fClearedBecauseOfVersionMismatch = false;
    private boolean fCreatedFromScratch = false;
    private ASTFilePathResolver fPathResolver;
    private PDOMFile fileBeingUpdated;
    private PDOMFile uncommittedFile;
    private FileContentKey uncommittedKey;

    public WritablePDOM(File dbPath, IIndexLocationConverter locationConverter, Map<String, IPDOMLinkageFactory> linkageFactoryMappings) throws CoreException {
        this(dbPath, locationConverter, ChunkCache.getSharedInstance(), linkageFactoryMappings);
    }

    public WritablePDOM(File dbPath, IIndexLocationConverter locationConverter, ChunkCache cache, Map<String, IPDOMLinkageFactory> linkageFactoryMappings) throws CoreException {
        super(dbPath, locationConverter, cache, linkageFactoryMappings);
    }

    public void setASTFilePathResolver(ASTFilePathResolver resolver) {
        this.fPathResolver = resolver;
    }

    @Override
    public IIndexFragmentFile addFile(int linkageID, IIndexFileLocation location, ISignificantMacros sigMacros) throws CoreException {
        if (this.uncommittedKey != null && this.uncommittedKey.equals(new FileContentKey(linkageID, location, sigMacros))) {
            return this.uncommittedFile;
        }
        return super.addFile(linkageID, location, sigMacros);
    }

    @Override
    public IIndexFragmentFile addUncommittedFile(int linkageID, IIndexFileLocation location, ISignificantMacros significantMacros) throws CoreException {
        this.uncommittedKey = new FileContentKey(linkageID, location, significantMacros);
        this.fileBeingUpdated = this.getFile(linkageID, location, significantMacros);
        PDOMLinkage linkage = this.createLinkage(linkageID);
        this.uncommittedFile = new PDOMFile(linkage, location, linkageID, significantMacros);
        return this.uncommittedFile;
    }

    @Override
    public IIndexFragmentFile commitUncommittedFile() throws CoreException {
        PDOMFile file;
        int unresolvedIncludeStateChange;
        if (this.uncommittedFile == null) {
            return null;
        }
        int defectiveStateChange = this.uncommittedFile.getTimestamp() == 0L ? 1 : 0;
        int n = unresolvedIncludeStateChange = this.uncommittedFile.hasUnresolvedInclude() ? 1 : 0;
        if (this.fileBeingUpdated == null) {
            file = this.uncommittedFile;
            this.getFileIndex().insert(file.getRecord());
        } else {
            if (this.fileBeingUpdated.getTimestamp() == 0L) {
                --defectiveStateChange;
            }
            if (this.fileBeingUpdated.hasUnresolvedInclude()) {
                --unresolvedIncludeStateChange;
            }
            this.fileBeingUpdated.replaceContentsFrom(this.uncommittedFile);
            file = this.fileBeingUpdated;
            this.fileBeingUpdated = null;
        }
        if (defectiveStateChange > 0) {
            this.getIndexOfDefectiveFiles().insert(file.getRecord());
        } else if (defectiveStateChange < 0) {
            this.getIndexOfDefectiveFiles().delete(file.getRecord());
        }
        if (unresolvedIncludeStateChange > 0) {
            this.getIndexOfFilesWithUnresolvedIncludes().insert(file.getRecord());
        } else if (unresolvedIncludeStateChange < 0) {
            this.getIndexOfFilesWithUnresolvedIncludes().delete(file.getRecord());
        }
        this.fEvent.fFilesWritten.add(this.uncommittedKey.getLocation());
        this.uncommittedFile = null;
        this.uncommittedKey = null;
        return file;
    }

    @Override
    public void clearUncommittedFile() throws CoreException {
        if (this.uncommittedFile != null) {
            try {
                this.uncommittedFile.clear();
                this.uncommittedFile.delete();
            }
            finally {
                this.uncommittedFile = null;
                this.uncommittedKey = null;
                this.fileBeingUpdated = null;
            }
        }
    }

    @Override
    public void addFileContent(IIndexFragmentFile sourceFile, IWritableIndex.IncludeInformation[] includes, IASTPreprocessorStatement[] macros, IASTName[][] names, ASTFilePathResolver pathResolver, YieldableIndexLock lock) throws CoreException, InterruptedException {
        assert (sourceFile.getIndexFragment() == this);
        PDOMFile pdomFile = (PDOMFile)sourceFile;
        pdomFile.addMacros(macros);
        ASTFilePathResolver origResolver = this.fPathResolver;
        this.fPathResolver = pathResolver;
        try {
            pdomFile.addNames(names, lock);
        }
        finally {
            this.fPathResolver = origResolver;
        }
        pdomFile.addIncludesTo(includes);
        IIndexFileLocation location = pdomFile.getLocation();
        if (location != null) {
            this.fEvent.fClearedFiles.remove(location);
            this.fEvent.fFilesWritten.add(location);
        }
    }

    @Override
    public void clearFile(IIndexFragmentFile file) throws CoreException {
        PDOMFile includedBy;
        assert (file.getIndexFragment() == this);
        IIndexFileLocation location = file.getLocation();
        PDOMFile pdomFile = (PDOMFile)file;
        pdomFile.clear();
        IIndexInclude include = pdomFile.getParsedInContext();
        if (include != null && (includedBy = (PDOMFile)include.getIncludedBy()).getTimestamp() > 0L) {
            this.getIndexOfFilesWithUnresolvedIncludes().insert(includedBy.getRecord());
        }
        this.fEvent.fClearedFiles.add(location);
    }

    @Override
    public void clear() throws CoreException {
        super.clear();
    }

    @Override
    public void flush() throws CoreException {
        super.flush();
    }

    @Override
    public void setProperty(String propertyName, String value) throws CoreException {
        if ("org.eclipse.cdt.internal.core.index.fragment.format.id".equals(propertyName) || "org.eclipse.cdt.internal.core.index.fragment.format.version".equals(propertyName)) {
            throw new IllegalArgumentException("Property " + value + " may not be written to");
        }
        new DBProperties(this.db, 2064L).setProperty(propertyName, value);
    }

    public void rewriteLocations(IIndexLocationConverter newConverter) throws CoreException {
        final ArrayList pdomfiles = new ArrayList();
        this.getFileIndex().accept(new IBTreeVisitor(){

            @Override
            public int compare(long record) throws CoreException {
                return 0;
            }

            @Override
            public boolean visit(long record) throws CoreException {
                PDOMFile file = PDOMFile.recreateFile(WritablePDOM.this, record);
                pdomfiles.add(file);
                return true;
            }
        });
        this.clearFileIndex();
        ArrayList<PDOMFile> notConverted = new ArrayList<PDOMFile>();
        for (PDOMFile file : pdomfiles) {
            String internalFormat = newConverter.toInternalFormat(file.getLocation());
            if (internalFormat != null) {
                file.setInternalLocation(internalFormat);
                this.getFileIndex().insert(file.getRecord());
                continue;
            }
            notConverted.add(file);
        }
        for (PDOMFile file : notConverted) {
            file.convertIncludersToUnresolved();
            file.clear();
        }
    }

    boolean isClearedBecauseOfVersionMismatch() {
        return this.fClearedBecauseOfVersionMismatch;
    }

    void setClearedBecauseOfVersionMismatch(boolean clearedBecauseOfVersionMismatch) {
        this.fClearedBecauseOfVersionMismatch = clearedBecauseOfVersionMismatch;
    }

    boolean isCreatedFromScratch() {
        return this.fCreatedFromScratch;
    }

    void setCreatedFromScratch(boolean createdFromScratch) {
        this.fCreatedFromScratch = createdFromScratch;
    }

    @Override
    protected final boolean isPermanentlyReadOnly() {
        return false;
    }

    private PDOMFile getBestFile(int linkageID, IIndexFileLocation location, ITranslationUnit tu) throws CoreException {
        IIndexFragmentFile[] files = this.getFiles(linkageID, location);
        IIndexFragmentFile best = null;
        int bestScore = -1;
        IIndexFragmentFile[] iIndexFragmentFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragmentFile file = iIndexFragmentFileArray[n2];
            int score = file.getMacros().length * 2;
            if (tu != null && TranslationUnit.isSourceFile(TranslationUnit.getParsedInContext(file), tu.getCProject().getProject())) {
                ++score;
            }
            if (score > bestScore) {
                bestScore = score;
                best = file;
            }
            ++n2;
        }
        return (PDOMFile)best;
    }

    public PDOMFile getFileForASTNode(int linkageID, IASTNode node) throws CoreException {
        ISignificantMacros sigMacros;
        IASTFileLocation loc;
        if (this.fPathResolver != null && node != null && (loc = node.getFileLocation()) != null && (sigMacros = this.getSignificantMacros(node, loc)) != null) {
            IIndexFileLocation location = this.fPathResolver.resolveASTPath(loc.getFileName());
            if (this.uncommittedKey != null && this.uncommittedKey.equals(new FileContentKey(linkageID, location, sigMacros))) {
                return this.fileBeingUpdated != null ? this.fileBeingUpdated : this.uncommittedFile;
            }
            return this.getBestFile(linkageID, location, node.getTranslationUnit().getOriginatingTranslationUnit());
        }
        return null;
    }

    private ISignificantMacros getSignificantMacros(IASTNode node, IASTFileLocation loc) throws CoreException {
        IASTPreprocessorIncludeStatement owner = loc.getContextInclusionStatement();
        if (owner != null) {
            return owner.getSignificantMacros();
        }
        IASTTranslationUnit tu = node.getTranslationUnit();
        if (tu != null) {
            return tu.getSignificantMacros();
        }
        return null;
    }

    @Override
    public boolean hasLastingDefinition(PDOMBinding binding) throws CoreException {
        if (this.fileBeingUpdated == null) {
            return binding.hasDefinition();
        }
        PDOMName name = binding.getFirstDefinition();
        while (name != null) {
            if (!this.fileBeingUpdated.getPDOM().equals(name.getPDOM()) || this.fileBeingUpdated.getRecord() != name.getFileRecord()) {
                return true;
            }
            name = name.getNextInBinding();
        }
        return false;
    }

    @Override
    protected boolean isCommitted(PDOMName name) throws CoreException {
        return this.uncommittedFile == null || !this.uncommittedFile.getPDOM().equals(name.getPDOM()) || this.uncommittedFile.getRecord() != name.getFileRecord();
    }

    @Override
    protected boolean isCommitted(PDOMMacro name) throws CoreException {
        return this.uncommittedFile == null || !this.uncommittedFile.getPDOM().equals(name.getPDOM()) || this.uncommittedFile.getRecord() != name.getFileRecord();
    }

    @Override
    protected boolean isCommitted(PDOMMacroReferenceName name) throws CoreException {
        return this.uncommittedFile == null || !this.uncommittedFile.getPDOM().equals(name.getPDOM()) || this.uncommittedFile.getRecord() != name.getFileRecord();
    }

    @Override
    public long getDatabaseSizeBytes() {
        return this.getDB().getSizeBytes();
    }
}

