/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.tag;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.tag.ITag;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.tag.PDOMTag;
import org.eclipse.core.runtime.CoreException;

public class PDOMTagSynchronizer
implements IBTreeVisitor {
    private final Database db;
    private final Long searchRecord;
    private final Map<String, ITag> newTags;
    private final List<Long> toRemove = new LinkedList<Long>();
    private final List<Long> toInsert = new LinkedList<Long>();

    public PDOMTagSynchronizer(Database db, Long searchRecord, Map<String, ITag> newTags) {
        this.db = db;
        this.searchRecord = searchRecord;
        this.newTags = newTags;
    }

    public boolean synchronize(BTree tree) {
        for (Long rm : this.toRemove) {
            try {
                long record = rm;
                tree.delete(record);
                this.db.free(record);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        this.toRemove.clear();
        for (Long insert : this.toInsert) {
            try {
                tree.insert(insert);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                try {
                    this.db.free(insert);
                }
                catch (CoreException e1) {
                    CCorePlugin.log(e1);
                }
            }
        }
        this.toInsert.clear();
        return true;
    }

    @Override
    public int compare(long test_record) throws CoreException {
        long test_node = new PDOMTag(this.db, test_record).getNode();
        return Long.valueOf(test_node).compareTo(this.searchRecord);
    }

    @Override
    public boolean visit(long existing_record) throws CoreException {
        PDOMTag existingTag = new PDOMTag(this.db, existing_record);
        String taggerId = existingTag.getTaggerId();
        ITag newTag = this.newTags.remove(taggerId);
        if (newTag == null) {
            this.toRemove.add(existing_record);
        } else if (newTag.getDataLen() > existingTag.getDataLen()) {
            this.toRemove.add(existing_record);
            PDOMTag pdomTag = existingTag.cloneWith(newTag.getBytes(0, -1));
            if (pdomTag != null) {
                this.toInsert.add(pdomTag.getRecord());
            }
        } else if (!existingTag.putBytes(0, newTag.getBytes(0, -1), -1)) {
            CCorePlugin.log("Unable to modify data of tag record " + existing_record + " from taggerId " + taggerId);
        }
        return true;
    }
}

