/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.chart.ui;

import com.nvidia.viper.birt.Activator;
import com.nvidia.viper.chart.BirtChartFactory;
import com.nvidia.viper.chart.IColorDefinitionsManager;
import com.nvidia.viper.chart.ui.IViperChart;
import com.nvidia.viper.chart.ui.SWTColorsManager;
import com.nvidia.viper.chart.ui.SWTViperChartEventHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.script.AbstractScriptHandler;
import org.eclipse.birt.chart.script.IScriptClassLoader;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ChartCanvas
extends Canvas
implements PaintListener,
ControlListener {
    private static final Point REFERENCE_SIZE = new Point(16, 16);
    private IViperChart chart;
    private Image buffer;
    private final AtomicBoolean isPainting = new AtomicBoolean(false);
    private Point preferredSize = null;
    private static IColorDefinitionsManager colorManager;

    public ChartCanvas(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(this);
        this.addControlListener(this);
    }

    public void paintControl(PaintEvent e) {
        if (this.buffer == null) {
            this.updateBuffer(this.getBirtChart());
        }
        if (this.buffer != null) {
            e.gc.drawImage(this.buffer, 0, 0);
        }
    }

    private synchronized Chart getBirtChart() {
        if (this.chart != null) {
            colorManager = SWTColorsManager.forDisplay(this.getDisplay());
            return BirtChartFactory.createBirtChart(this.chart, colorManager);
        }
        return null;
    }

    public synchronized void setChart(IViperChart chart) {
        this.chart = chart;
        this.preferredSize = null;
        this.getParent().layout(new Control[]{this});
        this.redraw();
    }

    public void controlMoved(ControlEvent e) {
    }

    private void updateBuffer(Chart birtChart) {
        if (birtChart == null || !this.isPainting.compareAndSet(false, true)) {
            return;
        }
        try {
            Image oldBuffer;
            Exception paintError;
            block20: {
                paintError = null;
                Rectangle re = this.getClientArea();
                Rectangle adjustedRe = new Rectangle(0, 0, re.width, re.height);
                if (adjustedRe.width <= 0 || adjustedRe.height <= 0) {
                    if (this.buffer != null && !this.buffer.isDisposed()) {
                        this.buffer.dispose();
                        this.buffer = null;
                    }
                    return;
                }
                oldBuffer = null;
                if (this.buffer == null) {
                    this.buffer = new Image((Device)Display.getDefault(), adjustedRe);
                } else {
                    Rectangle ore = this.buffer.getBounds();
                    oldBuffer = this.buffer;
                    if (!adjustedRe.equals((Object)ore)) {
                        this.buffer = new Image((Device)Display.getDefault(), adjustedRe);
                    }
                }
                GC gc = new GC((Drawable)this.buffer);
                gc.setForeground(Display.getDefault().getSystemColor(1));
                gc.fillRectangle(this.buffer.getBounds());
                Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)adjustedRe.width, (double)adjustedRe.height);
                IDeviceRenderer deviceRenderer = null;
                try {
                    try {
                        deviceRenderer = PluginSettings.instance().getDevice("dv.SWT");
                        deviceRenderer.setProperty("device.output.context", (Object)gc);
                        bo.scale(72.0 / (double)deviceRenderer.getDisplayServer().getDpiResolution());
                        Generator gr = Generator.instance();
                        RunTimeContext rtc = new RunTimeContext();
                        ScriptHandler handler = new ScriptHandler();
                        handler.setScriptClassLoader(new IScriptClassLoader(){

                            public Class<?> loadClass(String className, ClassLoader parentLoader) throws ClassNotFoundException {
                                return ChartCanvas.class.getClassLoader().loadClass(className);
                            }
                        });
                        handler.register("beforeDrawAxisLabel", SWTViperChartEventHandler.class.getName());
                        rtc.setScriptHandler((AbstractScriptHandler)handler);
                        GeneratedChartState state = gr.build(deviceRenderer.getDisplayServer(), birtChart, bo, null, rtc, null);
                        gr.render(deviceRenderer, state);
                        colorManager = SWTColorsManager.forDisplay(this.getDisplay());
                    }
                    catch (Exception ex) {
                        Activator.log(ex);
                        paintError = ex;
                        gc.dispose();
                        if (deviceRenderer != null) {
                            deviceRenderer.dispose();
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    gc.dispose();
                    if (deviceRenderer != null) {
                        deviceRenderer.dispose();
                    }
                    throw throwable;
                }
                gc.dispose();
                if (deviceRenderer != null) {
                    deviceRenderer.dispose();
                }
            }
            if (paintError != null) {
                this.buffer = oldBuffer;
            }
            if (oldBuffer != null && oldBuffer != this.buffer) {
                oldBuffer.dispose();
            }
        }
        finally {
            this.isPainting.set(false);
        }
    }

    public void controlResized(ControlEvent e) {
        if (!this.isDisposed()) {
            this.updateBuffer(this.getBirtChart());
            this.redraw();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.chart != null && (changed || this.preferredSize == null)) {
            GC gc = new GC((Drawable)this);
            Point extent = gc.textExtent("W");
            this.preferredSize = new Point(this.chart.getWidth() * extent.x / ChartCanvas.REFERENCE_SIZE.x, this.chart.getHeight() * extent.y / ChartCanvas.REFERENCE_SIZE.y);
        }
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        return super.computeSize(wHint, hHint, changed);
    }

    public static IColorDefinitionsManager getColorManager() {
        return colorManager;
    }
}

