/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;

public class SystemShowPreferencesPageAction
extends SystemBaseAction
implements IViewActionDelegate {
    private PreferenceManager preferenceManager;
    private String[] preferencePageIDs;
    private String preferencePageCategory;

    public SystemShowPreferencesPageAction() {
        super("temp label", null);
    }

    public void setPreferencePageID(String preferencePageID) {
        this.setPreferencePageID(new String[]{preferencePageID});
    }

    public void setPreferencePageID(String[] preferencePageIDs) {
        this.allowOnMultipleSelection(false);
        this.setSelectionSensitive(false);
        this.preferencePageIDs = preferencePageIDs;
    }

    public void setPreferencePageCategory(String preferencePageCategory) {
        this.preferencePageCategory = preferencePageCategory;
    }

    public void init(IViewPart view) {
        this.setShell(view.getSite().getShell());
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run() {
        PreferenceManager pm = this.getPreferenceManager();
        if (pm != null) {
            this.shell = RSEUIPlugin.getTheSystemRegistryUI().getShell();
            WorkbenchPreferenceDialog d = new WorkbenchPreferenceDialog(this.shell, pm);
            d.create();
            String id = "org.eclipse.ui.preference_dialog_context";
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)d.getShell(), id);
            d.open();
        }
    }

    public PreferenceManager getPreferenceManager() {
        if (this.preferenceManager == null) {
            this.preferenceManager = new PreferenceManager('/');
            PreferenceManager workbenchMgr = PlatformUI.getWorkbench().getPreferenceManager();
            List pageContributions = workbenchMgr.getElements(1);
            for (IPreferenceNode prefNode : pageContributions) {
                boolean match = false;
                String prefNodeID = prefNode.getId();
                if (this.preferencePageCategory == null) {
                    match = this.testForMatch(prefNodeID);
                } else if (prefNodeID.equals(this.preferencePageCategory) && (prefNode = this.searchForSubPage(prefNode, prefNodeID)) != null) {
                    match = true;
                }
                if (!match) continue;
                this.preferenceManager.addToRoot(prefNode);
            }
        }
        return this.preferenceManager;
    }

    private IPreferenceNode searchForSubPage(IPreferenceNode parent, String prefNodeID) {
        IPreferenceNode match = null;
        IPreferenceNode[] subNodes = parent.getSubNodes();
        if (subNodes != null) {
            int idx = 0;
            while (match == null && idx < subNodes.length) {
                match = this.testForMatch(subNodes[idx].getId()) ? subNodes[idx] : this.searchForSubPage(subNodes[idx], prefNodeID);
                ++idx;
            }
        }
        return match;
    }

    private boolean testForMatch(String prefNodeID) {
        boolean match = false;
        int idx = 0;
        while (!match && idx < this.preferencePageIDs.length) {
            if (prefNodeID.equals(this.preferencePageIDs[idx])) {
                match = true;
            }
            ++idx;
        }
        return match;
    }
}

