/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.dameng.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.dameng.model.DamengTablespace;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ByteNumberFormat;

public class DamengDataFile
implements DBSObject {
    private final DamengTablespace tablespace;
    private String name;
    private Timestamp createTime;
    private Status status;
    private Long totalSize;
    private Long freeSize;
    private Integer pageSize;
    private Long maxSize;
    private Boolean autoExtend;
    private Long nextSize;
    private String mirrorPath;
    private Long realFreeSize;

    public DamengDataFile(DamengTablespace tablespace, ResultSet dbResult) {
        this.tablespace = tablespace;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PATH");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.status = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"STATUS$") == 1 ? Status.ONLINE : Status.OFFLINE;
        this.pageSize = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PAGE_SIZE");
        this.totalSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"TOTAL_SIZE") * (long)this.pageSize.intValue();
        this.freeSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"FREE_SIZE") * (long)this.pageSize.intValue();
        this.autoExtend = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"AUTO_EXTEND") == 1;
        this.maxSize = (long)JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"MAX_SIZE") * 1024L * 1024L;
        this.nextSize = (long)JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"NEXT_SIZE") * 1024L * 1024L;
        this.mirrorPath = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"MIRROR_PATH");
        this.realFreeSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"REAL_FREE_SIZE") * (long)this.pageSize.intValue();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    public DBSObject getParentObject() {
        return this.tablespace;
    }

    public DBPDataSource getDataSource() {
        return this.tablespace.getDataSource();
    }

    @Property(viewable=true, formatter=ByteNumberFormat.class)
    public Long getTotalSize() {
        return this.totalSize;
    }

    @Property(viewable=true, formatter=ByteNumberFormat.class)
    public Long getFreeSize() {
        return this.freeSize;
    }

    @Property(viewable=true)
    public Boolean getAutoExtend() {
        return this.autoExtend;
    }

    @Property(viewable=true, formatter=ByteNumberFormat.class)
    public Long getMaxSize() {
        return this.maxSize;
    }

    @Property(viewable=true)
    public Status getStatus() {
        return this.status;
    }

    @Property(viewable=true)
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=true, formatter=ByteNumberFormat.class)
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Property(viewable=true, formatter=ByteNumberFormat.class)
    public Long getNextSize() {
        return this.nextSize;
    }

    @Property(viewable=true)
    public String getMirrorPath() {
        return this.mirrorPath;
    }

    @Property(viewable=true, formatter=ByteNumberFormat.class)
    public Long getRealFreeSize() {
        return this.realFreeSize;
    }

    public static enum Status {
        ONLINE,
        OFFLINE;

    }
}

