/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.math.BigDecimal;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldHaveScale;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Numbers;

public class BigDecimals
extends Numbers<BigDecimal> {
    private static final BigDecimals INSTANCE = new BigDecimals();

    public static BigDecimals instance() {
        return INSTANCE;
    }

    BigDecimals() {
    }

    public BigDecimals(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected BigDecimal zero() {
        return BigDecimal.ZERO;
    }

    @Override
    protected BigDecimal one() {
        return BigDecimal.ONE;
    }

    @Override
    protected BigDecimal absDiff(BigDecimal actual, BigDecimal other) {
        return actual.subtract(other).abs();
    }

    @Override
    protected boolean isGreaterThan(BigDecimal value, BigDecimal other) {
        return value.subtract(other).compareTo(BigDecimal.ZERO) > 0;
    }

    @Override
    protected boolean areEqual(BigDecimal value1, BigDecimal value2) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        return value1.compareTo(value2) == 0;
    }

    public void assertHasScale(AssertionInfo info, BigDecimal actual, int expectedScale) {
        BigDecimals.assertNotNull(info, actual);
        if (this.areEqual(actual.scale(), expectedScale)) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveScale.shouldHaveScale(actual, expectedScale));
    }
}

