/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.permissions.KaAnalysisPermissionRegistry;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinAction$shouldSkipConversionOfErroneousCode$lambda$0$;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinActionKt;
import org.jetbrains.kotlin.idea.base.codeInsight.JavaToKotlinConversionUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.KotlinPlatformUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.DocumentUtilsKt;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.statistics.ConversionType;
import org.jetbrains.kotlin.idea.statistics.J2KFusCollector;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.ExternalCodeProcessing;
import org.jetbrains.kotlin.j2k.FilesResult;
import org.jetbrains.kotlin.j2k.J2kConverterExtension;
import org.jetbrains.kotlin.j2k.J2kPostprocessorExtension;
import org.jetbrains.kotlin.j2k.J2kPreprocessorExtension;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/actions/JavaToKotlinAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getSelectedWritableJavaFiles", "", "Lcom/intellij/psi/PsiJavaFile;", "showNothingToConvertErrorMessage", "project", "Lcom/intellij/openapi/project/Project;", "shouldSkipConversionOfErroneousCode", "", "javaFiles", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "isEnabled", "Handler", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nJavaToKotlinAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaToKotlinAction.kt\norg/jetbrains/kotlin/idea/actions/JavaToKotlinAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,341:1\n1788#2,4:342\n12970#3,2:346\n12970#3,2:348\n430#4,11:350\n453#4:361\n*S KotlinDebug\n*F\n+ 1 JavaToKotlinAction.kt\norg/jetbrains/kotlin/idea/actions/JavaToKotlinAction\n*L\n283#1:342,4\n324#1:346,2\n332#1:348,2\n282#1:350,11\n282#1:361\n*E\n"})
public final class JavaToKotlinAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        if (module == null) {
            return;
        }
        Module module2 = module;
        List<PsiJavaFile> javaFiles = this.getSelectedWritableJavaFiles(e);
        if (javaFiles.isEmpty()) {
            this.showNothingToConvertErrorMessage(project2);
            return;
        }
        J2kConverterExtension.Kind j2kKind = JavaToKotlinActionKt.getJ2kKind$default(false, 1, null);
        J2kConverterExtension j2kConverterExtension = J2kConverterExtension.Companion.extension(j2kKind);
        if (this.shouldSkipConversionOfErroneousCode(javaFiles, project2)) {
            return;
        }
        if (j2kConverterExtension.doCheckBeforeConversion(project2, module2)) {
            Handler.convertFiles$default(Handler.INSTANCE, javaFiles, project2, module2, false, false, false, 56, null);
        } else {
            j2kConverterExtension.setUpAndConvert(project2, module2, javaFiles, (Function3<? super List<? extends PsiJavaFile>, ? super Project, ? super Module, Unit>)((Function3)new Function3<List<? extends PsiJavaFile>, Project, Module, Unit>((Object)Handler.INSTANCE){

                public final void invoke(List<? extends PsiJavaFile> p0, Project p1, Module p2) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    Handler.convertFiles$default((Handler)this.receiver, p0, p1, p2, false, false, false, 56, null);
                }
            }));
        }
    }

    private final List<PsiJavaFile> getSelectedWritableJavaFiles(AnActionEvent e) {
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile[] virtualFilesAndDirectories = virtualFileArray;
        Project project = e.getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)FileUtils.getAllFilesRecursively(virtualFilesAndDirectories)), arg_0 -> JavaToKotlinAction.getSelectedWritableJavaFiles$lambda$0(psiManager2, arg_0)), JavaToKotlinAction::getSelectedWritableJavaFiles$lambda$1), JavaToKotlinAction::getSelectedWritableJavaFiles$lambda$2));
    }

    private final void showNothingToConvertErrorMessage(Project project) {
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(KotlinBundle.message((String)"action.j2k.error.nothing.to.convert", (Object[])new Object[0]), MessageType.ERROR, null).createBalloon().showInCenterOf(statusBar.getComponent());
    }

    private final boolean shouldSkipConversionOfErroneousCode(List<? extends PsiJavaFile> javaFiles, Project project) {
        String string;
        int n;
        PsiErrorElement psiErrorElement = (PsiErrorElement)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)javaFiles), JavaToKotlinAction::shouldSkipConversionOfErroneousCode$lambda$0));
        if (psiErrorElement == null) {
            return false;
        }
        PsiErrorElement firstSyntaxError = psiErrorElement;
        Iterable $this$count$iv = javaFiles;
        boolean $i$f$count2 = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                PsiJavaFile it = (PsiJavaFile)element$iv;
                boolean bl = false;
                if (!PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)it)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int count = n;
        boolean bl = $this$count$iv = count > 0;
        if (_Assertions.ENABLED && !$this$count$iv) {
            String $i$f$count2 = "Assertion failed";
            throw new AssertionError((Object)$i$f$count2);
        }
        String string2 = firstSyntaxError.getContainingFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String firstFileName = string2;
        if (count == 1) {
            var8_12 = new Object[]{firstFileName};
            string = KotlinBundle.message((String)"action.j2k.correction.errors.single", (Object[])var8_12);
        } else {
            var8_12 = new Object[]{firstFileName, count - 1};
            string = KotlinBundle.message((String)"action.j2k.correction.errors.multiple", (Object[])var8_12);
        }
        String question = string;
        String okText = KotlinBundle.message((String)"action.j2k.correction.investigate", (Object[])new Object[0]);
        String cancelText = KotlinBundle.message((String)"action.j2k.correction.proceed", (Object[])new Object[0]);
        if (Messages.showOkCancelDialog((Project)project, (String)question, (String)Handler.INSTANCE.getTitle(), (String)okText, (String)cancelText, (Icon)Messages.getWarningIcon()) == 0) {
            PsiElement psiElement = firstSyntaxError.getNavigationElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getNavigationElement(...)");
            NavigationUtil.activateFileWithPsiElement$default((PsiElement)psiElement, (boolean)false, (int)2, null);
            return true;
        }
        return false;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(this.isEnabled(e));
    }

    private final boolean isEnabled(AnActionEvent e) {
        boolean bl;
        block10: {
            VirtualFile p0;
            VirtualFile element$iv;
            int n;
            int n2;
            boolean $i$f$any;
            VirtualFile[] $this$any$iv;
            if (KotlinPlatformUtils.isCidr()) {
                return false;
            }
            VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            if (virtualFileArray == null) {
                return false;
            }
            VirtualFile[] files = virtualFileArray;
            Project project = e.getProject();
            if (project == null) {
                return false;
            }
            Project project2 = project;
            if (project2.isDisposed()) {
                return false;
            }
            if (e.getData(PlatformCoreDataKeys.MODULE) == null) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)e.getPlace(), (Object)"ProjectViewPopup")) {
                boolean bl2;
                block9: {
                    $this$any$iv = files;
                    $i$f$any = false;
                    n2 = $this$any$iv.length;
                    for (n = 0; n < n2; ++n) {
                        p0 = element$iv = $this$any$iv[n];
                        boolean bl3 = false;
                        if (!JavaToKotlinAction.isEnabled$isWritablePackageDirectory(project2, p0)) continue;
                        bl2 = true;
                        break block9;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    return true;
                }
            }
            $this$any$iv = files;
            $i$f$any = false;
            n2 = $this$any$iv.length;
            for (n = 0; n < n2; ++n) {
                p0 = element$iv = $this$any$iv[n];
                boolean bl4 = false;
                if (!JavaToKotlinAction.isEnabled$isWritableJavaFile(project2, p0)) continue;
                bl = true;
                break block10;
            }
            bl = false;
        }
        return bl;
    }

    private static final PsiJavaFile getSelectedWritableJavaFiles$lambda$0(PsiManager $psiManager, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiFile psiFile = $psiManager.findFile(it);
        return psiFile instanceof PsiJavaFile ? (PsiJavaFile)psiFile : null;
    }

    private static final boolean getSelectedWritableJavaFiles$lambda$1(PsiJavaFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getFileType(), (Object)JavaFileType.INSTANCE);
    }

    private static final boolean getSelectedWritableJavaFiles$lambda$2(PsiJavaFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isWritable();
    }

    /*
     * WARNING - void declaration
     */
    private static final PsiErrorElement shouldSkipConversionOfErroneousCode$lambda$0(PsiJavaFile it) {
        void $this$findDescendantOfType$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiElement $this$findDescendantOfType_u24default$iv = (PsiElement)it;
        Function1 predicate$iv = shouldSkipConversionOfErroneousCode$lambda$0$$inlined$findDescendantOfType$default$1.INSTANCE;
        boolean $i$f$findDescendantOfType = false;
        PsiElement psiElement = $this$findDescendantOfType_u24default$iv;
        Function1 predicate$iv$iv = predicate$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv);
        Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv$iv, result$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PsiErrorElement && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiErrorElement)((PsiElement)result$iv$iv.element);
    }

    private static final boolean isEnabled$isWritableJavaFile(Project project, VirtualFile file) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        return Intrinsics.areEqual((Object)file.getExtension(), (Object)"java") && psiManager2.findFile(file) instanceof PsiJavaFile && file.isWritable();
    }

    private static final boolean isEnabled$isWritablePackageDirectory(Project project, VirtualFile file) {
        PsiDirectory psiDirectory = PhysicalFileSystemUtilsKt.toPsiDirectory(file, project);
        if (psiDirectory == null) {
            return false;
        }
        PsiDirectory directory = psiDirectory;
        return PsiDirectoryFactory.getInstance((Project)project).isPackage(directory) && file.isWritable();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JR\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u0016J*\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J%\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e*\u00020\u000e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u0018H\u0002\u00a2\u0006\u0002\u0010 J*\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\t2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\t2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0002JH\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/actions/JavaToKotlinAction$Handler;", "", "<init>", "()V", "title", "", "getTitle", "()Ljava/lang/String;", "convertFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "files", "Lcom/intellij/psi/PsiJavaFile;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "enableExternalCodeProcessing", "", "askExternalCodeProcessing", "forceUsingOldJ2k", "settings", "Lorg/jetbrains/kotlin/j2k/ConverterSettings;", "prepareExternalCodeUpdate", "Lkotlin/Function0;", "", "processing", "Lorg/jetbrains/kotlin/j2k/ExternalCodeProcessing;", "isEnabled", "runUndoTransparentGlobalWriteAction", "T", "command", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "saveResults", "Lcom/intellij/openapi/vfs/VirtualFile;", "javaFiles", "convertedTexts", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nJavaToKotlinAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaToKotlinAction.kt\norg/jetbrains/kotlin/idea/actions/JavaToKotlinAction$Handler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n+ 5 permissions.kt\norg/jetbrains/kotlin/analysis/api/permissions/PermissionsKt\n+ 6 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 7 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n*L\n1#1,341:1\n774#2:342\n865#2,2:343\n1563#2:373\n1634#2,3:374\n2756#2:377\n1#3:345\n1#3:378\n29#4,3:346\n41#5,2:349\n44#5,5:368\n30#6,2:351\n36#7,15:353\n*S KotlinDebug\n*F\n+ 1 JavaToKotlinAction.kt\norg/jetbrains/kotlin/idea/actions/JavaToKotlinAction$Handler\n*L\n70#1:342\n70#1:343,2\n130#1:373\n130#1:374,3\n131#1:377\n131#1:378\n79#1:346,3\n135#1:349,2\n135#1:368,5\n136#1:351,2\n136#1:353,15\n*E\n"})
    public static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();
        @NotNull
        private static final String title = KotlinBundle.message((String)"action.j2k.name", (Object[])new Object[0]);

        private Handler() {
        }

        @NotNull
        public final String getTitle() {
            return title;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<KtFile> convertFiles(@NotNull List<? extends PsiJavaFile> files, @NotNull Project project, @NotNull Module module, boolean enableExternalCodeProcessing, boolean askExternalCodeProcessing, boolean forceUsingOldJ2k, @NotNull ConverterSettings settings2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
            Iterable $this$filter$iv = files;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PsiJavaFile it = (PsiJavaFile)element$iv$iv;
                boolean bl = false;
                if (!it.getVirtualFile().isWritable()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            if ($this$filter$iv.isEmpty()) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            List javaFiles = (List)$this$filter$iv;
            Ref.ObjectRef converterResult = new Ref.ObjectRef();
            String question = KotlinBundle.message((String)"action.j2k.correction.required", (Object[])new Object[0]);
            boolean shouldProcessExternalCode = enableExternalCodeProcessing && (!askExternalCodeProcessing || Messages.showYesNoDialog((Project)project, (String)question, (String)title, (Icon)Messages.getQuestionIcon()) == 0);
            Ref.ObjectRef newFiles = new Ref.ObjectRef();
            newFiles.element = CollectionsKt.emptyList();
            ApplicationUtilsKt.executeCommand$default(project, KotlinBundle.message((String)"action.j2k.task.name", (Object[])new Object[0]), null, () -> Handler.convertFiles$lambda$4(project, converterResult, shouldProcessExternalCode, newFiles, forceUsingOldJ2k, module, settings2, javaFiles), 2, null);
            return (List)newFiles.element;
        }

        public static /* synthetic */ List convertFiles$default(Handler handler2, List list2, Project project, Module module, boolean bl, boolean bl2, boolean bl3, ConverterSettings converterSettings, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            if ((n & 0x20) != 0) {
                bl3 = false;
            }
            if ((n & 0x40) != 0) {
                converterSettings = ConverterSettings.Companion.getDefaultSettings();
            }
            return handler2.convertFiles(list2, project, module, bl, bl2, bl3, converterSettings);
        }

        private final Function0<Unit> prepareExternalCodeUpdate(Project project, ExternalCodeProcessing processing, boolean isEnabled) {
            if (!isEnabled || processing == null) {
                return null;
            }
            Ref.ObjectRef result2 = new Ref.ObjectRef();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Handler.prepareExternalCodeUpdate$lambda$0(result2, processing), title, true, project);
            return (Function0)result2.element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <T> T runUndoTransparentGlobalWriteAction(Project $this$runUndoTransparentGlobalWriteAction, Function0<? extends T> command2) {
            Object object;
            AutoCloseable autoCloseable = CommandProcessor.getInstance().withUndoTransparentAction();
            Throwable throwable = null;
            try {
                AutoCloseable it = autoCloseable;
                boolean bl = false;
                CommandProcessor.getInstance().markCurrentCommandAsGlobal($this$runUndoTransparentGlobalWriteAction);
                object = ActionsKt.runWriteAction(() -> Handler.runUndoTransparentGlobalWriteAction$lambda$0$0(command2));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return (T)object;
        }

        private final List<VirtualFile> saveResults(List<? extends PsiJavaFile> javaFiles, List<String> convertedTexts) {
            ArrayList result2 = new ArrayList();
            for (Pair pair : CollectionsKt.zip((Iterable)javaFiles, (Iterable)convertedTexts)) {
                PsiJavaFile psiFile = (PsiJavaFile)pair.component1();
                String text = (String)pair.component2();
                try {
                    String errorMessage;
                    Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument((PsiFile)psiFile);
                    if (document == null) {
                        var10_11 = new Object[1];
                        Intrinsics.checkNotNullExpressionValue((Object)psiFile.getName(), (String)"getName(...)");
                        v0 = KotlinBundle.message((String)"action.j2k.error.cant.find.document", (Object[])var10_11);
                    } else if (!document.isWritable()) {
                        var10_11 = new Object[1];
                        Intrinsics.checkNotNullExpressionValue((Object)psiFile.getName(), (String)"getName(...)");
                        v0 = KotlinBundle.message((String)"action.j2k.error.read.only", (Object[])var10_11);
                    } else {
                        v0 = errorMessage = null;
                    }
                    if (errorMessage != null) {
                        Object[] objectArray = new Object[]{errorMessage};
                        String message2 = KotlinBundle.message((String)"action.j2k.error.cant.save.result", (Object[])objectArray);
                        MessagesEx.error((Project)psiFile.getProject(), (String)message2).showLater();
                        continue;
                    }
                    Document document2 = document;
                    Intrinsics.checkNotNull((Object)document2);
                    document2.replaceString(0, document.getTextLength(), (CharSequence)text);
                    FileDocumentManager.getInstance().saveDocument(document);
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (ScratchRootType.getInstance().containsFile(virtualFile)) {
                        PerFileMappings mapping2;
                        Intrinsics.checkNotNullExpressionValue((Object)ScratchFileService.getInstance().getScratchesMapping(), (String)"getScratchesMapping(...)");
                        mapping2.setMapping(virtualFile, (Object)KotlinFileType.INSTANCE.getLanguage());
                    } else {
                        Intrinsics.checkNotNull((Object)virtualFile);
                        String fileName = Handler.saveResults$uniqueKotlinFileName(virtualFile);
                        virtualFile.putUserData(JavaToKotlinConversionUtils.getPathBeforeJavaToKotlinConversion(), (Object)virtualFile.getPath());
                        virtualFile.rename((Object)this, fileName);
                    }
                    ((Collection)result2).add(virtualFile);
                }
                catch (IOException e) {
                    Project project = psiFile.getProject();
                    String string = e.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    MessagesEx.error((Project)project, (String)string).showLater();
                }
            }
            return result2;
        }

        @NotNull
        public final List<KtFile> convertFiles(@NotNull List<? extends PsiJavaFile> files, @NotNull Project project, @NotNull Module module, boolean enableExternalCodeProcessing, boolean askExternalCodeProcessing, boolean forceUsingOldJ2k) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return this.convertFiles(files, project, module, enableExternalCodeProcessing, askExternalCodeProcessing, forceUsingOldJ2k, ConverterSettings.Companion.getDefaultSettings());
        }

        public static /* synthetic */ List convertFiles$default(Handler handler2, List list2, Project project, Module module, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            if ((n & 0x20) != 0) {
                bl3 = false;
            }
            return handler2.convertFiles(list2, project, module, bl, bl2, bl3);
        }

        private static final void convertFiles$convertWithStatistics(boolean $forceUsingOldJ2k, Project $project, Module $module, ConverterSettings $settings, List<? extends PsiJavaFile> javaFiles, Ref.ObjectRef<FilesResult> converterResult) {
            J2kConverterExtension.Kind j2kKind = JavaToKotlinActionKt.access$getJ2kKind($forceUsingOldJ2k);
            JavaToKotlinConverter converter = J2kConverterExtension.createJavaToKotlinConverter$default(J2kConverterExtension.Companion.extension(j2kKind), $project, $module, $settings, null, 8, null);
            PostProcessor postProcessor = J2kConverterExtension.createPostProcessor$default(J2kConverterExtension.Companion.extension(j2kKind), false, 1, null);
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            Intrinsics.checkNotNull((Object)progressIndicator);
            ProgressIndicator progressIndicator2 = progressIndicator;
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            converterResult.element = converter.filesToKotlin(javaFiles, postProcessor, progressIndicator2, J2kPreprocessorExtension.Companion.getEP_NAME().getExtensionList(), J2kPostprocessorExtension.Companion.getEP_NAME().getExtensionList());
            long conversionTime = System.currentTimeMillis() - start$iv;
            int linesCount = ((Number)ActionsKt.runReadAction(() -> Handler.convertFiles$convertWithStatistics$lambda$3(javaFiles))).intValue();
            J2KFusCollector.INSTANCE.log(ConversionType.FILES, j2kKind == J2kConverterExtension.Kind.K1_NEW, conversionTime, linesCount, javaFiles.size());
        }

        /*
         * WARNING - void declaration
         */
        private static final int convertFiles$convertWithStatistics$lambda$3(List $javaFiles) {
            Iterable iterable = $javaFiles;
            int n = 0;
            for (Object t : iterable) {
                void it;
                PsiJavaFile psiJavaFile = (PsiJavaFile)t;
                int n2 = n;
                boolean bl = false;
                int n3 = StringUtil.getLineBreakCount((CharSequence)it.getText());
                n = n2 + n3;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private static final Unit convertFiles$lambda$4(Project $project, Ref.ObjectRef $converterResult, boolean $shouldProcessExternalCode, Ref.ObjectRef $newFiles, boolean $forceUsingOldJ2k, Module $module, ConverterSettings $settings, List $javaFiles) {
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Handler.convertFiles$lambda$4$0($forceUsingOldJ2k, $project, $module, $settings, $javaFiles, $converterResult), title, true, $project)) {
                return Unit.INSTANCE;
            }
            FilesResult filesResult = (FilesResult)$converterResult.element;
            if (filesResult == null) {
                return Unit.INSTANCE;
            }
            FilesResult result2 = filesResult;
            ExternalCodeProcessing externalCodeProcessing2 = result2.getExternalCodeProcessing();
            Function0<Unit> externalCodeUpdate = INSTANCE.prepareExternalCodeUpdate($project, externalCodeProcessing2, $shouldProcessExternalCode);
            $newFiles.element = INSTANCE.runUndoTransparentGlobalWriteAction($project, () -> Handler.convertFiles$lambda$4$1($javaFiles, result2, $project));
            KtFile ktFile2 = (KtFile)CollectionsKt.firstOrNull((List)((List)$newFiles.element));
            if (ktFile2 == null) {
                return Unit.INSTANCE;
            }
            KtFile contextElement = ktFile2;
            boolean $i$f$allowAnalysisOnEdt = false;
            KaAnalysisPermissionRegistry permissionRegistry$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
            if (permissionRegistry$iv.isAnalysisAllowedOnEdt()) {
                void this_$iv$iv;
                boolean bl = false;
                KtElement useSiteElement$iv = (KtElement)contextElement;
                boolean $i$f$analyze = false;
                Project project = useSiteElement$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                KtElement useSiteElement$iv$iv = useSiteElement$iv;
                boolean $i$f$analyze2 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                try {
                    Unit $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv22;
                    Object lock$iv$iv;
                    Object object = lock$iv$iv = new Object();
                    synchronized (object) {
                        Unit unit;
                        boolean $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv22 = false;
                        KaSession $this$convertFiles_u24lambda_u244_u242_u240 = analysisSession$iv$iv;
                        boolean bl2 = false;
                        ExternalCodeProcessing externalCodeProcessing3 = externalCodeProcessing2;
                        if (externalCodeProcessing3 != null) {
                            externalCodeProcessing3.bindJavaDeclarationsToConvertedKotlinOnes($this$convertFiles_u24lambda_u244_u242_u240, (List)$newFiles.element);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv22 = unit;
                    }
                    lock$iv$iv = $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv22;
                }
                catch (Throwable throwable$iv$iv) {
                    this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                    throw new KotlinNothingValueException();
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                }
            }
            permissionRegistry$iv.setAnalysisAllowedOnEdt(true);
            try {
                Unit unit;
                boolean bl = false;
                KtElement useSiteElement$iv = (KtElement)contextElement;
                boolean $i$f$analyze = false;
                Project project = useSiteElement$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project);
                KtElement useSiteElement$iv$iv = useSiteElement$iv;
                boolean $i$f$analyze3 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                try {
                    Unit unit2;
                    Object lock$iv$iv;
                    Object throwable$iv$iv = lock$iv$iv = new Object();
                    synchronized (throwable$iv$iv) {
                        Unit unit3;
                        boolean bl3 = false;
                        KaSession $this$convertFiles_u24lambda_u244_u242_u240 = analysisSession$iv$iv;
                        boolean bl4 = false;
                        ExternalCodeProcessing externalCodeProcessing4 = externalCodeProcessing2;
                        if (externalCodeProcessing4 != null) {
                            externalCodeProcessing4.bindJavaDeclarationsToConvertedKotlinOnes($this$convertFiles_u24lambda_u244_u242_u240, (List)$newFiles.element);
                            unit3 = Unit.INSTANCE;
                        } else {
                            unit3 = null;
                        }
                        unit2 = unit3;
                    }
                    unit = unit2;
                }
                catch (Throwable throwable$iv$iv) {
                    this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                    throw new KotlinNothingValueException();
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                }
                Unit unit4 = unit;
            }
            finally {
                permissionRegistry$iv.setAnalysisAllowedOnEdt(false);
            }
            INSTANCE.runUndoTransparentGlobalWriteAction($project, () -> Handler.convertFiles$lambda$4$3(externalCodeUpdate, $project, $newFiles));
            return Unit.INSTANCE;
        }

        private static final void convertFiles$lambda$4$0(boolean $forceUsingOldJ2k, Project $project, Module $module, ConverterSettings $settings, List $javaFiles, Ref.ObjectRef $converterResult) {
            Handler.convertFiles$convertWithStatistics($forceUsingOldJ2k, $project, $module, $settings, $javaFiles, (Ref.ObjectRef<FilesResult>)$converterResult);
        }

        /*
         * WARNING - void declaration
         */
        private static final List convertFiles$lambda$4$1(List $javaFiles, FilesResult $result, Project $project) {
            KtFile it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = INSTANCE.saveResults($javaFiles, $result.getResults());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PsiFile psiFile = PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)it, $project);
                Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                collection.add((KtFile)psiFile);
            }
            Iterable $this$onEach$iv = (List)destination$iv$iv;
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u240$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u240$iv) {
                it = (KtFile)element$iv;
                boolean bl2 = false;
                DocumentUtilsKt.commitAndUnblockDocument((PsiFile)it);
            }
            return (List)iterable;
        }

        private static final FileEditor[] convertFiles$lambda$4$3(Function0 $externalCodeUpdate, Project $project, Ref.ObjectRef $newFiles) {
            FileEditor[] fileEditorArray;
            Function0 function0 = $externalCodeUpdate;
            if (function0 != null) {
                function0.invoke();
            }
            PsiDocumentManager.getInstance((Project)$project).commitAllDocuments();
            KtFile ktFile2 = (KtFile)CollectionsKt.singleOrNull((List)((List)$newFiles.element));
            if (ktFile2 != null) {
                KtFile it = ktFile2;
                boolean bl = false;
                fileEditorArray = FileEditorManager.getInstance((Project)$project).openFile(it.getVirtualFile(), true);
            } else {
                fileEditorArray = null;
            }
            return fileEditorArray;
        }

        private static final void prepareExternalCodeUpdate$lambda$0(Ref.ObjectRef $result, ExternalCodeProcessing $processing) {
            ActionsKt.runReadAction(() -> Handler.prepareExternalCodeUpdate$lambda$0$0($result, $processing));
        }

        private static final Unit prepareExternalCodeUpdate$lambda$0$0(Ref.ObjectRef $result, ExternalCodeProcessing $processing) {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            Intrinsics.checkNotNull((Object)progressIndicator);
            $result.element = $processing.prepareWriteOperation(progressIndicator);
            return Unit.INSTANCE;
        }

        private static final Object runUndoTransparentGlobalWriteAction$lambda$0$0(Function0 $command) {
            return $command.invoke();
        }

        private static final String saveResults$uniqueKotlinFileName(VirtualFile javaFile) {
            Path nioFile = javaFile.getFileSystem().getNioPath(javaFile);
            int i2 = 0;
            while (true) {
                block4: {
                    String fileName;
                    block3: {
                        Path path2;
                        fileName = javaFile.getNameWithoutExtension() + (i2 > 0 ? Integer.valueOf(i2) : "") + ".kt";
                        if (nioFile == null) break block3;
                        Intrinsics.checkNotNullExpressionValue((Object)nioFile.resolveSibling(fileName), (String)"resolveSibling(...)");
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (!Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block4;
                    }
                    return fileName;
                }
                ++i2;
            }
        }
    }
}

