/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Map;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.export.___Exporter;
import org.jmol.modelset.Atom;
import org.jmol.util.GData;
import org.jmol.viewer.Viewer;

abstract class __RayTracerExporter
extends ___Exporter {
    protected boolean isSlabEnabled;
    protected int minScreenDimension;
    protected boolean wasPerspective;

    public __RayTracerExporter() {
        this.exportType = 2;
        this.lineWidthMad = (short)2;
    }

    @Override
    protected boolean initOutput(Viewer vwr, double privateKey, GData g3d, Map<String, Object> params) {
        this.wasPerspective = vwr.tm.perspectiveDepth;
        if (super.initOutput(vwr, privateKey, g3d, params)) {
            vwr.tm.perspectiveDepth = false;
            if (this.wasPerspective) {
                vwr.shm.finalizeAtoms(null, false);
            }
            return true;
        }
        return false;
    }

    @Override
    protected String finalizeOutput2() {
        this.vwr.tm.perspectiveDepth = this.wasPerspective;
        return super.finalizeOutput2();
    }

    @Override
    protected void outputVertex(T3 pt, T3 offset) {
        __RayTracerExporter.setTempVertex(pt, offset, this.tempP1);
        this.tm.transformPt3fSafe(this.tempP1, this.tempP1);
        this.output(this.tempP1);
    }

    protected abstract void outputCircle(int var1, int var2, int var3, float var4, short var5, boolean var6);

    protected abstract void outputCylinder(P3 var1, P3 var2, float var3, short var4, boolean var5);

    protected abstract void outputCylinderConical(P3 var1, P3 var2, float var3, float var4, short var5);

    protected abstract void outputEllipsoid(P3 var1, float var2, double[] var3, short var4);

    protected abstract void outputSphere(float var1, float var2, float var3, float var4, short var5);

    protected abstract void outputTextPixel(int var1, int var2, int var3, int var4);

    protected abstract void outputTriangle(T3 var1, T3 var2, T3 var3, short var4);

    protected abstract void outputCone(P3 var1, P3 var2, float var3, short var4, boolean var5);

    protected P3 getScreenNormal(T3 pt, T3 normal, float factor) {
        if (Float.isNaN(normal.x)) {
            this.tempP3.set(0.0f, 0.0f, 0.0f);
            return this.tempP3;
        }
        this.tempP1.add2(pt, normal);
        this.tm.transformPt3fSafe(pt, this.tempP2);
        this.tm.transformPt3fSafe(this.tempP1, this.tempP3);
        this.tempP3.sub(this.tempP2);
        this.tempP3.scale(factor);
        return this.tempP3;
    }

    protected void initVars() {
        this.isSlabEnabled = this.tm.slabEnabled;
        this.minScreenDimension = Math.min(this.screenWidth, this.screenHeight);
    }

    @Override
    void drawAtom(Atom atom, float radius) {
        this.outputSphere(atom.sX, atom.sY, atom.sZ, (float)atom.sD / 2.0f, atom.colixAtom);
    }

    @Override
    void drawCircle(int x, int y, int z, int diameter, short colix, boolean doFill) {
        float radius = (float)diameter / 2.0f;
        this.outputCircle(x, y, z, radius, colix, doFill);
    }

    @Override
    boolean drawEllipse(P3 ptAtom, P3 ptX, P3 ptY, short colix, boolean doFill) {
        return false;
    }

    @Override
    void drawPixel(short colix, int x, int y, int z, int scale) {
        this.outputSphere(x, y, z, 0.75f * (float)scale, colix);
    }

    @Override
    void drawTextPixel(int argb, int x, int y, int z) {
        this.outputTextPixel(x, y, this.fixScreenZ(z), argb);
    }

    @Override
    void fillConeScreen(short colix, byte endcap, int screenDiameter, P3 screenBase, P3 screenTip, boolean isBarb) {
        this.outputCone(screenBase, screenTip, (float)screenDiameter / 2.0f, colix, isBarb);
    }

    @Override
    void drawCylinder(P3 screenA, P3 screenB, short colix1, short colix2, byte endcaps, int madBond, int bondOrder) {
        if (colix1 == colix2) {
            this.fillConicalCylinder(screenA, screenB, madBond, colix1, endcaps);
        } else {
            this.tempV2.ave(screenB, screenA);
            this.tempP1.setT(this.tempV2);
            this.fillConicalCylinder(screenA, this.tempP1, madBond, colix1, endcaps);
            this.fillConicalCylinder(this.tempP1, screenB, madBond, colix2, endcaps);
        }
        if (endcaps != 3) {
            return;
        }
        float radius = this.vwr.tm.scaleToScreen((int)screenA.z, madBond) / 2.0f;
        if (radius <= 1.0f) {
            return;
        }
        this.outputSphere(screenA.x, screenA.y, screenA.z, radius, colix1);
        radius = this.vwr.tm.scaleToScreen((int)screenB.z, madBond) / 2.0f;
        if (radius <= 1.0f) {
            return;
        }
        this.outputSphere(screenB.x, screenB.y, screenB.z, radius, colix2);
    }

    protected void fillConicalCylinder(P3 screenA, P3 screenB, int madBond, short colix, byte endcaps) {
        float radius1 = this.vwr.tm.scaleToScreen((int)screenA.z, madBond) / 2.0f;
        if (radius1 == 0.0f) {
            return;
        }
        if (radius1 < 1.0f) {
            radius1 = 1.0f;
        }
        if (screenA.distance(screenB) == 0.0f) {
            this.outputSphere(screenA.x, screenA.y, screenA.z, radius1, colix);
            return;
        }
        float radius2 = this.vwr.tm.scaleToScreen((int)screenB.z, madBond) / 2.0f;
        if (radius2 == 0.0f) {
            return;
        }
        if (radius2 < 1.0f) {
            radius2 = 1.0f;
        }
        this.outputCylinderConical(screenA, screenB, radius1, radius2, colix);
    }

    @Override
    void fillCylinderScreenMad(short colix, byte endcaps, int diameter, P3 screenA, P3 screenB) {
        if (diameter == 0) {
            return;
        }
        if (diameter < 1) {
            diameter = 1;
        }
        float radius = (float)diameter / 2.0f;
        if (screenA.distance(screenB) == 0.0f) {
            this.outputSphere(screenA.x, screenA.y, screenA.z, radius, colix);
            return;
        }
        this.outputCylinder(screenA, screenB, radius, colix, endcaps == 2);
        if (endcaps != 3 || radius <= 1.0f) {
            return;
        }
        this.outputSphere(screenA.x, screenA.y, screenA.z, radius, colix);
        this.outputSphere(screenB.x, screenB.y, screenB.z, radius, colix);
    }

    @Override
    void fillCylinderScreen(short colix, byte endcaps, int screenDiameter, P3 screenA, P3 screenB, P3 ptA, P3 ptB, float radius) {
        this.fillCylinderScreenMad(colix, endcaps, screenDiameter, screenA, screenB);
    }

    @Override
    void fillSphere(short colix, int diameter, P3 pt) {
        this.outputSphere(pt.x, pt.y, pt.z, (float)diameter / 2.0f, colix);
    }

    @Override
    protected void fillTriangle(short colix, T3 ptA, T3 ptB, T3 ptC, boolean twoSided) {
        this.outputTriangle(ptA, ptB, ptC, colix);
    }

    @Override
    void fillEllipsoid(P3 center, P3[] points, short colix, int x, int y, int z, int diameter, M3 toEllipsoidal, double[] coef, M4 deriv, P3[] octantPoints) {
        float radius = (float)diameter / 2.0f;
        if (radius == 0.0f) {
            return;
        }
        if (radius < 1.0f) {
            radius = 1.0f;
        }
        this.outputEllipsoid(center, radius, coef, colix);
    }
}

