/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.plaf.FontUIResource;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.FontAccess;
import sun.font.FontManager;
import sun.font.FontManagerFactory;
import sun.font.PhysicalFont;
import sun.font.SunFontManager;
import sun.font.TrueTypeFont;
import sun.util.logging.PlatformLogger;

public final class FontUtilities {
    public static boolean isSolaris;
    public static boolean isLinux;
    public static boolean isMacOSX;
    public static boolean isMacOSX14;
    public static boolean isSolaris8;
    public static boolean isSolaris9;
    public static boolean isOpenSolaris;
    public static boolean useJDKScaler;
    public static boolean useT2K;
    public static boolean isWindows;
    public static boolean isOpenJDK;
    static final String LUCIDA_FILE_NAME = "LucidaSansRegular.ttf";
    private static boolean debugFonts;
    private static PlatformLogger logger;
    private static boolean logging;
    public static final int MIN_LAYOUT_CHARCODE = 768;
    public static final int MAX_LAYOUT_CHARCODE = 8303;
    private static volatile SoftReference<ConcurrentHashMap<PhysicalFont, CompositeFont>> compMapRef;
    private static final String[][] nameMap;

    public static Font2D getFont2D(Font font) {
        return FontAccess.getFontAccess().getFont2D(font);
    }

    public static boolean isComplexText(char[] cArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (cArray[i] < '\u0300' || !FontUtilities.isNonSimpleChar(cArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isNonSimpleChar(char c) {
        return FontUtilities.isComplexCharCode(c) || c >= '\ud800' && c <= '\udfff';
    }

    public static boolean isComplexCharCode(int n) {
        if (n < 768 || n > 8303) {
            return false;
        }
        if (n <= 879) {
            return true;
        }
        if (n < 1424) {
            return false;
        }
        if (n <= 1791) {
            return true;
        }
        if (n < 2304) {
            return false;
        }
        if (n <= 3711) {
            return true;
        }
        if (n < 3840) {
            return false;
        }
        if (n <= 4095) {
            return true;
        }
        if (n < 4352) {
            return false;
        }
        if (n < 4607) {
            return true;
        }
        if (n < 6016) {
            return false;
        }
        if (n <= 6143) {
            return true;
        }
        if (n < 8204) {
            return false;
        }
        if (n <= 8205) {
            return true;
        }
        if (n >= 8234 && n <= 8238) {
            return true;
        }
        return n >= 8298 && n <= 8303;
    }

    public static PlatformLogger getLogger() {
        return logger;
    }

    public static boolean isLogging() {
        return logging;
    }

    public static boolean debugFonts() {
        return debugFonts;
    }

    public static boolean fontSupportsDefaultEncoding(Font font) {
        return FontUtilities.getFont2D(font) instanceof CompositeFont;
    }

    public static FontUIResource getCompositeFontUIResource(Font font) {
        CompositeFont compositeFont;
        FontUIResource fontUIResource = new FontUIResource(font);
        Font2D font2D = FontUtilities.getFont2D(font);
        if (!(font2D instanceof PhysicalFont)) {
            return fontUIResource;
        }
        FontManager fontManager = FontManagerFactory.getInstance();
        Font2D font2D2 = fontManager.findFont2D("dialog", font.getStyle(), 0);
        if (font2D2 == null || !(font2D2 instanceof CompositeFont)) {
            return fontUIResource;
        }
        CompositeFont compositeFont2 = (CompositeFont)font2D2;
        PhysicalFont physicalFont = (PhysicalFont)font2D;
        ConcurrentHashMap<PhysicalFont, CompositeFont> concurrentHashMap = compMapRef.get();
        if (concurrentHashMap == null) {
            concurrentHashMap = new ConcurrentHashMap();
            compMapRef = new SoftReference<ConcurrentHashMap<PhysicalFont, CompositeFont>>(concurrentHashMap);
        }
        if ((compositeFont = concurrentHashMap.get(physicalFont)) == null) {
            compositeFont = new CompositeFont(physicalFont, compositeFont2);
            concurrentHashMap.put(physicalFont, compositeFont);
        }
        FontAccess.getFontAccess().setFont2D(fontUIResource, compositeFont.handle);
        FontAccess.getFontAccess().setCreatedFont(fontUIResource);
        return fontUIResource;
    }

    public static String mapFcName(String string) {
        for (int i = 0; i < nameMap.length; ++i) {
            if (!string.equals(nameMap[i][0])) continue;
            return nameMap[i][1];
        }
        return null;
    }

    public static FontUIResource getFontConfigFUIR(String string, int n, int n2) {
        FontUIResource fontUIResource;
        FontManager fontManager;
        String string2 = FontUtilities.mapFcName(string);
        if (string2 == null) {
            string2 = "sansserif";
        }
        if ((fontManager = FontManagerFactory.getInstance()) instanceof SunFontManager) {
            SunFontManager sunFontManager = (SunFontManager)fontManager;
            fontUIResource = sunFontManager.getFontConfigFUIR(string2, n, n2);
        } else {
            fontUIResource = new FontUIResource(string2, n, n2);
        }
        return fontUIResource;
    }

    public static boolean textLayoutIsCompatible(Font font) {
        Font2D font2D = FontUtilities.getFont2D(font);
        if (font2D instanceof TrueTypeFont) {
            TrueTypeFont trueTypeFont = (TrueTypeFont)font2D;
            return trueTypeFont.getDirectoryEntry(1196643650) == null || trueTypeFont.getDirectoryEntry(1196445523) != null;
        }
        return false;
    }

    static {
        debugFonts = false;
        logger = null;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string;
                File file;
                String string2;
                String string3 = System.getProperty("os.name", "unknownOS");
                isSolaris = string3.startsWith("SunOS");
                isLinux = string3.startsWith("Linux");
                isMacOSX = string3.contains("OS X");
                if (isMacOSX) {
                    isMacOSX14 = true;
                    string2 = System.getProperty("os.version", "");
                    if (string2.startsWith("10.")) {
                        int n = (string2 = string2.substring(3)).indexOf(46);
                        if (n != -1) {
                            string2 = string2.substring(0, n);
                        }
                        try {
                            int n2 = Integer.parseInt(string2);
                            isMacOSX14 = n2 >= 14;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                if ((string2 = System.getProperty("sun.java2d.font.scaler")) != null) {
                    useT2K = "t2k".equals(string2);
                    useJDKScaler = useT2K || "jdk".equals(string2);
                } else {
                    useT2K = false;
                    useJDKScaler = false;
                }
                if (isSolaris) {
                    String string4 = System.getProperty("os.version", "0.0");
                    isSolaris8 = string4.startsWith("5.8");
                    isSolaris9 = string4.startsWith("5.9");
                    float f = Float.parseFloat(string4);
                    if (f > 5.1f) {
                        file = new File("/etc/release");
                        string = null;
                        try {
                            FileInputStream fileInputStream = new FileInputStream(file);
                            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "ISO-8859-1");
                            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                            string = bufferedReader.readLine();
                            fileInputStream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        isOpenSolaris = string != null && string.indexOf("OpenSolaris") >= 0;
                    } else {
                        isOpenSolaris = false;
                    }
                } else {
                    isSolaris8 = false;
                    isSolaris9 = false;
                    isOpenSolaris = false;
                }
                isWindows = string3.startsWith("Windows");
                String string5 = System.getProperty("java.home", "") + File.separator + "lib";
                String string6 = string5 + File.separator + "fonts";
                file = new File(string6 + File.separator + FontUtilities.LUCIDA_FILE_NAME);
                isOpenJDK = !file.exists();
                string = System.getProperty("sun.java2d.debugfonts");
                if (string != null && !string.equals("false")) {
                    debugFonts = true;
                    logger = PlatformLogger.getLogger("sun.java2d");
                    if (string.equals("warning")) {
                        logger.setLevel(PlatformLogger.Level.WARNING);
                    } else if (string.equals("severe")) {
                        logger.setLevel(PlatformLogger.Level.SEVERE);
                    }
                }
                if (debugFonts) {
                    logger = PlatformLogger.getLogger("sun.java2d");
                    logging = logger.isEnabled();
                }
                return null;
            }
        });
        compMapRef = new SoftReference<Object>(null);
        nameMap = new String[][]{{"sans", "sansserif"}, {"sans-serif", "sansserif"}, {"serif", "serif"}, {"monospace", "monospaced"}};
    }
}

