/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common.serialization;

import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.MetadataParseException;
import org.apache.kafka.server.common.serialization.RecordSerde;

public abstract class AbstractApiMessageSerde
implements RecordSerde<ApiMessageAndVersion> {
    private static final short DEFAULT_FRAME_VERSION = 1;
    private static final int DEFAULT_FRAME_VERSION_SIZE = ByteUtils.sizeOfUnsignedVarint((int)1);

    private static short unsignedIntToShort(Readable input, String entity) {
        int val;
        try {
            val = input.readUnsignedVarint();
        }
        catch (Exception e) {
            throw new MetadataParseException("Error while reading " + entity, e);
        }
        if (val > Short.MAX_VALUE) {
            throw new MetadataParseException("Value for " + entity + " was too large.");
        }
        return (short)val;
    }

    @Override
    public int recordSize(ApiMessageAndVersion data, ObjectSerializationCache serializationCache) {
        int size = DEFAULT_FRAME_VERSION_SIZE;
        size += ByteUtils.sizeOfUnsignedVarint((int)data.message().apiKey());
        size += ByteUtils.sizeOfUnsignedVarint((int)data.version());
        return size += data.message().size(serializationCache, data.version());
    }

    @Override
    public void write(ApiMessageAndVersion data, ObjectSerializationCache serializationCache, Writable out) {
        out.writeUnsignedVarint(1);
        out.writeUnsignedVarint((int)data.message().apiKey());
        out.writeUnsignedVarint((int)data.version());
        data.message().write(out, serializationCache, data.version());
    }

    @Override
    public ApiMessageAndVersion read(Readable input, int size) {
        ApiMessage record;
        short frameVersion = AbstractApiMessageSerde.unsignedIntToShort(input, "frame version");
        if (frameVersion == 0) {
            throw new MetadataParseException("Could not deserialize metadata record with frame version 0. Note that upgrades from the preview release of KRaft in 2.8 to newer versions are not supported.");
        }
        if (frameVersion != 1) {
            throw new MetadataParseException("Could not deserialize metadata record due to unknown frame version " + frameVersion + "(only frame version 1 is supported)");
        }
        short apiKey = AbstractApiMessageSerde.unsignedIntToShort(input, "type");
        short version = AbstractApiMessageSerde.unsignedIntToShort(input, "version");
        try {
            record = this.apiMessageFor(apiKey);
        }
        catch (Exception e) {
            throw new MetadataParseException(e);
        }
        try {
            record.read(input, version);
        }
        catch (Exception e) {
            throw new MetadataParseException("Failed to deserialize record with type " + apiKey, e);
        }
        if (input.remaining() > 0) {
            throw new MetadataParseException("Found " + input.remaining() + " byte(s) of garbage after " + apiKey);
        }
        return new ApiMessageAndVersion(record, version);
    }

    public abstract ApiMessage apiMessageFor(short var1);
}

