/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableDeserializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerde;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerializer;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.internals.SerdeGetter;

public class WrappingNullableUtils {
    private static <T> Deserializer<T> prepareDeserializer(Deserializer<T> specificDeserializer, ProcessorContext<?, ?> context, boolean isKey) {
        Deserializer deserializerToUse;
        if (specificDeserializer == null) {
            deserializerToUse = isKey ? context.keySerde().deserializer() : context.valueSerde().deserializer();
        } else {
            deserializerToUse = specificDeserializer;
            WrappingNullableUtils.initNullableDeserializer(deserializerToUse, new SerdeGetter(context));
        }
        return deserializerToUse;
    }

    private static <T> Serializer<T> prepareSerializer(Serializer<T> specificSerializer, ProcessorContext<?, ?> context, boolean isKey) {
        Serializer serializerToUse;
        if (specificSerializer == null) {
            serializerToUse = isKey ? context.keySerde().serializer() : context.valueSerde().serializer();
        } else {
            serializerToUse = specificSerializer;
            WrappingNullableUtils.initNullableSerializer(serializerToUse, new SerdeGetter(context));
        }
        return serializerToUse;
    }

    private static <T> Serde<T> prepareSerde(Serde<T> specificSerde, SerdeGetter getter, boolean isKey) {
        Object serdeToUse = specificSerde == null ? (isKey ? getter.keySerde() : getter.valueSerde()) : specificSerde;
        if (serdeToUse instanceof WrappingNullableSerde) {
            ((WrappingNullableSerde)serdeToUse).setIfUnset(getter);
        }
        return serdeToUse;
    }

    public static <K> Deserializer<K> prepareKeyDeserializer(Deserializer<K> specificDeserializer, ProcessorContext<K, ?> context) {
        return WrappingNullableUtils.prepareDeserializer(specificDeserializer, context, true);
    }

    public static <V> Deserializer<V> prepareValueDeserializer(Deserializer<V> specificDeserializer, ProcessorContext<?, V> context) {
        return WrappingNullableUtils.prepareDeserializer(specificDeserializer, context, false);
    }

    public static <K> Serializer<K> prepareKeySerializer(Serializer<K> specificSerializer, ProcessorContext<?, ?> context) {
        return WrappingNullableUtils.prepareSerializer(specificSerializer, context, true);
    }

    public static <V> Serializer<V> prepareValueSerializer(Serializer<V> specificSerializer, ProcessorContext<?, ?> context) {
        return WrappingNullableUtils.prepareSerializer(specificSerializer, context, false);
    }

    public static <K> Serde<K> prepareKeySerde(Serde<K> specificSerde, SerdeGetter getter) {
        return WrappingNullableUtils.prepareSerde(specificSerde, getter, true);
    }

    public static <V> Serde<V> prepareValueSerde(Serde<V> specificSerde, SerdeGetter getter) {
        return WrappingNullableUtils.prepareSerde(specificSerde, getter, false);
    }

    public static <T> void initNullableSerializer(Serializer<T> specificSerializer, SerdeGetter getter) {
        if (specificSerializer instanceof WrappingNullableSerializer) {
            ((WrappingNullableSerializer)specificSerializer).setIfUnset(getter);
        }
    }

    public static <T> void initNullableDeserializer(Deserializer<T> specificDeserializer, SerdeGetter getter) {
        if (specificDeserializer instanceof WrappingNullableDeserializer) {
            ((WrappingNullableDeserializer)specificDeserializer).setIfUnset(getter);
        }
    }
}

