/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;

public class NameBindingUtil {
    private static final Predicate<DotName> CLASS_ANNOTATION_SKIP_PREDICATE = new Predicate<DotName>(){

        @Override
        public boolean test(DotName dotName) {
            String className = dotName.toString();
            return className.contains("NonNull") || className.startsWith("lombok");
        }
    };

    public static Set<String> nameBindingNames(IndexView index, ClassInfo classInfo) {
        return NameBindingUtil.nameBindingNames(index, NameBindingUtil.instanceDotNames(classInfo.declaredAnnotations()));
    }

    public static Set<String> nameBindingNames(IndexView index, MethodInfo methodInfo, Set<String> forClass) {
        Set<String> fromMethod = NameBindingUtil.nameBindingNames(index, NameBindingUtil.instanceDotNames(methodInfo.annotations()));
        if (fromMethod.isEmpty()) {
            return forClass;
        }
        fromMethod.addAll(forClass);
        return fromMethod;
    }

    private static List<DotName> instanceDotNames(Collection<AnnotationInstance> instances) {
        ArrayList<DotName> result = new ArrayList<DotName>(instances.size());
        for (AnnotationInstance instance : instances) {
            result.add(instance.name());
        }
        return result;
    }

    private static Set<String> nameBindingNames(IndexView index, Collection<DotName> annotations) {
        HashSet<String> result = new HashSet<String>();
        for (DotName classAnnotationDotName : annotations) {
            ClassInfo classAnnotation;
            if (classAnnotationDotName.equals((Object)ResteasyReactiveDotNames.PATH) || classAnnotationDotName.equals((Object)ResteasyReactiveDotNames.CONSUMES) || classAnnotationDotName.equals((Object)ResteasyReactiveDotNames.PRODUCES) || CLASS_ANNOTATION_SKIP_PREDICATE.test(classAnnotationDotName) || (classAnnotation = index.getClassByName(classAnnotationDotName)) == null || classAnnotation.declaredAnnotation(ResteasyReactiveDotNames.NAME_BINDING) == null) continue;
            result.add(classAnnotation.name().toString());
        }
        return result;
    }
}

