/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import io.quarkus.runtime.Quarkus;
import io.smallrye.config.ConfigValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.StreamSupport;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.KeycloakConfigSourceProvider;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import picocli.CommandLine;

@CommandLine.Command(name="show-config", header={"Print out the current configuration."}, description={"%nPrint out the current configuration."})
public final class ShowConfig
extends AbstractCommand {
    public static final String NAME = "show-config";
    private static final List<String> allowedSystemPropertyKeys = List.of("kc.version");
    @CommandLine.Parameters(paramLabel="filter", defaultValue="none", description={"Show all configuration options. Use 'all' to show all options."})
    String filter;

    @Override
    public String getDefaultProfile() {
        return null;
    }

    @Override
    protected void runCommand() {
        String profile = org.keycloak.common.util.Environment.getProfile();
        this.spec.commandLine().getOut().printf("Current Mode: %s%n", Environment.getKeycloakModeFromProfile(profile));
        this.spec.commandLine().getOut().println("Current Configuration:");
        HashSet uniqueNames = new HashSet();
        ArrayList quarkusValues = new ArrayList();
        StreamSupport.stream(Configuration.getPropertyNames().spliterator(), false).forEachOrdered(property -> {
            String from;
            ConfigValue configValue = Configuration.getConfigValue(property);
            if (configValue.getValue() == null) {
                return;
            }
            if (configValue.getSourceName() == null) {
                return;
            }
            PropertyMapper<?> mapper = PropertyMappers.getMapper(property);
            if (mapper == null && configValue.getSourceName().equals("SysPropConfigSource") && !allowedSystemPropertyKeys.contains(property)) {
                return;
            }
            if (mapper != null && !property.equals(from = mapper.forKey((String)property).getFrom())) {
                ConfigValue value = Configuration.getConfigValue(from);
                if (value.getValue() != null) {
                    return;
                }
                configValue = value;
                property = from;
            }
            if (!uniqueNames.add(property)) {
                return;
            }
            if (property.startsWith("quarkus.")) {
                if (mapper == null) {
                    quarkusValues.add(configValue);
                    return;
                }
            } else if (!property.startsWith("kc.")) {
                return;
            }
            this.printProperty((String)property, mapper, configValue);
        });
        if (this.filter.equalsIgnoreCase("all")) {
            this.spec.commandLine().getOut().println("Quarkus Configuration:");
            quarkusValues.forEach(v -> this.printProperty(v.getName(), null, (ConfigValue)v));
        }
        Quarkus.asyncExit((int)0);
    }

    private void printProperty(String property, PropertyMapper<?> mapper, ConfigValue configValue) {
        String sourceName = configValue.getConfigSourceName();
        String value = configValue.getValue();
        value = PropertyMappers.maskValue(value, sourceName, mapper);
        this.spec.commandLine().getOut().printf("\t%s =  %s (%s)%n", property, value, KeycloakConfigSourceProvider.getConfigSourceDisplayName(sourceName));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isHelpAll() {
        return false;
    }
}

