/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jgroups.certificates;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Retry;
import org.keycloak.common.util.Time;
import org.keycloak.jgroups.certificates.JGroupsCertificate;
import org.keycloak.jgroups.certificates.ReloadingX509ExtendedKeyManager;
import org.keycloak.jgroups.certificates.ReloadingX509ExtendedTrustManager;
import org.keycloak.jgroups.certificates.Utils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.spi.infinispan.JGroupsCertificateProvider;
import org.keycloak.storage.configuration.ServerConfigStorageProvider;

public class DatabaseJGroupsCertificateProvider
implements JGroupsCertificateProvider {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    public static final String CERTIFICATE_ID = "crt_jgroups";
    private static final int STARTUP_RETRIES = 5;
    private static final int STARTUP_RETRY_SLEEP_MILLIS = 500;
    private final KeycloakSessionFactory sessionFactory;
    private final ReloadingX509ExtendedKeyManager keyManager;
    private final ReloadingX509ExtendedTrustManager trustManager;
    private final Lock lock = new ReentrantLock();
    private volatile Duration rotationPeriod;
    private volatile JGroupsCertificate currentCertificate;

    private DatabaseJGroupsCertificateProvider(KeycloakSessionFactory sessionFactory, Duration rotationPeriod) {
        this.sessionFactory = Objects.requireNonNull(sessionFactory);
        this.rotationPeriod = Objects.requireNonNull(rotationPeriod);
        this.keyManager = new ReloadingX509ExtendedKeyManager();
        this.trustManager = new ReloadingX509ExtendedTrustManager();
        this.currentCertificate = new JGroupsCertificate();
    }

    public static DatabaseJGroupsCertificateProvider create(KeycloakSessionFactory factory, Duration rotationPeriod) {
        DatabaseJGroupsCertificateProvider provider = new DatabaseJGroupsCertificateProvider(factory, rotationPeriod);
        provider.init();
        return provider;
    }

    private void init() {
        logger.debug((Object)"Initializing JGroups mTLS certificate.");
        JGroupsCertificate cert = (JGroupsCertificate)Retry.call(ignored -> (JGroupsCertificate)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)this.sessionFactory, this::loadOrCreateCertificate), (int)5, (long)500L);
        this.useCertificate(cert);
        this.trustManager.setExceptionHandler(this::onTrustManagerException);
    }

    @Override
    public void rotateCertificate() {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, this::replaceCertificateFromDatabase);
    }

    @Override
    public void reloadCertificate() {
        this.doReload();
    }

    @Override
    public Duration nextRotation() {
        JGroupsCertificate cert = this.currentCertificate;
        return this.delayUntilNextRotation(Instant.ofEpochMilli(cert.getGeneratedMillis()), cert.getCertificate().getNotAfter().toInstant());
    }

    @Override
    public boolean supportRotateAndReload() {
        return true;
    }

    @Override
    public KeyManager keyManager() {
        return this.keyManager;
    }

    @Override
    public TrustManager trustManager() {
        return this.trustManager;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public void setRotationPeriod(Duration rotationPeriod) {
        this.rotationPeriod = Objects.requireNonNull(rotationPeriod);
    }

    public Duration getRotationPeriod() {
        return this.rotationPeriod;
    }

    public JGroupsCertificate getCurrentCertificate() {
        return this.currentCertificate;
    }

    private void onTrustManagerException() {
        this.doReload();
    }

    private void doReload() {
        ((Optional)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)this.sessionFactory, DatabaseJGroupsCertificateProvider::loadCertificateFromDatabase)).map(JGroupsCertificate::fromJson).ifPresent(this::useCertificate);
    }

    private Duration delayUntilNextRotation(Instant certificateStartInstant, Instant certificateEndInstant) {
        Instant rotationInstant = certificateStartInstant.plus(Duration.between(certificateStartInstant, certificateEndInstant).dividedBy(2L));
        Instant configuredRotation = certificateStartInstant.plus(this.rotationPeriod);
        long secondsLeft = configuredRotation.isBefore(rotationInstant) ? Instant.ofEpochSecond(Time.currentTime()).until(configuredRotation, ChronoUnit.SECONDS) : Instant.ofEpochSecond(Time.currentTime()).until(rotationInstant, ChronoUnit.SECONDS);
        return secondsLeft > 0L ? Duration.ofSeconds(secondsLeft) : Duration.ZERO;
    }

    private static Optional<String> loadCertificateFromDatabase(KeycloakSession session) {
        return ((ServerConfigStorageProvider)session.getProvider(ServerConfigStorageProvider.class)).find(CERTIFICATE_ID);
    }

    private void replaceCertificateFromDatabase(KeycloakSession session) {
        ServerConfigStorageProvider storage = (ServerConfigStorageProvider)session.getProvider(ServerConfigStorageProvider.class);
        storage.replace(CERTIFICATE_ID, this.currentCertificate::isSameAlias, this::generateSelfSignedCertificate);
    }

    private void useCertificate(JGroupsCertificate certificate) {
        this.lock.lock();
        try {
            if (Objects.equals(this.currentCertificate.getAlias(), certificate.getAlias())) {
                return;
            }
            X509ExtendedKeyManager km = Utils.createKeyManager(certificate);
            X509ExtendedTrustManager tm = Utils.createTrustManager(certificate);
            this.currentCertificate = certificate;
            this.keyManager.reload(km);
            this.trustManager.reload(tm);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private JGroupsCertificate loadOrCreateCertificate(KeycloakSession session) {
        ServerConfigStorageProvider storage = (ServerConfigStorageProvider)session.getProvider(ServerConfigStorageProvider.class);
        return JGroupsCertificate.fromJson(storage.loadOrCreate(CERTIFICATE_ID, this::generateSelfSignedCertificate));
    }

    private String generateSelfSignedCertificate() {
        return JGroupsCertificate.toJson(Utils.generateSelfSignedCertificate(this.rotationPeriod.multipliedBy(2L)));
    }
}

