/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.jwtauthorizationgrant;

import java.util.Map;

public interface JWTAuthorizationGrantConfig {
    public static final String JWT_AUTHORIZATION_GRANT_ENABLED = "jwtAuthorizationGrantEnabled";
    public static final String JWT_AUTHORIZATION_GRANT_ASSERTION_REUSE_ALLOWED = "jwtAuthorizationGrantAssertionReuseAllowed";
    public static final String JWT_AUTHORIZATION_GRANT_MAX_ALLOWED_ASSERTION_EXPIRATION = "jwtAuthorizationGrantMaxAllowedAssertionExpiration";
    public static final String JWT_AUTHORIZATION_GRANT_ASSERTION_SIGNATURE_ALG = "jwtAuthorizationGrantAssertionSignatureAlg";
    public static final String JWT_AUTHORIZATION_GRANT_LIMIT_ACCESS_TOKEN_EXP = "jwtAuthorizationGrantLimitAccessTokenExp";
    public static final String JWT_AUTHORIZATION_GRANT_ALLOWED_CLOCK_SKEW = "jwtAuthorizationGrantAllowedClockSkew";
    public static final String PUBLIC_KEY_SIGNATURE_VERIFIER = "publicKeySignatureVerifier";
    public static final String PUBLIC_KEY_SIGNATURE_VERIFIER_KEY_ID = "publicKeySignatureVerifierKeyId";

    public Map<String, String> getConfig();

    default public boolean isJWTAuthorizationGrantEnabled() {
        return Boolean.parseBoolean(this.getConfig().getOrDefault(JWT_AUTHORIZATION_GRANT_ENABLED, "false"));
    }

    default public void setJWTAuthorizationGrantEnabled(boolean jwtAuthorizationGrantEnableds) {
        this.getConfig().put(JWT_AUTHORIZATION_GRANT_ENABLED, String.valueOf(jwtAuthorizationGrantEnableds));
    }

    default public boolean isJWTAuthorizationGrantAssertionReuseAllowed() {
        return Boolean.parseBoolean(this.getConfig().getOrDefault(JWT_AUTHORIZATION_GRANT_ASSERTION_REUSE_ALLOWED, "false"));
    }

    default public int getJWTAuthorizationGrantMaxAllowedAssertionExpiration() {
        return Integer.parseInt(this.getConfig().getOrDefault(JWT_AUTHORIZATION_GRANT_MAX_ALLOWED_ASSERTION_EXPIRATION, "300"));
    }

    default public String getJWTAuthorizationGrantAssertionSignatureAlg() {
        return this.getConfig().get(JWT_AUTHORIZATION_GRANT_ASSERTION_SIGNATURE_ALG);
    }

    default public boolean isJwtAuthorizationGrantLimitAccessTokenExp() {
        return Boolean.parseBoolean(this.getConfig().getOrDefault(JWT_AUTHORIZATION_GRANT_LIMIT_ACCESS_TOKEN_EXP, "false"));
    }

    default public int getJWTAuthorizationGrantAllowedClockSkew() {
        String allowedClockSkew = this.getConfig().get(JWT_AUTHORIZATION_GRANT_ALLOWED_CLOCK_SKEW);
        if (allowedClockSkew == null || allowedClockSkew.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(this.getConfig().get(JWT_AUTHORIZATION_GRANT_ALLOWED_CLOCK_SKEW));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    default public String getPublicKeySignatureVerifier() {
        return this.getConfig().get(PUBLIC_KEY_SIGNATURE_VERIFIER);
    }

    default public void setPublicKeySignatureVerifier(String signingCertificate) {
        if (signingCertificate == null) {
            this.getConfig().remove(PUBLIC_KEY_SIGNATURE_VERIFIER);
        } else {
            this.getConfig().put(PUBLIC_KEY_SIGNATURE_VERIFIER, signingCertificate);
        }
    }

    default public String getPublicKeySignatureVerifierKeyId() {
        return this.getConfig().get(PUBLIC_KEY_SIGNATURE_VERIFIER_KEY_ID);
    }

    default public void setPublicKeySignatureVerifierKeyId(String publicKeySignatureVerifierKeyId) {
        if (publicKeySignatureVerifierKeyId == null) {
            this.getConfig().remove(PUBLIC_KEY_SIGNATURE_VERIFIER_KEY_ID);
        } else {
            this.getConfig().put(PUBLIC_KEY_SIGNATURE_VERIFIER_KEY_ID, publicKeySignatureVerifierKeyId);
        }
    }

    default public boolean isUseJwksUrl() {
        return Boolean.parseBoolean(this.getConfig().get("useJwksUrl"));
    }

    default public void setUseJwksUrl(boolean useJwksUrl) {
        this.getConfig().put("useJwksUrl", String.valueOf(useJwksUrl));
    }

    default public String getIssuer() {
        return this.getConfig().get("issuer");
    }

    default public void setIssuer(String issuer) {
        this.getConfig().put("issuer", issuer);
    }

    default public String getJwksUrl() {
        return this.getConfig().get("jwksUrl");
    }

    default public void setJwksUrl(String jwksUrl) {
        this.getConfig().put("jwksUrl", jwksUrl);
    }

    public String getInternalId();

    public String getAlias();
}

