/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.micrometer.v1_5;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import io.opentelemetry.instrumentation.micrometer.v1_5.Bridging;
import io.opentelemetry.instrumentation.micrometer.v1_5.DoubleMeasurementRecorder;
import io.opentelemetry.instrumentation.micrometer.v1_5.RemovableMeter;
import io.opentelemetry.instrumentation.micrometer.v1_5.UnsupportedReadLogger;
import java.util.Collections;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;

final class OpenTelemetryGauge<T>
extends AbstractMeter
implements Gauge,
RemovableMeter {
    private final ObservableDoubleGauge observableGauge;

    OpenTelemetryGauge(Meter.Id id, NamingConvention namingConvention, @Nullable T obj, ToDoubleFunction<T> objMetric, Meter otelMeter) {
        super(id);
        String name = Bridging.name(id, namingConvention);
        this.observableGauge = otelMeter.gaugeBuilder(name).setDescription(Bridging.description(id)).setUnit(Bridging.baseUnit(id)).buildWithCallback(new DoubleMeasurementRecorder<T>(obj, objMetric, Bridging.tagsAsAttributes(id, namingConvention)));
    }

    public double value() {
        UnsupportedReadLogger.logWarning();
        return Double.NaN;
    }

    public Iterable<Measurement> measure() {
        UnsupportedReadLogger.logWarning();
        return Collections.emptyList();
    }

    @Override
    public void onRemove() {
        this.observableGauge.close();
    }
}

