/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.function.Function;
import java.util.function.UnaryOperator;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.common.CriStats;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.util.MappedGetter;

class CriStatsRegistry {
    private final MappedGetter<ConnectionRetrievalInfo, CriStats> criStatsMap = new MappedGetter();
    private static final UnaryOperator<ConnectionRetrievalInfo> keyConverter = cri -> {
        if (cri instanceof JDBCConnectionRetrievalInfo) {
            JDBCConnectionRetrievalInfo jcri = (JDBCConnectionRetrievalInfo)cri;
            JDBCConnectionRetrievalInfo copyJcri = new JDBCConnectionRetrievalInfo(jcri);
            copyJcri.getBorrowContextUpdater().user(jcri.getUser()).password(jcri.getPassword());
            return copyJcri;
        }
        return cri;
    };
    private static final Function<ConnectionRetrievalInfo, CriStats> mappingFunction = cri -> new CriStats();

    CriStatsRegistry() {
    }

    CriStats getCriStats(ConnectionRetrievalInfo cri) {
        return this.criStatsMap.computeIfAbsent(cri, mappingFunction, keyConverter);
    }

    int size() {
        return this.criStatsMap.size();
    }

    public String toString() {
        return "CriStatsRegistry=[" + this.criStatsMap + "]";
    }
}

