/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardLease
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardLease> {
    @Nonnull
    private final String id;
    private final long retainingSeqNo;
    @Nonnull
    private final String source;
    private final long timestamp;
    public static final JsonpDeserializer<ShardLease> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardLease::setupShardLeaseDeserializer);

    private ShardLease(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.retainingSeqNo = ApiTypeHelper.requireNonNull(builder.retainingSeqNo, this, "retainingSeqNo");
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
    }

    public static ShardLease of(Function<Builder, ObjectBuilder<ShardLease>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String id() {
        return this.id;
    }

    public final long retainingSeqNo() {
        return this.retainingSeqNo;
    }

    @Nonnull
    public final String source() {
        return this.source;
    }

    public final long timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("retaining_seq_no");
        generator.write(this.retainingSeqNo);
        generator.writeKey("source");
        generator.write(this.source);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardLeaseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::retainingSeqNo, JsonpDeserializer.longDeserializer(), "retaining_seq_no");
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Long.hashCode(this.retainingSeqNo);
        result = 31 * result + this.source.hashCode();
        result = 31 * result + Long.hashCode(this.timestamp);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardLease other = (ShardLease)o;
        return this.id.equals(other.id) && this.retainingSeqNo == other.retainingSeqNo && this.source.equals(other.source) && this.timestamp == other.timestamp;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardLease> {
        private String id;
        private Long retainingSeqNo;
        private String source;
        private Long timestamp;

        public Builder() {
        }

        private Builder(ShardLease o) {
            this.id = o.id;
            this.retainingSeqNo = o.retainingSeqNo;
            this.source = o.source;
            this.timestamp = o.timestamp;
        }

        private Builder(Builder o) {
            this.id = o.id;
            this.retainingSeqNo = o.retainingSeqNo;
            this.source = o.source;
            this.timestamp = o.timestamp;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder retainingSeqNo(long value) {
            this.retainingSeqNo = value;
            return this;
        }

        @Nonnull
        public final Builder source(String value) {
            this.source = value;
            return this;
        }

        @Nonnull
        public final Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        @Override
        @Nonnull
        public ShardLease build() {
            this._checkSingleUse();
            return new ShardLease(this);
        }
    }
}

