/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.termvectors;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Token
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Token> {
    @Nullable
    private final Integer endOffset;
    @Nullable
    private final String payload;
    private final int position;
    @Nullable
    private final Integer startOffset;
    public static final JsonpDeserializer<Token> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Token::setupTokenDeserializer);

    private Token(Builder builder) {
        this.endOffset = builder.endOffset;
        this.payload = builder.payload;
        this.position = ApiTypeHelper.requireNonNull(builder.position, this, "position");
        this.startOffset = builder.startOffset;
    }

    public static Token of(Function<Builder, ObjectBuilder<Token>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer endOffset() {
        return this.endOffset;
    }

    @Nullable
    public final String payload() {
        return this.payload;
    }

    public final int position() {
        return this.position;
    }

    @Nullable
    public final Integer startOffset() {
        return this.startOffset;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.endOffset != null) {
            generator.writeKey("end_offset");
            generator.write(this.endOffset.intValue());
        }
        if (this.payload != null) {
            generator.writeKey("payload");
            generator.write(this.payload);
        }
        generator.writeKey("position");
        generator.write(this.position);
        if (this.startOffset != null) {
            generator.writeKey("start_offset");
            generator.write(this.startOffset.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTokenDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::endOffset, JsonpDeserializer.integerDeserializer(), "end_offset");
        op.add(Builder::payload, JsonpDeserializer.stringDeserializer(), "payload");
        op.add(Builder::position, JsonpDeserializer.integerDeserializer(), "position");
        op.add(Builder::startOffset, JsonpDeserializer.integerDeserializer(), "start_offset");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.endOffset);
        result = 31 * result + Objects.hashCode(this.payload);
        result = 31 * result + Integer.hashCode(this.position);
        result = 31 * result + Objects.hashCode(this.startOffset);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token other = (Token)o;
        return Objects.equals(this.endOffset, other.endOffset) && Objects.equals(this.payload, other.payload) && this.position == other.position && Objects.equals(this.startOffset, other.startOffset);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Token> {
        @Nullable
        private Integer endOffset;
        @Nullable
        private String payload;
        private Integer position;
        @Nullable
        private Integer startOffset;

        public Builder() {
        }

        private Builder(Token o) {
            this.endOffset = o.endOffset;
            this.payload = o.payload;
            this.position = o.position;
            this.startOffset = o.startOffset;
        }

        private Builder(Builder o) {
            this.endOffset = o.endOffset;
            this.payload = o.payload;
            this.position = o.position;
            this.startOffset = o.startOffset;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder endOffset(@Nullable Integer value) {
            this.endOffset = value;
            return this;
        }

        @Nonnull
        public final Builder payload(@Nullable String value) {
            this.payload = value;
            return this;
        }

        @Nonnull
        public final Builder position(int value) {
            this.position = value;
            return this;
        }

        @Nonnull
        public final Builder startOffset(@Nullable Integer value) {
            this.startOffset = value;
            return this;
        }

        @Override
        @Nonnull
        public Token build() {
            this._checkSingleUse();
            return new Token(this);
        }
    }
}

