/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.transfermanager;

import com.google.cloud.storage.ParallelCompositeUploadBlobWriteSessionConfig;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.transfermanager.DefaultQos;
import com.google.cloud.storage.transfermanager.TransferManager;
import com.google.cloud.storage.transfermanager.TransferManagerImpl;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class TransferManagerConfig {
    private final int maxWorkers;
    private final int perWorkerBufferSize;
    private final boolean allowDivideAndConquerDownload;
    private final boolean allowParallelCompositeUpload;
    private final ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy partNamingStrategy;
    private final StorageOptions storageOptions;

    TransferManagerConfig(int maxWorkers, int perWorkerBufferSize, boolean allowDivideAndConquerDownload, boolean allowParallelCompositeUpload, ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy partNamingStrategy, StorageOptions storageOptions) {
        this.maxWorkers = maxWorkers;
        this.perWorkerBufferSize = perWorkerBufferSize;
        this.allowDivideAndConquerDownload = allowDivideAndConquerDownload;
        this.allowParallelCompositeUpload = allowParallelCompositeUpload;
        this.partNamingStrategy = partNamingStrategy;
        this.storageOptions = storageOptions;
    }

    public int getMaxWorkers() {
        return this.maxWorkers;
    }

    public int getPerWorkerBufferSize() {
        return this.perWorkerBufferSize;
    }

    public boolean isAllowDivideAndConquerDownload() {
        return this.allowDivideAndConquerDownload;
    }

    public boolean isAllowParallelCompositeUpload() {
        return this.allowParallelCompositeUpload;
    }

    public StorageOptions getStorageOptions() {
        return this.storageOptions;
    }

    public ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy getParallelCompositeUploadPartNamingStrategy() {
        return this.partNamingStrategy;
    }

    public TransferManager getService() {
        return new TransferManagerImpl(this, DefaultQos.of(this));
    }

    public Builder toBuilder() {
        return new Builder().setAllowDivideAndConquerDownload(this.allowDivideAndConquerDownload).setAllowParallelCompositeUpload(this.allowParallelCompositeUpload).setMaxWorkers(this.maxWorkers).setPerWorkerBufferSize(this.perWorkerBufferSize).setStorageOptions(this.storageOptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransferManagerConfig)) {
            return false;
        }
        TransferManagerConfig that = (TransferManagerConfig)o;
        return this.maxWorkers == that.maxWorkers && this.perWorkerBufferSize == that.perWorkerBufferSize && this.allowDivideAndConquerDownload == that.allowDivideAndConquerDownload && this.allowParallelCompositeUpload == that.allowParallelCompositeUpload && Objects.equals((Object)this.storageOptions, (Object)that.storageOptions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.maxWorkers, this.perWorkerBufferSize, this.allowDivideAndConquerDownload, this.allowParallelCompositeUpload, this.storageOptions});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("maxWorkers", this.maxWorkers).add("perWorkerBufferSize", this.perWorkerBufferSize).add("allowDivideAndConquerDownload", this.allowDivideAndConquerDownload).add("allowParallelCompositeUpload", this.allowParallelCompositeUpload).add("storageOptions", (Object)this.storageOptions).toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private int maxWorkers = 2 * Runtime.getRuntime().availableProcessors();
        private int perWorkerBufferSize = 0x1000000;
        private boolean allowDivideAndConquerDownload = false;
        private boolean allowParallelCompositeUpload = false;
        private StorageOptions storageOptions = StorageOptions.getDefaultInstance();
        private ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy partNamingStrategy = ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy.noPrefix();

        private Builder() {
        }

        public Builder setMaxWorkers(int maxWorkers) {
            this.maxWorkers = maxWorkers;
            return this;
        }

        public Builder setPerWorkerBufferSize(int perWorkerBufferSize) {
            this.perWorkerBufferSize = perWorkerBufferSize;
            return this;
        }

        public Builder setAllowDivideAndConquerDownload(boolean allowDivideAndConquerDownload) {
            this.allowDivideAndConquerDownload = allowDivideAndConquerDownload;
            return this;
        }

        public Builder setAllowParallelCompositeUpload(boolean allowParallelCompositeUpload) {
            this.allowParallelCompositeUpload = allowParallelCompositeUpload;
            return this;
        }

        public Builder setStorageOptions(StorageOptions storageOptions) {
            this.storageOptions = storageOptions;
            return this;
        }

        public Builder setParallelCompositeUploadPartNamingStrategy(ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy partNamingStrategy) {
            Preconditions.checkNotNull((Object)partNamingStrategy);
            this.partNamingStrategy = partNamingStrategy;
            return this;
        }

        public TransferManagerConfig build() {
            return new TransferManagerConfig(this.maxWorkers, this.perWorkerBufferSize, this.allowDivideAndConquerDownload, this.allowParallelCompositeUpload, this.partNamingStrategy, this.storageOptions);
        }
    }
}

