/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.util.encoders.Hex;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.Version;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.PitService;
import org.opensearch.action.support.ActionFilter;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.NamedDiff;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.lifecycle.Lifecycle;
import org.opensearch.common.lifecycle.LifecycleComponent;
import org.opensearch.common.lifecycle.LifecycleListener;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.PageCacheRecycler;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.index.Index;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.extensions.ExtensionsManager;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.http.netty4.ssl.SecureNetty4HttpServerTransport;
import org.opensearch.identity.PluginSubject;
import org.opensearch.identity.Subject;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexService;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.cache.query.QueryCache;
import org.opensearch.index.shard.IndexEventListener;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.indices.IndicesQueryCache;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.ClusterPlugin;
import org.opensearch.plugins.ExtensiblePlugin;
import org.opensearch.plugins.ExtensionAwarePlugin;
import org.opensearch.plugins.IdentityPlugin;
import org.opensearch.plugins.MapperPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SecureHttpTransportSettingsProvider;
import org.opensearch.plugins.SecureSettingsFactory;
import org.opensearch.plugins.SecureTransportSettingsProvider;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.search.internal.InternalScrollSearchRequest;
import org.opensearch.search.internal.ReaderContext;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.security.action.configupdate.ConfigUpdateAction;
import org.opensearch.security.action.configupdate.TransportConfigUpdateAction;
import org.opensearch.security.action.onbehalf.CreateOnBehalfOfTokenAction;
import org.opensearch.security.action.whoami.TransportWhoAmIAction;
import org.opensearch.security.action.whoami.WhoAmIAction;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auditlog.AuditLogSslExceptionHandler;
import org.opensearch.security.auditlog.NullAuditLog;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.auditlog.impl.AuditLogImpl;
import org.opensearch.security.auth.BackendRegistry;
import org.opensearch.security.compliance.ComplianceIndexingOperationListenerImpl;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ClusterInfoHolder;
import org.opensearch.security.configuration.CompatConfig;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.configuration.DlsFlsRequestValve;
import org.opensearch.security.configuration.DlsFlsValveImpl;
import org.opensearch.security.configuration.PrivilegesInterceptorImpl;
import org.opensearch.security.configuration.SecurityFlsDlsIndexSearcherWrapper;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityRestApiActions;
import org.opensearch.security.dlic.rest.api.ssl.CertificatesActionType;
import org.opensearch.security.dlic.rest.api.ssl.TransportCertificatesInfoNodesAction;
import org.opensearch.security.dlic.rest.validation.PasswordValidator;
import org.opensearch.security.filter.SecurityFilter;
import org.opensearch.security.filter.SecurityRestFilter;
import org.opensearch.security.hasher.PasswordHasher;
import org.opensearch.security.hasher.PasswordHasherFactory;
import org.opensearch.security.http.NonSslHttpServerTransport;
import org.opensearch.security.http.XFFResolver;
import org.opensearch.security.identity.SecurePluginSubject;
import org.opensearch.security.identity.SecurityTokenManager;
import org.opensearch.security.privileges.PrivilegesEvaluationException;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.privileges.PrivilegesInterceptor;
import org.opensearch.security.privileges.RestLayerPrivilegesEvaluator;
import org.opensearch.security.privileges.actionlevel.RoleBasedActionPrivileges;
import org.opensearch.security.privileges.dlsfls.DlsFlsBaseContext;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.resources.ResourceAccessControlClient;
import org.opensearch.security.resources.ResourceAccessHandler;
import org.opensearch.security.resources.ResourceIndexListener;
import org.opensearch.security.resources.ResourcePluginInfo;
import org.opensearch.security.resources.ResourceSharingIndexHandler;
import org.opensearch.security.resources.api.share.ShareAction;
import org.opensearch.security.resources.api.share.ShareRestAction;
import org.opensearch.security.resources.api.share.ShareTransportAction;
import org.opensearch.security.rest.DashboardsInfoAction;
import org.opensearch.security.rest.SecurityConfigUpdateAction;
import org.opensearch.security.rest.SecurityHealthAction;
import org.opensearch.security.rest.SecurityInfoAction;
import org.opensearch.security.rest.SecurityWhoAmIAction;
import org.opensearch.security.rest.TenantInfoAction;
import org.opensearch.security.securityconf.DynamicConfigFactory;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.setting.DeprecatedSettings;
import org.opensearch.security.setting.OpensearchDynamicSetting;
import org.opensearch.security.setting.TransportPassiveAuthSetting;
import org.opensearch.security.spi.resources.ResourceSharingExtension;
import org.opensearch.security.ssl.ExternalSecurityKeyStore;
import org.opensearch.security.ssl.OpenSearchSecureSettingsFactory;
import org.opensearch.security.ssl.OpenSearchSecuritySSLPlugin;
import org.opensearch.security.ssl.SslExceptionHandler;
import org.opensearch.security.ssl.http.netty.ValidatingDispatcher;
import org.opensearch.security.ssl.transport.DefaultPrincipalExtractor;
import org.opensearch.security.state.SecurityMetadata;
import org.opensearch.security.support.ConfigConstants;
import org.opensearch.security.support.GuardedSearchOperationWrapper;
import org.opensearch.security.support.HeaderHelper;
import org.opensearch.security.support.ModuleInfo;
import org.opensearch.security.support.ReflectionHelper;
import org.opensearch.security.support.SecuritySettings;
import org.opensearch.security.transport.DefaultInterClusterRequestEvaluator;
import org.opensearch.security.transport.InterClusterRequestEvaluator;
import org.opensearch.security.transport.SecurityInterceptor;
import org.opensearch.security.user.User;
import org.opensearch.security.user.UserFactory;
import org.opensearch.security.user.UserService;
import org.opensearch.tasks.Task;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.RemoteClusterService;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportInterceptor;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.netty4.ssl.SecureNetty4Transport;
import org.opensearch.watcher.ResourceWatcherService;

public final class OpenSearchSecurityPlugin
extends OpenSearchSecuritySSLPlugin
implements ClusterPlugin,
MapperPlugin,
IdentityPlugin,
ExtensionAwarePlugin,
ExtensiblePlugin {
    private static final String KEYWORD = ".keyword";
    private static final Logger actionTrace = LogManager.getLogger((String)"opendistro_security_action_trace");
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(OpenSearchSecurityPlugin.class);
    @Deprecated
    public static final String LEGACY_OPENDISTRO_PREFIX = "_opendistro/_security";
    public static final String PLUGINS_PREFIX = "_plugins/_security";
    private boolean sslCertReloadEnabled;
    private volatile SecurityInterceptor si;
    private volatile PrivilegesEvaluator evaluator;
    private volatile UserService userService;
    private volatile RestLayerPrivilegesEvaluator restLayerEvaluator;
    private volatile ConfigurationRepository cr;
    private volatile AdminDNs adminDns;
    private volatile ClusterService cs;
    private volatile AtomicReference<DiscoveryNode> localNode = new AtomicReference();
    private volatile AuditLog auditLog;
    private volatile BackendRegistry backendRegistry;
    private volatile SslExceptionHandler sslExceptionHandler;
    private volatile Client localClient;
    private final boolean disabled;
    private volatile SecurityTokenManager tokenManager;
    private volatile DynamicConfigFactory dcf;
    private final List<String> demoCertHashes = new ArrayList<String>(3);
    private volatile SecurityFilter sf;
    private volatile IndexResolverReplacer irr;
    private final AtomicReference<NamedXContentRegistry> namedXContentRegistry = new AtomicReference<NamedXContentRegistry>(NamedXContentRegistry.EMPTY);
    private volatile DlsFlsRequestValve dlsFlsValve = null;
    private volatile OpensearchDynamicSetting<Boolean> transportPassiveAuthSetting;
    private volatile PasswordHasher passwordHasher;
    private volatile DlsFlsBaseContext dlsFlsBaseContext;
    private ResourceSharingIndexHandler rsIndexHandler;
    private final ResourcePluginInfo resourcePluginInfo = new ResourcePluginInfo();
    private final Set<ResourceSharingExtension> resourceSharingExtensions = new HashSet<ResourceSharingExtension>();

    public static boolean isActionTraceEnabled() {
        return actionTrace.isTraceEnabled();
    }

    public static void traceAction(String message) {
        actionTrace.trace(message);
    }

    public static void traceAction(String message, Object p0) {
        actionTrace.trace(message, p0);
    }

    public void close() throws IOException {
        super.close();
        if (this.auditLog != null) {
            this.auditLog.close();
        }
    }

    private final SslExceptionHandler evaluateSslExceptionHandler() {
        if (this.client || this.disabled || this.SSLConfig.isSslOnlyMode()) {
            return new SslExceptionHandler(this){};
        }
        return Objects.requireNonNull(this.sslExceptionHandler);
    }

    private static boolean isDisabled(Settings settings) {
        return settings.getAsBoolean("plugins.security.disabled", Boolean.valueOf(false));
    }

    private static boolean useClusterStateToInitSecurityConfig(Settings settings) {
        return settings.getAsBoolean("plugins.security.allow_default_init_securityindex.use_cluster_state", Boolean.valueOf(false));
    }

    private static boolean isSslCertReloadEnabled(Settings settings) {
        return settings.getAsBoolean("plugins.security.ssl_cert_reload_enabled", Boolean.valueOf(false));
    }

    private boolean sslCertificatesHotReloadEnabled(Settings settings) {
        return settings.getAsBoolean("plugins.security.ssl.certificates_hot_reload.enabled", Boolean.valueOf(false));
    }

    public OpenSearchSecurityPlugin(final Settings settings, final Path configPath) {
        super(settings, configPath, OpenSearchSecurityPlugin.isDisabled(settings));
        List<Path> filesWithWrongPermissions;
        this.disabled = OpenSearchSecurityPlugin.isDisabled(settings);
        this.sslCertReloadEnabled = OpenSearchSecurityPlugin.isSslCertReloadEnabled(settings);
        this.transportPassiveAuthSetting = new TransportPassiveAuthSetting(settings);
        if (this.disabled) {
            this.sslCertReloadEnabled = false;
            this.log.warn("OpenSearch Security plugin installed but disabled. This can expose your configuration (including passwords) to the public.");
            return;
        }
        if (settings.hasValue("plugins.security.ssl.http.enabled_protocols")) {
            this.verifyTLSVersion("plugins.security.ssl.http.enabled_protocols", settings.getAsList("plugins.security.ssl.http.enabled_protocols"));
        }
        if (settings.hasValue("plugins.security.ssl.transport.enabled_protocols")) {
            this.verifyTLSVersion("plugins.security.ssl.transport.enabled_protocols", settings.getAsList("plugins.security.ssl.transport.enabled_protocols"));
        }
        if (this.SSLConfig.isSslOnlyMode()) {
            this.sslCertReloadEnabled = false;
            this.log.warn("OpenSearch Security plugin run in ssl only mode. No authentication or authorization is performed");
            return;
        }
        this.demoCertHashes.add("54a92508de7a39d06242a0ffbf59414d7eb478633c719e6af03938daf6de8a1a");
        this.demoCertHashes.add("742e4659c79d7cad89ea86aab70aea490f23bbfc7e72abd5f0a5d3fb4c84d212");
        this.demoCertHashes.add("db1264612891406639ecd25c894f256b7c5a6b7e1d9054cbe37b77acd2ddd913");
        this.demoCertHashes.add("2a5398e20fcb851ec30aa141f37233ee91a802683415be2945c3c312c65c97cf");
        this.demoCertHashes.add("33129547ce617f784c04e965104b2c671cce9e794d1c64c7efe58c77026246ae");
        this.demoCertHashes.add("c4af0297cc75546e1905bdfe3934a950161eee11173d979ce929f086fdf9794d");
        this.demoCertHashes.add("7a355f42c90e7543a267fbe3976c02f619036f5a34ce712995a22b342d83c3ce");
        this.demoCertHashes.add("a9b5eca1399ec8518081c0d4a21a34eec4589087ce64c04fb01a488f9ad8edc9");
        this.demoCertHashes.add("d14aefe70a592d7a29e14f3ff89c3d0070c99e87d21776aa07d333ee877e758f");
        this.demoCertHashes.add("54a70016e0837a2b0c5658d1032d7ca32e432c62c55f01a2bf5adcb69a0a7ba9");
        this.demoCertHashes.add("bdc141ab2272c779d0f242b79063152c49e1b06a2af05e0fd90d505f2b44d5f5");
        this.demoCertHashes.add("3e839e2b059036a99ee4f742814995f2fb0ced7e9d68a47851f43a3c630b5324");
        this.demoCertHashes.add("9b13661c073d864c28ad7b13eda67dcb6cbc2f04d116adc7c817c20b4c7ed361");
        this.demoCertHashes.add("069beaf566b9cf631e3676b82da8c60a191c4d4ab2832ad18efe3a5bd2a875d6");
        this.demoCertHashes.add("25e34a9a5d4f1dceed1666eb624397bf3fe5787a7133cd32838ace0381bce1f7");
        this.demoCertHashes.add("dd3cf88e72e9e1a803bd12f4bafb4f29e642110db26c39ed5f2ef2e9351bc61c");
        this.demoCertHashes.add("ba9c5a61065f7f6115188128ffbdaa18fca34562b78b811f082439e2bef1d282");
        this.demoCertHashes.add("9948688bc4c7a198f2a0db1d91f4f54499b8626902d03361b6d43e822d3691e4");
        this.demoCertHashes.add("a3556d6bb61f7bd63cb19b1c8d0078d30c12739dedb0455c5792ac8627782042");
        this.demoCertHashes.add("a2ce3f577a5031398c1b4f58761444d837b031d0aff7614f8b9b5e4a9d59dbd1");
        this.demoCertHashes.add("cd708e8dc707ae065f7ad8582979764b497f062e273d478054ab2f49c5469c6");
        this.demoCertHashes.add("a3556d6bb61f7bd63cb19b1c8d0078d30c12739dedb0455c5792ac8627782042");
        this.demoCertHashes.add("25e34a9a5d4f1dceed1666eb624397bf3fe5787a7133cd32838ace0381bce1f7");
        this.demoCertHashes.add("a2ce3f577a5031398c1b4f58761444d837b031d0aff7614f8b9b5e4a9d59dbd1");
        this.demoCertHashes.add("ba9c5a61065f7f6115188128ffbdaa18fca34562b78b811f082439e2bef1d282");
        this.demoCertHashes.add("bcd708e8dc707ae065f7ad8582979764b497f062e273d478054ab2f49c5469c6");
        this.tryAddSecurityProvider();
        String advancedModulesEnabledKey = "plugins.security.advanced_modules_enabled";
        if (settings.hasValue("plugins.security.advanced_modules_enabled")) {
            deprecationLogger.deprecate("Setting {} is ignored.", "plugins.security.advanced_modules_enabled", new Object[0]);
        }
        DeprecatedSettings.checkForDeprecatedSetting(settings, "plugins.security.unsupported.restapi.allow_securityconfig_modification", RestApiAdminPrivilegesEvaluator.ENDPOINTS_WITH_PERMISSIONS.get((Object)Endpoint.CONFIG).build("update") + " permission");
        this.log.info("Clustername: {}", (Object)settings.get("cluster.name", "opensearch"));
        if (!this.transportSSLEnabled && !this.SSLConfig.isSslOnlyMode()) {
            throw new IllegalStateException("plugins.security.ssl.transport.enabled must be set to 'true'");
        }
        if (!this.client && (filesWithWrongPermissions = AccessController.doPrivileged(new PrivilegedAction<List<Path>>(){

            @Override
            public List<Path> run() {
                Path confPath = new Environment(settings, configPath).configDir().toAbsolutePath();
                if (Files.isDirectory(confPath, LinkOption.NOFOLLOW_LINKS)) {
                    List<Path> list;
                    block9: {
                        Stream<Path> s = Files.walk(confPath, new FileVisitOption[0]);
                        try {
                            list = s.distinct().filter(p -> OpenSearchSecurityPlugin.this.checkFilePermissions((Path)p)).collect(Collectors.toList());
                            if (s == null) break block9;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (s != null) {
                                    try {
                                        s.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                OpenSearchSecurityPlugin.this.log.error(e.toString());
                                return null;
                            }
                        }
                        s.close();
                    }
                    return list;
                }
                return Collections.emptyList();
            }
        })) != null && filesWithWrongPermissions.size() > 0) {
            for (Path p : filesWithWrongPermissions) {
                if (Files.isDirectory(p, LinkOption.NOFOLLOW_LINKS)) {
                    this.log.warn("Directory {} has insecure file permissions (should be 0700)", (Object)p);
                    continue;
                }
                this.log.warn("File {} has insecure file permissions (should be 0600)", (Object)p);
            }
        }
        try {
            String maskingAlgorithmDefault = settings.get("plugins.security.masked_fields.algorithm.default");
            if (StringUtils.isNotEmpty((CharSequence)maskingAlgorithmDefault) && !"BLAKE2B_LEGACY_DEFAULT".equalsIgnoreCase(maskingAlgorithmDefault)) {
                MessageDigest.getInstance(maskingAlgorithmDefault);
            }
        }
        catch (Exception ex) {
            throw new OpenSearchSecurityException("JVM does not support algorithm for {}", ex, new Object[]{"plugins.security.masked_fields.algorithm.default"});
        }
        if (!this.client && !settings.getAsBoolean("plugins.security.allow_unsafe_democertificates", Boolean.valueOf(false)).booleanValue()) {
            List<String> files = AccessController.doPrivileged(new PrivilegedAction<List<String>>(){

                @Override
                public List<String> run() {
                    Path confPath = new Environment(settings, configPath).configDir().toAbsolutePath();
                    if (Files.isDirectory(confPath, LinkOption.NOFOLLOW_LINKS)) {
                        List<String> list;
                        block9: {
                            Stream<Path> s = Files.walk(confPath, new FileVisitOption[0]);
                            try {
                                list = s.distinct().map(p -> OpenSearchSecurityPlugin.this.sha256((Path)p)).collect(Collectors.toList());
                                if (s == null) break block9;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (s != null) {
                                        try {
                                            s.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (Exception e) {
                                    OpenSearchSecurityPlugin.this.log.error(e.toString());
                                    return null;
                                }
                            }
                            s.close();
                        }
                        return list;
                    }
                    return Collections.emptyList();
                }
            });
            if (files != null) {
                this.demoCertHashes.retainAll(files);
                if (!this.demoCertHashes.isEmpty()) {
                    this.log.error("Demo certificates found but plugins.security.allow_unsafe_democertificates is set to false.");
                    throw new RuntimeException("Demo certificates found " + String.valueOf(this.demoCertHashes));
                }
            } else {
                throw new RuntimeException("Unable to look for demo certificates");
            }
        }
    }

    private void verifyTLSVersion(String settings, List<String> configuredProtocols) {
        for (String tls : configuredProtocols) {
            if (!tls.equalsIgnoreCase("TLSv1") && !tls.equalsIgnoreCase("TLSv1.1")) continue;
            deprecationLogger.deprecate(settings, "The '{}' setting contains {} protocol version which was deprecated since 2021 (RFC 8996). Support for it will be removed in the next major release.", new Object[]{settings, tls});
        }
    }

    private String sha256(Path p) {
        if (!Files.isRegularFile(p, LinkOption.NOFOLLOW_LINKS)) {
            return "";
        }
        if (!Files.isReadable(p)) {
            this.log.debug("Unreadable file " + String.valueOf(p) + " found");
            return "";
        }
        try {
            MessageDigest digester = MessageDigest.getInstance("SHA256");
            String hash = Hex.toHexString((byte[])digester.digest(Files.readAllBytes(p)));
            this.log.debug(hash + " :: " + String.valueOf(p));
            return hash;
        }
        catch (Exception e) {
            throw new OpenSearchSecurityException("Unable to digest file " + String.valueOf(p), e, new Object[0]);
        }
    }

    private boolean checkFilePermissions(Path p) {
        Set<PosixFilePermission> perms;
        if (p == null) {
            return false;
        }
        try {
            perms = Files.getPosixFilePermissions(p, LinkOption.NOFOLLOW_LINKS);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cannot determine posix file permissions for {} due to {}", (Object)p, (Object)e);
            }
            return false;
        }
        if (Files.isDirectory(p, LinkOption.NOFOLLOW_LINKS) ? perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE) : perms.contains((Object)PosixFilePermission.OWNER_EXECUTE) || perms.contains((Object)PosixFilePermission.GROUP_EXECUTE) || perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            return true;
        }
        return perms.contains((Object)PosixFilePermission.OTHERS_READ) || perms.contains((Object)PosixFilePermission.OTHERS_WRITE);
    }

    @Override
    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>(1);
        if (!this.client && !this.disabled) {
            handlers.addAll(super.getRestHandlers(settings, restController, clusterSettings, indexScopedSettings, settingsFilter, indexNameExpressionResolver, nodesInCluster));
            if (!this.SSLConfig.isSslOnlyMode()) {
                handlers.add((RestHandler)new SecurityInfoAction(settings, restController, Objects.requireNonNull(this.evaluator), Objects.requireNonNull(this.threadPool)));
                handlers.add((RestHandler)new SecurityHealthAction(settings, restController, Objects.requireNonNull(this.backendRegistry)));
                handlers.add((RestHandler)new DashboardsInfoAction(settings, restController, Objects.requireNonNull(this.evaluator), Objects.requireNonNull(this.threadPool)));
                handlers.add((RestHandler)new TenantInfoAction(settings, restController, Objects.requireNonNull(this.evaluator), Objects.requireNonNull(this.threadPool), Objects.requireNonNull(this.cs), Objects.requireNonNull(this.adminDns), Objects.requireNonNull(this.cr)));
                handlers.add((RestHandler)new SecurityConfigUpdateAction(settings, restController, Objects.requireNonNull(this.threadPool), this.adminDns, this.configPath, this.principalExtractor));
                handlers.add((RestHandler)new SecurityWhoAmIAction(settings, restController, Objects.requireNonNull(this.threadPool), this.adminDns, this.configPath, this.principalExtractor));
                handlers.add((RestHandler)new CreateOnBehalfOfTokenAction(this.tokenManager));
                handlers.addAll(SecurityRestApiActions.getHandler(settings, this.configPath, restController, this.localClient, this.adminDns, this.cr, this.cs, this.principalExtractor, this.evaluator, this.threadPool, Objects.requireNonNull(this.auditLog), this.sslSettingsManager, Objects.requireNonNull(this.userService), this.sslCertReloadEnabled, this.passwordHasher, this.rsIndexHandler));
                if (settings.getAsBoolean("plugins.security.experimental.resource_sharing.enabled", Boolean.valueOf(false)).booleanValue()) {
                    handlers.add((RestHandler)new ShareRestAction());
                }
            }
            this.log.debug("Added {} rest handler(s)", (Object)handlers.size());
        }
        return handlers;
    }

    public UnaryOperator<RestHandler> getRestHandlerWrapper(ThreadContext threadContext) {
        if (this.client || this.disabled || this.SSLConfig.isSslOnlyMode()) {
            return rh -> rh;
        }
        return rh -> this.securityRestHandler.wrap((RestHandler)rh, this.adminDns);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>(1);
        if (!this.disabled && !this.SSLConfig.isSslOnlyMode()) {
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)ConfigUpdateAction.INSTANCE, TransportConfigUpdateAction.class, new Class[0]));
            if (!ExternalSecurityKeyStore.hasExternalSslContext(this.settings)) {
                actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)CertificatesActionType.INSTANCE, TransportCertificatesInfoNodesAction.class, new Class[0]));
            }
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)WhoAmIAction.INSTANCE, TransportWhoAmIAction.class, new Class[0]));
            if (this.settings.getAsBoolean("plugins.security.experimental.resource_sharing.enabled", Boolean.valueOf(false)).booleanValue()) {
                actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)ShareAction.INSTANCE, ShareTransportAction.class, new Class[0]));
            }
        }
        return actions;
    }

    public void onIndexModule(final IndexModule indexModule) {
        if (!(this.disabled || this.client || this.SSLConfig.isSslOnlyMode())) {
            this.log.debug("Handle auditLog {} for onIndexModule() of index {}", this.auditLog.getClass(), (Object)indexModule.getIndex().getName());
            ComplianceIndexingOperationListenerImpl ciol = new ComplianceIndexingOperationListenerImpl(this.auditLog, this.threadPool);
            indexModule.addIndexOperationListener((IndexingOperationListener)ciol);
            indexModule.setReaderWrapper(indexService -> new SecurityFlsDlsIndexSearcherWrapper((IndexService)indexService, this.settings, this.adminDns, this.cs, this.auditLog, ciol, this.evaluator, this.dlsFlsValve::getCurrentConfig, this.dlsFlsBaseContext));
            if (this.settings.getAsBoolean("plugins.security.experimental.resource_sharing.enabled", Boolean.valueOf(false)).booleanValue()) {
                ResourceIndexListener resourceIndexListener = new ResourceIndexListener(this.threadPool, this.localClient);
                Set<String> resourceIndices = this.resourcePluginInfo.getResourceIndices();
                if (resourceIndices.contains(indexModule.getIndex().getName())) {
                    indexModule.addIndexOperationListener((IndexingOperationListener)resourceIndexListener);
                    this.log.info("Security plugin started listening to operations on resource-index {}", (Object)indexModule.getIndex().getName());
                }
            }
            indexModule.forceQueryCacheProvider((indexSettings, nodeCache) -> new QueryCache(){
                final /* synthetic */ IndexSettings val$indexSettings;
                final /* synthetic */ IndicesQueryCache val$nodeCache;
                {
                    this.val$indexSettings = indexSettings;
                    this.val$nodeCache = indicesQueryCache;
                }

                public Index index() {
                    return this.val$indexSettings.getIndex();
                }

                public void close() throws OpenSearchException {
                    this.clear("close");
                }

                public void clear(String reason) {
                    this.val$nodeCache.clearIndex(this.index().getName());
                }

                public Weight doCache(Weight weight, QueryCachingPolicy policy) {
                    try {
                        if (OpenSearchSecurityPlugin.this.dlsFlsValve.hasFlsOrFieldMasking(this.index().getName())) {
                            return weight;
                        }
                        return this.val$nodeCache.doCache(weight, policy);
                    }
                    catch (PrivilegesEvaluationException e) {
                        OpenSearchSecurityPlugin.this.log.error("Error while evaluating FLS configuration", (Throwable)e);
                        return weight;
                    }
                }
            });
            indexModule.addSearchOperationListener(new GuardedSearchOperationWrapper(){

                @Override
                public void onPreQueryPhase(SearchContext context) {
                    OpenSearchSecurityPlugin.this.dlsFlsValve.handleSearchContext(context, OpenSearchSecurityPlugin.this.threadPool, OpenSearchSecurityPlugin.this.namedXContentRegistry.get());
                }

                @Override
                public void onNewReaderContext(ReaderContext readerContext) {
                    boolean interClusterRequest = HeaderHelper.isInterClusterRequest(OpenSearchSecurityPlugin.this.threadPool.getThreadContext());
                    if (AuditLog.Origin.LOCAL.toString().equals(OpenSearchSecurityPlugin.this.threadPool.getThreadContext().getTransient("_opendistro_security_origin")) && (interClusterRequest || HeaderHelper.isDirectRequest(OpenSearchSecurityPlugin.this.threadPool.getThreadContext()))) {
                        readerContext.putInContext("_opendistro_security_scroll_auth_local", (Object)Boolean.TRUE);
                    } else {
                        readerContext.putInContext("_opendistro_security_scroll_auth", OpenSearchSecurityPlugin.this.threadPool.getThreadContext().getTransient("_opendistro_security_user"));
                    }
                }

                @Override
                public void onNewScrollContext(ReaderContext readerContext) {
                    boolean interClusterRequest = HeaderHelper.isInterClusterRequest(OpenSearchSecurityPlugin.this.threadPool.getThreadContext());
                    if (AuditLog.Origin.LOCAL.toString().equals(OpenSearchSecurityPlugin.this.threadPool.getThreadContext().getTransient("_opendistro_security_origin")) && (interClusterRequest || HeaderHelper.isDirectRequest(OpenSearchSecurityPlugin.this.threadPool.getThreadContext()))) {
                        readerContext.putInContext("_opendistro_security_scroll_auth_local", (Object)Boolean.TRUE);
                    } else {
                        readerContext.putInContext("_opendistro_security_scroll_auth", OpenSearchSecurityPlugin.this.threadPool.getThreadContext().getTransient("_opendistro_security_user"));
                    }
                }

                @Override
                public void validateReaderContext(ReaderContext readerContext, TransportRequest transportRequest) {
                    if (transportRequest instanceof InternalScrollSearchRequest) {
                        Object _isLocal = readerContext.getFromContext("_opendistro_security_scroll_auth_local");
                        Object _user = readerContext.getFromContext("_opendistro_security_scroll_auth");
                        if (_user != null && _user instanceof User) {
                            User scrollUser = (User)_user;
                            User currentUser = (User)OpenSearchSecurityPlugin.this.threadPool.getThreadContext().getTransient("_opendistro_security_user");
                            if (!scrollUser.equals(currentUser)) {
                                OpenSearchSecurityPlugin.this.auditLog.logMissingPrivileges("indices:data/read/scroll", transportRequest, null);
                                log.error("Wrong user {} in reader context, expected {}", (Object)scrollUser, (Object)currentUser);
                                throw new OpenSearchSecurityException("Wrong user in reader context", RestStatus.FORBIDDEN, new Object[0]);
                            }
                        } else if (_isLocal != Boolean.TRUE) {
                            OpenSearchSecurityPlugin.this.auditLog.logMissingPrivileges("indices:data/read/scroll", transportRequest, null);
                            throw new OpenSearchSecurityException("No user in reader context", RestStatus.FORBIDDEN, new Object[0]);
                        }
                    }
                }

                @Override
                public void onQueryPhase(SearchContext searchContext, long tookInNanos) {
                    QuerySearchResult queryResult = searchContext.queryResult();
                    assert (queryResult != null);
                    if (!queryResult.hasAggs()) {
                        return;
                    }
                    try {
                        if (OpenSearchSecurityPlugin.this.dlsFlsValve.hasFieldMasking(indexModule.getIndex().getName())) {
                            OpenSearchSecurityPlugin.this.dlsFlsValve.onQueryPhase(queryResult);
                        }
                    }
                    catch (PrivilegesEvaluationException e) {
                        log.error("Error while evaluating field masking config", (Throwable)e);
                        OpenSearchSecurityPlugin.this.dlsFlsValve.onQueryPhase(queryResult);
                    }
                }
            }.toListener());
            indexModule.addIndexEventListener((IndexEventListener)this.cr);
        }
    }

    public List<ActionFilter> getActionFilters() {
        ArrayList<ActionFilter> filters = new ArrayList<ActionFilter>(1);
        if (!(this.client || this.disabled || this.SSLConfig.isSslOnlyMode())) {
            filters.add(Objects.requireNonNull(this.sf));
        }
        return filters;
    }

    @Override
    public List<TransportInterceptor> getTransportInterceptors(NamedWriteableRegistry namedWriteableRegistry, ThreadContext threadContext) {
        ArrayList<TransportInterceptor> interceptors = new ArrayList<TransportInterceptor>(1);
        if (!(this.client || this.disabled || this.SSLConfig.isSslOnlyMode())) {
            interceptors.add(new TransportInterceptor(){

                public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(final String action, String executor, boolean forceExecution, final TransportRequestHandler<T> actualHandler) {
                    return new TransportRequestHandler<T>(){

                        public void messageReceived(T request, TransportChannel channel, Task task) throws Exception {
                            OpenSearchSecurityPlugin.this.si.getHandler(action, actualHandler).messageReceived(request, channel, task);
                        }
                    };
                }

                public TransportInterceptor.AsyncSender interceptSender(final TransportInterceptor.AsyncSender sender) {
                    return new TransportInterceptor.AsyncSender(){

                        public <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                            OpenSearchSecurityPlugin.this.si.sendRequestDecorate(sender, connection, action, request, options, handler, OpenSearchSecurityPlugin.this.localNode.get());
                        }
                    };
                }
            });
        }
        return interceptors;
    }

    @Override
    public Map<String, Supplier<Transport>> getSecureTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, SecureTransportSettingsProvider secureTransportSettingsProvider, Tracer tracer) {
        HashMap<String, Supplier<Transport>> transports = new HashMap<String, Supplier<Transport>>();
        if (this.SSLConfig.isSslOnlyMode()) {
            return super.getSecureTransports(settings, threadPool, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, networkService, secureTransportSettingsProvider, tracer);
        }
        if (this.transportSSLEnabled) {
            transports.put("org.opensearch.security.ssl.http.netty.SecuritySSLNettyTransport", () -> new SecureNetty4Transport(this.migrateSettings(settings), Version.CURRENT, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, this.sharedGroupFactory, secureTransportSettingsProvider, tracer));
        }
        return transports;
    }

    @Override
    public Map<String, Supplier<HttpServerTransport>> getSecureHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SecureHttpTransportSettingsProvider secureHttpTransportSettingsProvider, Tracer tracer) {
        if (this.SSLConfig.isSslOnlyMode()) {
            return super.getSecureHttpTransports(settings, threadPool, bigArrays, pageCacheRecycler, circuitBreakerService, xContentRegistry, networkService, dispatcher, clusterSettings, secureHttpTransportSettingsProvider, tracer);
        }
        if (!this.disabled) {
            if (!this.client && this.httpSSLEnabled) {
                ValidatingDispatcher validatingDispatcher = new ValidatingDispatcher(threadPool.getThreadContext(), dispatcher, settings, this.configPath, this.evaluateSslExceptionHandler());
                SecureNetty4HttpServerTransport odshst = new SecureNetty4HttpServerTransport(this.migrateSettings(settings), networkService, bigArrays, threadPool, xContentRegistry, (HttpServerTransport.Dispatcher)validatingDispatcher, clusterSettings, this.sharedGroupFactory, secureHttpTransportSettingsProvider, tracer);
                return Collections.singletonMap("org.opensearch.security.http.SecurityHttpServerTransport", () -> odshst);
            }
            if (!this.client) {
                return Collections.singletonMap("org.opensearch.security.http.SecurityHttpServerTransport", () -> new NonSslHttpServerTransport(this.migrateSettings(settings), networkService, bigArrays, threadPool, xContentRegistry, dispatcher, clusterSettings, this.sharedGroupFactory, secureHttpTransportSettingsProvider, tracer));
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public Collection<Object> createComponents(Client localClient, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        PrivilegesInterceptor privilegesInterceptor;
        this.SSLConfig.registerClusterSettingsChangeListener(clusterService.getClusterSettings());
        if (this.SSLConfig.isSslOnlyMode()) {
            return super.createComponents(localClient, clusterService, threadPool, resourceWatcherService, scriptService, xContentRegistry, environment, nodeEnvironment, namedWriteableRegistry, indexNameExpressionResolver, repositoriesServiceSupplier);
        }
        this.threadPool = threadPool;
        this.cs = clusterService;
        this.localClient = localClient;
        ArrayList<Object> components = new ArrayList<Object>();
        if (this.client || this.disabled) {
            return components;
        }
        this.transportPassiveAuthSetting.registerClusterSettingsChangeListener(clusterService.getClusterSettings());
        ClusterInfoHolder cih = new ClusterInfoHolder(this.cs.getClusterName().value());
        this.cs.addListener((ClusterStateListener)cih);
        IndexNameExpressionResolver resolver = new IndexNameExpressionResolver(threadPool.getThreadContext());
        this.irr = new IndexResolverReplacer(resolver, () -> ((ClusterService)clusterService).state(), cih);
        String DEFAULT_INTERCLUSTER_REQUEST_EVALUATOR_CLASS = DefaultInterClusterRequestEvaluator.class.getName();
        InterClusterRequestEvaluator interClusterRequestEvaluator = new DefaultInterClusterRequestEvaluator(this.settings);
        String className = this.settings.get("plugins.security.cert.intercluster_request_evaluator_class", DEFAULT_INTERCLUSTER_REQUEST_EVALUATOR_CLASS);
        this.log.debug("Using {} as intercluster request evaluator class", (Object)className);
        if (!DEFAULT_INTERCLUSTER_REQUEST_EVALUATOR_CLASS.equals(className)) {
            interClusterRequestEvaluator = ReflectionHelper.instantiateInterClusterRequestEvaluator(className, this.settings);
        }
        UserFactory.Caching userFactory = new UserFactory.Caching(this.settings);
        this.namedXContentRegistry.set(xContentRegistry);
        if (this.SSLConfig.isSslOnlyMode()) {
            this.auditLog = new NullAuditLog();
            privilegesInterceptor = new PrivilegesInterceptor(resolver, clusterService, localClient, threadPool);
        } else {
            this.auditLog = new AuditLogImpl(this.settings, this.configPath, localClient, threadPool, resolver, clusterService, environment, userFactory);
            privilegesInterceptor = new PrivilegesInterceptorImpl(resolver, clusterService, localClient, threadPool);
        }
        this.sslExceptionHandler = new AuditLogSslExceptionHandler(this.auditLog);
        this.adminDns = new AdminDNs(this.settings);
        this.cr = ConfigurationRepository.create(this.settings, this.configPath, threadPool, localClient, clusterService, this.auditLog);
        this.passwordHasher = PasswordHasherFactory.createPasswordHasher(this.settings);
        this.userService = new UserService(this.cs, this.cr, this.passwordHasher, this.settings, localClient);
        XFFResolver xffResolver = new XFFResolver(threadPool);
        this.backendRegistry = new BackendRegistry(this.settings, this.adminDns, xffResolver, this.auditLog, threadPool, cih);
        this.backendRegistry.registerClusterSettingsChangeListener(clusterService.getClusterSettings());
        this.tokenManager = new SecurityTokenManager(this.cs, threadPool, this.userService);
        CompatConfig compatConfig = new CompatConfig(environment, this.transportPassiveAuthSetting);
        this.rsIndexHandler = new ResourceSharingIndexHandler(localClient, threadPool);
        this.evaluator = new PrivilegesEvaluator(clusterService, () -> ((ClusterService)clusterService).state(), threadPool, threadPool.getThreadContext(), this.cr, resolver, this.auditLog, this.settings, privilegesInterceptor, cih, this.irr);
        this.dlsFlsBaseContext = new DlsFlsBaseContext(this.evaluator, threadPool.getThreadContext(), this.adminDns);
        if (this.SSLConfig.isSslOnlyMode()) {
            this.dlsFlsValve = new DlsFlsRequestValve.NoopDlsFlsRequestValve();
        } else {
            this.dlsFlsValve = new DlsFlsValveImpl(this.settings, localClient, clusterService, resolver, xContentRegistry, threadPool, this.dlsFlsBaseContext);
            this.cr.subscribeOnChange(configMap -> ((DlsFlsValveImpl)this.dlsFlsValve).updateConfiguration(this.cr.getConfiguration(CType.ROLES)));
        }
        ResourceAccessHandler resourceAccessHandler = new ResourceAccessHandler(threadPool, this.rsIndexHandler, this.adminDns, this.evaluator);
        if (this.settings.getAsBoolean("plugins.security.experimental.resource_sharing.enabled", Boolean.valueOf(false)).booleanValue()) {
            ResourceAccessControlClient resourceAccessControlClient = new ResourceAccessControlClient(resourceAccessHandler);
            this.resourcePluginInfo.getResourceSharingExtensions().forEach(extension -> extension.assignResourceSharingClient(resourceAccessControlClient));
            components.add(this.resourcePluginInfo);
            components.add(resourceAccessHandler);
        }
        this.sf = new SecurityFilter(this.settings, this.evaluator, this.adminDns, this.dlsFlsValve, this.auditLog, threadPool, this.cs, cih, compatConfig, this.irr, xffResolver, this.resourcePluginInfo.getResourceIndices(), resourceAccessHandler);
        String principalExtractorClass = this.settings.get("plugins.security.ssl.transport.principal_extractor_class", null);
        this.principalExtractor = principalExtractorClass == null ? new DefaultPrincipalExtractor() : ReflectionHelper.instantiatePrincipalExtractor(principalExtractorClass);
        this.restLayerEvaluator = new RestLayerPrivilegesEvaluator(this.evaluator);
        this.securityRestHandler = new SecurityRestFilter(this.backendRegistry, this.restLayerEvaluator, this.auditLog, threadPool, this.principalExtractor, this.settings, this.configPath, compatConfig);
        this.dcf = new DynamicConfigFactory(this.cr, this.settings, this.configPath, localClient, threadPool, cih, this.passwordHasher);
        this.dcf.registerDCFListener(this.backendRegistry);
        this.dcf.registerDCFListener(compatConfig);
        this.dcf.registerDCFListener(this.irr);
        this.dcf.registerDCFListener(xffResolver);
        this.dcf.registerDCFListener(this.evaluator);
        this.dcf.registerDCFListener(this.securityRestHandler);
        this.dcf.registerDCFListener(this.tokenManager);
        if (!(this.auditLog instanceof NullAuditLog)) {
            this.dcf.registerDCFListener(this.auditLog);
        }
        this.cr.setDynamicConfigFactory(this.dcf);
        this.si = new SecurityInterceptor(this.settings, threadPool, this.backendRegistry, this.auditLog, this.principalExtractor, interClusterRequestEvaluator, this.cs, Objects.requireNonNull(this.sslExceptionHandler), Objects.requireNonNull(cih), this.SSLConfig, OpenSearchSecurityPlugin::isActionTraceEnabled, userFactory);
        components.add(this.principalExtractor);
        if (DEFAULT_INTERCLUSTER_REQUEST_EVALUATOR_CLASS.equals(className)) {
            InterClusterRequestEvaluator e = interClusterRequestEvaluator;
            ((DefaultInterClusterRequestEvaluator)e).subscribeForChanges(this.dcf);
        }
        components.add(this.adminDns);
        components.add(this.cr);
        components.add(xffResolver);
        components.add(this.backendRegistry);
        components.add(this.evaluator);
        components.add(this.restLayerEvaluator);
        components.add(this.si);
        components.add(this.dcf);
        components.add(this.userService);
        components.add(this.passwordHasher);
        components.add(this.sslSettingsManager);
        if (OpenSearchSecurityPlugin.isSslCertReloadEnabled(this.settings) && this.sslCertificatesHotReloadEnabled(this.settings)) {
            throw new OpenSearchException("Either plugins.security.ssl_cert_reload_enabled or plugins.security.ssl.certificates_hot_reload.enabled can be set to true, but not both.", new Object[0]);
        }
        if (this.sslCertificatesHotReloadEnabled(this.settings) && !OpenSearchSecurityPlugin.isSslCertReloadEnabled(this.settings)) {
            this.sslSettingsManager.addSslConfigurationsChangeListener(resourceWatcherService);
        }
        Boolean allowDefaultInit = this.settings.getAsBoolean("plugins.security.allow_default_init_securityindex", Boolean.valueOf(false));
        boolean useClusterState = OpenSearchSecurityPlugin.useClusterStateToInitSecurityConfig(this.settings);
        if (!this.SSLConfig.isSslOnlyMode() && !OpenSearchSecurityPlugin.isDisabled(this.settings) && allowDefaultInit.booleanValue() && useClusterState) {
            clusterService.addListener((ClusterStateListener)this.cr);
        }
        return components;
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(ClusterState.Custom.class, "security", SecurityMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "security", SecurityMetadata::readDiffFrom));
    }

    @Override
    public Settings additionalSettings() {
        if (this.disabled) {
            return Settings.EMPTY;
        }
        Settings.Builder builder = Settings.builder();
        builder.put(super.additionalSettings());
        if (!this.SSLConfig.isSslOnlyMode()) {
            builder.put("transport.type", "org.opensearch.security.ssl.http.netty.SecuritySSLNettyTransport");
            builder.put("http.type", "org.opensearch.security.http.SecurityHttpServerTransport");
        }
        return builder.build();
    }

    @Override
    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.addAll(super.getSettings());
        settings.add(Setting.boolSetting((String)"plugins.security.ssl_only", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(SecuritySettings.SSL_DUAL_MODE_SETTING);
        settings.add(SecuritySettings.LEGACY_OPENDISTRO_SSL_DUAL_MODE_SETTING);
        settings.add(Setting.boolSetting((String)"plugins.security.protected_indices.enabled", (boolean)ConfigConstants.SECURITY_PROTECTED_INDICES_ENABLED_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Final}));
        settings.add(Setting.listSetting((String)"plugins.security.protected_indices.indices", ConfigConstants.SECURITY_PROTECTED_INDICES_DEFAULT, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Final}));
        settings.add(Setting.listSetting((String)"plugins.security.protected_indices.roles", ConfigConstants.SECURITY_PROTECTED_INDICES_ROLES_DEFAULT, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Final}));
        settings.add(Setting.boolSetting((String)"plugins.security.system_indices.enabled", (boolean)ConfigConstants.SECURITY_SYSTEM_INDICES_ENABLED_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Final}));
        settings.add(Setting.listSetting((String)"plugins.security.system_indices.indices", ConfigConstants.SECURITY_SYSTEM_INDICES_DEFAULT, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Final}));
        settings.add(Setting.simpleString((String)"plugins.security.password.hashing.algorithm", (String)"bcrypt", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final}));
        settings.add(Setting.intSetting((String)"plugins.security.password.hashing.bcrypt.rounds", (int)12, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final}));
        settings.add(Setting.simpleString((String)"plugins.security.password.hashing.bcrypt.minor", (String)"Y", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final}));
        settings.add(Setting.intSetting((String)"plugins.security.password.hashing.pbkdf2.iterations", (int)600000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final}));
        settings.add(Setting.intSetting((String)"plugins.security.password.hashing.pbkdf2.length", (int)256, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final}));
        settings.add(Setting.simpleString((String)"plugins.security.password.hashing.pbkdf2.function", (String)ConfigConstants.SECURITY_PASSWORD_HASHING_PBKDF2_FUNCTION_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final}));
        settings.add(Setting.intSetting((String)"plugins.security.password.hashing.argon2.iterations", (int)3, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final}));
        settings.add(Setting.intSetting((String)"plugins.security.password.hashing.argon2.memory", (int)65536, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final}));
        settings.add(Setting.intSetting((String)"plugins.security.password.hashing.argon2.parallelism", (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final}));
        settings.add(Setting.intSetting((String)"plugins.security.password.hashing.argon2.length", (int)32, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final}));
        settings.add(Setting.simpleString((String)"plugins.security.password.hashing.argon2.type", (String)"argon2id", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final}));
        settings.add(Setting.intSetting((String)"plugins.security.password.hashing.argon2.version", (int)19, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final}));
        if (!this.SSLConfig.isSslOnlyMode()) {
            settings.add(Setting.listSetting((String)"plugins.security.authcz.admin_dn", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"plugins.security.config_index_name", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.groupSetting((String)"plugins.security.authcz.impersonation_dn.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"plugins.security.cert.oid", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.cert.intercluster_request_evaluator_class", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"plugins.security.nodes_dn", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"plugins.security.nodes_dn_dynamic_config_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"plugins.security.enable_snapshot_restore_privilege", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.check_snapshot_restore_write_privileges", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.disabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(SecuritySettings.CACHE_TTL_SETTING);
            settings.add(Setting.boolSetting((String)"plugins.security.advanced_modules_enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.allow_unsafe_democertificates", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.allow_default_init_securityindex", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.allow_default_init_securityindex.use_cluster_state", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.background_init_if_securityindex_not_exist", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.dfm_empty_overrides_all", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.groupSetting((String)"plugins.security.authcz.rest_impersonation_user.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"plugins.security.roles_mapping_resolution", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.disable_envvar_replacement", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.groupSetting((String)"plugins.security.audit.routes.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.groupSetting((String)"plugins.security.audit.endpoints.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.intSetting((String)"plugins.security.audit.threadpool.size", (int)10, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.intSetting((String)"plugins.security.audit.threadpool.max_queue_len", (int)100000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"opendistro_security.audit.log_request_body", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"opendistro_security.audit.resolve_indices", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"opendistro_security.audit.enable_rest", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"opendistro_security.audit.enable_transport", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.masked_fields.algorithm.default", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            ArrayList<String> disabledCategories = new ArrayList<String>(2);
            disabledCategories.add("AUTHENTICATED");
            disabledCategories.add("GRANTED_PRIVILEGES");
            settings.add(Setting.listSetting((String)"opendistro_security.audit.config.disabled_transport_categories", disabledCategories, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"opendistro_security.audit.config.disabled_rest_categories", disabledCategories, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            ArrayList<String> ignoredUsers = new ArrayList<String>(2);
            ignoredUsers.add("kibanaserver");
            settings.add(Setting.listSetting((String)"opendistro_security.audit.ignore_users", ignoredUsers, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"opendistro_security.audit.ignore_requests", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"plugins.security.audit.ignore_headers", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"opendistro_security.audit.resolve_bulk_requests", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"opendistro_security.audit.exclude_sensitive_headers", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            BiFunction<String, Boolean, Setting> boolSettingNodeScopeFiltered = (keyWithNamespace, value) -> Setting.boolSetting((String)keyWithNamespace, (boolean)value, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
            Arrays.stream(AuditConfig.Filter.FilterEntries.values()).map(filterEntry -> {
                switch (filterEntry) {
                    case DISABLE_REST_CATEGORIES: 
                    case DISABLE_TRANSPORT_CATEGORIES: {
                        return Setting.listSetting((String)filterEntry.getKeyWithNamespace(), (List)disabledCategories, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
                    }
                    case IGNORE_REQUESTS: 
                    case IGNORE_HEADERS: {
                        return Setting.listSetting((String)filterEntry.getKeyWithNamespace(), Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
                    }
                    case IGNORE_USERS: {
                        return Setting.listSetting((String)filterEntry.getKeyWithNamespace(), (List)ignoredUsers, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
                    }
                    case ENABLE_REST: 
                    case ENABLE_TRANSPORT: 
                    case EXCLUDE_SENSITIVE_HEADERS: 
                    case LOG_REQUEST_BODY: 
                    case RESOLVE_INDICES: {
                        return (Setting)boolSettingNodeScopeFiltered.apply(filterEntry.getKeyWithNamespace(), true);
                    }
                    case RESOLVE_BULK_REQUESTS: {
                        return (Setting)boolSettingNodeScopeFiltered.apply(filterEntry.getKeyWithNamespace(), false);
                    }
                }
                throw new RuntimeException("Please add support for new FilterEntries value '" + filterEntry.name() + "'");
            }).forEach(settings::add);
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.index", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.data_stream.name", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.audit.config.data_stream.template.manage", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.data_stream.template.name", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.intSetting((String)"plugins.security.audit.config.data_stream.template.number_of_shards", (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.intSetting((String)"plugins.security.audit.config.data_stream.template.number_of_replicas", (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"plugins.security.audit.config.http_endpoints", (List)Lists.newArrayList((Object[])new String[]{"localhost:9200"}), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.username", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.audit.config.enable_ssl", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.audit.config.verify_hostnames", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.audit.config.enable_ssl_client_auth", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.pemcert_content", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.pemkey_content", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.pemkey_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.pemtrustedcas_content", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.cert_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"plugins.security.audit.config.enabled_ssl_ciphers", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"plugins.security.audit.config.enabled_ssl_protocols", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.webhook.url", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.webhook.format", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.audit.config.webhook.ssl.verify", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.webhook.ssl.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.webhook.ssl.pemtrustedcas_content", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.log4j.logger_name", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.audit.config.log4j.level", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.kerberos.krb5_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.kerberos.acceptor_keytab_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.kerberos.acceptor_principal", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"plugins.security.restapi.roles_enabled", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.groupSetting((String)"plugins.security.restapi.endpoints_disabled.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"plugins.security.restapi.admin.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.restapi.password_validation_regex", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.restapi.password_validation_error_message", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.intSetting((String)"plugins.security.restapi.password_min_length", (int)-1, (int)-1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.restapi.password_score_based_validation_strength", (String)PasswordValidator.ScoreStrength.STRONG.name(), PasswordValidator.ScoreStrength::fromConfiguration, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"opendistro_security.compliance.history.write.watched_indices", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"opendistro_security.compliance.history.read.watched_fields", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"opendistro_security.compliance.history.write.metadata_only", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"opendistro_security.compliance.history.read.metadata_only", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"opendistro_security.compliance.history.write.log_diffs", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"opendistro_security.compliance.history.external_config_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"opendistro_security.compliance.history.read.ignore_users", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"opendistro_security.compliance.history.write.ignore_users", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"plugins.security.compliance.disable_anonymous_authentication", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"plugins.security.compliance.immutable_indices", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"plugins.security.compliance.salt", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"opendistro_security.compliance.history.internal_config_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(this.transportPassiveAuthSetting.getDynamicSetting());
            settings.add(Setting.boolSetting((String)"plugins.security.filter_securityindex_from_all_requests", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.unsupported.disable_intertransport_auth_initially", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.unsupported.disable_rest_auth_initially", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.intSetting((String)"plugins.security.unsupported.delay_initialization_seconds", (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.unsupported.restore.securityindex.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.unsupported.inject_user.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.unsupported.inject_user.admin.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.unsupported.allow_now_in_dls", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.unsupported.restapi.allow_securityconfig_modification", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.unsupported.load_static_resources", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.ssl_cert_reload_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.ssl.certificates_hot_reload.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.unsupported.accept_invalid_config", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"plugins.security.system_indices.permission.enabled", (boolean)ConfigConstants.SECURITY_SYSTEM_INDICES_PERMISSIONS_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(RoleBasedActionPrivileges.PRECOMPUTED_PRIVILEGES_MAX_HEAP_SIZE);
            settings.add(RoleBasedActionPrivileges.PRECOMPUTED_PRIVILEGES_ENABLED);
            settings.add(Setting.boolSetting((String)"plugins.security.experimental.resource_sharing.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(UserFactory.Caching.MAX_SIZE);
            settings.add(UserFactory.Caching.EXPIRE_AFTER_ACCESS);
            settings.add(Setting.boolSetting((String)"plugins.security.configurations_versions.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"plugins.security.config_versions_index_name", (String)".opensearch_security_config_versions", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.intSetting((String)"plugins.security.config_version.retention_count", (int)10, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final}));
            settings.add(Setting.boolSetting((String)"plugins.security.user_attribute_serialization.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        }
        return settings;
    }

    @Override
    public List<String> getSettingsFilter() {
        ArrayList<String> settingsFilter = new ArrayList<String>();
        if (this.disabled) {
            return settingsFilter;
        }
        settingsFilter.add("opendistro_security.*");
        settingsFilter.add("plugins.security.*");
        return settingsFilter;
    }

    public void onNodeStarted(DiscoveryNode localNode) {
        this.localNode.set(localNode);
        if (!(this.SSLConfig.isSslOnlyMode() || this.client || this.disabled || OpenSearchSecurityPlugin.useClusterStateToInitSecurityConfig(this.settings))) {
            this.cr.initOnNodeStart();
        }
        if (this.settings != null && this.settings.getAsBoolean("plugins.security.experimental.resource_sharing.enabled", Boolean.valueOf(false)).booleanValue()) {
            this.log.debug("Attempting to create Resource Sharing index");
            Set<String> resourceIndices = new HashSet<String>();
            if (this.resourcePluginInfo != null) {
                resourceIndices = this.resourcePluginInfo.getResourceIndices();
            }
            this.rsIndexHandler.createResourceSharingIndicesIfAbsent(resourceIndices);
        }
        Set<ModuleInfo> securityModules = ReflectionHelper.getModulesLoaded();
        this.log.info("{} OpenSearch Security modules loaded so far: {}", (Object)securityModules.size(), securityModules);
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        if (this.client || this.disabled || this.SSLConfig.isSslOnlyMode()) {
            return Collections.emptyList();
        }
        ArrayList<Class<? extends LifecycleComponent>> services = new ArrayList<Class<? extends LifecycleComponent>>(1);
        services.add(GuiceHolder.class);
        return services;
    }

    public Function<String, Predicate<String>> getFieldFilter() {
        return index -> {
            if (this.threadPool == null || this.dlsFlsValve == null) {
                return field -> true;
            }
            return field -> {
                try {
                    return this.dlsFlsValve.isFieldAllowed((String)index, (String)field);
                }
                catch (PrivilegesEvaluationException e) {
                    this.log.error("Error while evaluating FLS for {}.{}", index, field, (Object)e);
                    return false;
                }
            };
        };
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        ArrayList<SystemIndexDescriptor> systemIndexDescriptors = new ArrayList<SystemIndexDescriptor>();
        String indexPattern = settings.get("plugins.security.config_index_name", ".opendistro_security");
        SystemIndexDescriptor securityIndexDescriptor = new SystemIndexDescriptor(indexPattern, "Security index");
        systemIndexDescriptors.add(securityIndexDescriptor);
        if (settings != null && settings.getAsBoolean("plugins.security.experimental.resource_sharing.enabled", Boolean.valueOf(false)).booleanValue()) {
            for (String resourceIndex : this.resourcePluginInfo.getResourceIndices()) {
                SystemIndexDescriptor resourceSharingIndexDescriptor = new SystemIndexDescriptor(ResourceSharingIndexHandler.getSharingIndex(resourceIndex), "Resource Sharing index for index: " + resourceIndex);
                systemIndexDescriptors.add(resourceSharingIndexDescriptor);
            }
        }
        return ImmutableList.copyOf(systemIndexDescriptors);
    }

    public Subject getCurrentSubject() {
        return (Subject)this.threadPool.getThreadContext().getPersistent("_opendistro_security_authenticated_user");
    }

    public SecurityTokenManager getTokenManager() {
        return this.tokenManager;
    }

    public PluginSubject getPluginSubject(Plugin plugin) {
        SecurePluginSubject subject = new SecurePluginSubject(this.threadPool, this.settings, plugin);
        if (!(this.client || this.disabled || this.SSLConfig.isSslOnlyMode())) {
            RoleV7 pluginPermissions;
            String pluginPrincipal = subject.getPrincipal().getName();
            URL resource = plugin.getClass().getClassLoader().getResource("plugin-additional-permissions.yml");
            if (resource == null) {
                this.log.info("plugin-additional-permissions.yml not found on classpath for plugin {}, using empty permissions", (Object)pluginPrincipal);
                pluginPermissions = new RoleV7();
                pluginPermissions.setCluster_permissions(new ArrayList<String>());
            } else {
                try {
                    pluginPermissions = RoleV7.fromPluginPermissionsFile(resource);
                }
                catch (IOException e) {
                    throw new OpenSearchSecurityException(e.getMessage(), (Exception)e, new Object[0]);
                }
            }
            pluginPermissions.getCluster_permissions().add("indices:data/write/bulk");
            this.evaluator.updatePluginToActionPrivileges(pluginPrincipal, pluginPermissions);
        }
        return subject;
    }

    @Override
    public Optional<SecureSettingsFactory> getSecureSettingFactory(Settings settings) {
        return Optional.of(new OpenSearchSecureSettingsFactory(this.threadPool, this.sslSettingsManager, this.evaluateSslExceptionHandler(), this.securityRestHandler, this.SSLConfig));
    }

    private void tryAddSecurityProvider() {
        AccessController.doPrivileged(() -> {
            if (Security.getProvider("BCFIPS") == null) {
                Security.addProvider((Provider)new BouncyCastleFipsProvider());
                this.log.debug("Bouncy Castle FIPS Provider added");
            }
            return null;
        });
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        if (this.settings != null && this.settings.getAsBoolean("plugins.security.experimental.resource_sharing.enabled", Boolean.valueOf(false)).booleanValue()) {
            this.resourceSharingExtensions.addAll(new HashSet(loader.loadExtensions(ResourceSharingExtension.class)));
            this.resourcePluginInfo.setResourceSharingExtensions(this.resourceSharingExtensions);
        }
    }

    public static class GuiceHolder
    implements LifecycleComponent {
        private static RepositoriesService repositoriesService;
        private static RemoteClusterService remoteClusterService;
        private static IndicesService indicesService;
        private static PitService pitService;
        private static ExtensionsManager extensionsManager;

        @Inject
        public GuiceHolder(RepositoriesService repositoriesService, TransportService remoteClusterService, IndicesService indicesService, PitService pitService, ExtensionsManager extensionsManager) {
            GuiceHolder.repositoriesService = repositoriesService;
            GuiceHolder.remoteClusterService = remoteClusterService.getRemoteClusterService();
            GuiceHolder.indicesService = indicesService;
            GuiceHolder.pitService = pitService;
            GuiceHolder.extensionsManager = extensionsManager;
        }

        public static RepositoriesService getRepositoriesService() {
            return repositoriesService;
        }

        public static RemoteClusterService getRemoteClusterService() {
            return remoteClusterService;
        }

        public static IndicesService getIndicesService() {
            return indicesService;
        }

        public static PitService getPitService() {
            return pitService;
        }

        public static ExtensionsManager getExtensionsManager() {
            return extensionsManager;
        }

        public void close() {
        }

        public Lifecycle.State lifecycleState() {
            return null;
        }

        public void addLifecycleListener(LifecycleListener listener) {
        }

        public void removeLifecycleListener(LifecycleListener listener) {
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

