/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.licensing;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.sourceforge.plantuml.licensing.BitInput;
import net.sourceforge.plantuml.licensing.BooleanOutputStream;

public class ASCII7Format {
    public static byte[] encodeString(String text) throws IOException {
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (BooleanOutputStream bos = new BooleanOutputStream(baos);){
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c <= '\u0000' || c > '\u007f') {
                    throw new IllegalArgumentException();
                }
                for (int b = 0; b < 7; ++b) {
                    boolean bit = (c >> b & 1) == 1;
                    bos.writeBoolean(bit);
                }
            }
        }
        return baos.toByteArray();
    }

    public static String decodeString(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException();
        }
        BitInput in = new BitInput(data);
        StringBuilder sb = new StringBuilder();
        while (in.availableBits() >= 7) {
            int value = 0;
            for (int b = 0; b < 7; ++b) {
                if (!in.readBit()) continue;
                value |= 1 << b;
            }
            if (value == 0) break;
            if (value < 0 || value > 127) {
                throw new IOException("Bad value: " + value);
            }
            sb.append((char)value);
        }
        return sb.toString();
    }
}

