/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class ChangesBrowserBase
extends JPanel
implements UiCompatibleDataProvider {
    public static final DataKey<ChangesBrowserBase> DATA_KEY = DataKey.create((String)"com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase");
    @NotNull
    protected final Project myProject;
    protected final ChangesTree myViewer;
    private final DefaultActionGroup myToolBarGroup;
    private final DefaultActionGroup myPopupMenuGroup;
    private final ActionToolbar myToolbar;
    private final int myToolbarAnchor;
    private final JScrollPane myViewerScrollPane;
    private final AnAction myShowDiffAction;
    @Nullable
    private Runnable myInclusionChangedListener;
    @Nullable
    private DiffPreview myDiffPreview;

    protected ChangesBrowserBase(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        if (project == null) {
            ChangesBrowserBase.$$$reportNull$$$0(0);
        }
        this.myToolBarGroup = new DefaultActionGroup();
        this.myPopupMenuGroup = new DefaultActionGroup();
        this.myProject = project;
        this.myViewer = this.createTreeList(project, showCheckboxes, highlightProblems);
        this.myToolbar = ActionManager.getInstance().createActionToolbar("ChangesBrowser", (ActionGroup)this.myToolBarGroup, true);
        this.myToolbar.setTargetComponent((JComponent)this.myViewer);
        this.myToolbarAnchor = this.getToolbarAnchor();
        this.myToolbar.setOrientation(this.isVerticalToolbar() ? 1 : 0);
        this.myViewer.installPopupHandler((ActionGroup)this.myPopupMenuGroup);
        this.myViewerScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myViewer, (boolean)true);
        this.setViewerBorder(this.createViewerBorder());
        this.myShowDiffAction = new MyShowDiffAction();
    }

    @NotNull
    protected ChangesTree createTreeList(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        if (project == null) {
            ChangesBrowserBase.$$$reportNull$$$0(1);
        }
        return new ChangesBrowserTreeList(this, project, showCheckboxes, highlightProblems);
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.setFocusable(false);
        JPanel topPanel = new JPanel(new BorderLayout());
        JComponent toolbarComponent = this.isVerticalToolbar() ? this.createToolbarComponent() : new TreeActionsToolbarPanel(this.createToolbarComponent(), this.myViewer);
        JComponent headerPanel = this.createHeaderPanel();
        if (headerPanel != null) {
            topPanel.add((Component)headerPanel, "East");
        }
        switch (this.myToolbarAnchor) {
            case 1: {
                topPanel.add((Component)toolbarComponent, "Center");
                break;
            }
            case 3: {
                this.add((Component)toolbarComponent, "South");
                break;
            }
            case 2: {
                this.add((Component)toolbarComponent, "West");
                break;
            }
            case 4: {
                this.add((Component)toolbarComponent, "East");
            }
        }
        this.add((Component)topPanel, "North");
        this.add((Component)this.createCenterPanel(), "Center");
        this.myToolBarGroup.addAll(this.createToolbarActions());
        this.myToolBarGroup.addAll(this.createLastToolbarActions());
        this.myPopupMenuGroup.addAll(this.createPopupMenuActions());
        this.myShowDiffAction.registerCustomShortcutSet((JComponent)this, null);
        DiffUtil.recursiveRegisterShortcutSet((ActionGroup)this.myToolBarGroup, (JComponent)this, null);
    }

    @NotNull
    protected Border createViewerBorder() {
        Border border = IdeBorderFactory.createBorder((int)15);
        if (border == null) {
            ChangesBrowserBase.$$$reportNull$$$0(2);
        }
        return border;
    }

    public void setViewerBorder(@NotNull Border border) {
        if (border == null) {
            ChangesBrowserBase.$$$reportNull$$$0(3);
        }
        this.myViewerScrollPane.setBorder(border);
    }

    public void hideViewerBorder() {
        int borders = switch (this.myToolbarAnchor) {
            case 1 -> 2;
            case 3 -> 8;
            case 2 -> 1;
            case 4 -> 4;
            default -> 0;
        };
        this.setViewerBorder(IdeBorderFactory.createBorder((int)borders));
    }

    protected int getToolbarAnchor() {
        return 1;
    }

    private boolean isVerticalToolbar() {
        return this.myToolbarAnchor == 2 || this.myToolbarAnchor == 4;
    }

    @NotNull
    protected JComponent createToolbarComponent() {
        JComponent jComponent = this.myToolbar.getComponent();
        if (jComponent == null) {
            ChangesBrowserBase.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @NotNull
    protected abstract DefaultTreeModel buildTreeModel();

    @Nullable
    protected ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject) {
        if (userObject == null) {
            ChangesBrowserBase.$$$reportNull$$$0(5);
        }
        if (userObject instanceof Change) {
            return ChangeDiffRequestProducer.create(this.myProject, (Change)userObject);
        }
        return null;
    }

    @Nullable
    protected JComponent createHeaderPanel() {
        return null;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JScrollPane jScrollPane = this.myViewerScrollPane;
        if (jScrollPane == null) {
            ChangesBrowserBase.$$$reportNull$$$0(6);
        }
        return jScrollPane;
    }

    @NotNull
    protected @Unmodifiable List<AnAction> createToolbarActions() {
        List<AnAction> list = Collections.singletonList(this.myShowDiffAction);
        if (list == null) {
            ChangesBrowserBase.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    protected List<AnAction> createLastToolbarActions() {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add((AnAction)Separator.getInstance());
        result2.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
        if (this.isVerticalToolbar()) {
            result2.add((AnAction)Separator.getInstance());
            result2.addAll(TreeActionsToolbarPanel.createTreeActions());
        }
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            ChangesBrowserBase.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    protected @Unmodifiable List<AnAction> createPopupMenuActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add(this.myShowDiffAction);
        ContainerUtil.addIfNotNull(actions, (Object)ActionManager.getInstance().getAction("Diff.ShowStandaloneDiff"));
        ArrayList<AnAction> arrayList = actions;
        if (arrayList == null) {
            ChangesBrowserBase.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    protected List<AnAction> createDiffActions() {
        List<AnAction> list = Collections.emptyList();
        if (list == null) {
            ChangesBrowserBase.$$$reportNull$$$0(10);
        }
        return list;
    }

    protected void onDoubleClick() {
        if (this.canShowDiff()) {
            this.showDiff();
        }
    }

    protected void onIncludedChanged() {
        if (this.myInclusionChangedListener != null) {
            this.myInclusionChangedListener.run();
        }
    }

    public void selectEntries(@NotNull Collection<?> changes) {
        if (changes == null) {
            ChangesBrowserBase.$$$reportNull$$$0(11);
        }
        this.myViewer.setSelectedChanges(changes);
    }

    public void setInclusionChangedListener(@Nullable Runnable value) {
        this.myInclusionChangedListener = value;
    }

    public void addToolbarAction(@NotNull AnAction action) {
        if (action == null) {
            ChangesBrowserBase.$$$reportNull$$$0(12);
        }
        this.myToolBarGroup.add(action);
        action.registerCustomShortcutSet((JComponent)this, null);
    }

    public void addToolbarSeparator() {
        this.myToolBarGroup.addSeparator();
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myViewer.getPreferredFocusedComponent();
        if (jComponent == null) {
            ChangesBrowserBase.$$$reportNull$$$0(13);
        }
        return jComponent;
    }

    @NotNull
    public ActionToolbar getToolbar() {
        ActionToolbar actionToolbar = this.myToolbar;
        if (actionToolbar == null) {
            ChangesBrowserBase.$$$reportNull$$$0(14);
        }
        return actionToolbar;
    }

    @NotNull
    public JScrollPane getViewerScrollPane() {
        JScrollPane jScrollPane = this.myViewerScrollPane;
        if (jScrollPane == null) {
            ChangesBrowserBase.$$$reportNull$$$0(15);
        }
        return jScrollPane;
    }

    @NotNull
    public ChangesTree getViewer() {
        ChangesTree changesTree = this.myViewer;
        if (changesTree == null) {
            ChangesBrowserBase.$$$reportNull$$$0(16);
        }
        return changesTree;
    }

    @NotNull
    public ChangesGroupingPolicyFactory getGrouping() {
        ChangesGroupingPolicyFactory changesGroupingPolicyFactory = this.myViewer.getGrouping();
        if (changesGroupingPolicyFactory == null) {
            ChangesBrowserBase.$$$reportNull$$$0(17);
        }
        return changesGroupingPolicyFactory;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            ChangesBrowserBase.$$$reportNull$$$0(18);
        }
        sink.set(DATA_KEY, (Object)this);
        DataSink.uiDataSnapshot((DataSink)sink, (DataProvider)this.myViewer);
        VcsTreeModelData.uiDataSnapshot((DataSink)sink, (Project)this.myProject, (JTree)this.myViewer);
    }

    @NotNull
    public AnAction getDiffAction() {
        AnAction anAction = this.myShowDiffAction;
        if (anAction == null) {
            ChangesBrowserBase.$$$reportNull$$$0(19);
        }
        return anAction;
    }

    public boolean canShowDiff() {
        ListSelection selection = VcsTreeModelData.getListSelectionOrAll((JTree)this.myViewer);
        return ContainerUtil.exists((Iterable)selection.getList(), entry -> this.getDiffRequestProducer(entry) != null);
    }

    @Nullable
    protected DiffPreview getShowDiffActionPreview() {
        return this.myDiffPreview;
    }

    public void setShowDiffActionPreview(@Nullable DiffPreview diffPreview) {
        this.myDiffPreview = diffPreview;
    }

    public void showDiff() {
        DiffPreview diffPreview = this.getShowDiffActionPreview();
        if (diffPreview != null) {
            diffPreview.performDiffAction();
        } else {
            ChangesBrowserBase.showStandaloneDiff(this.myProject, this);
        }
    }

    public static void showStandaloneDiff(@NotNull Project project, @NotNull ChangesBrowserBase changesBrowser) {
        if (project == null) {
            ChangesBrowserBase.$$$reportNull$$$0(20);
        }
        if (changesBrowser == null) {
            ChangesBrowserBase.$$$reportNull$$$0(21);
        }
        ChangesBrowserBase.showStandaloneDiff(project, changesBrowser, VcsTreeModelData.getListSelectionOrAll((JTree)changesBrowser.myViewer), changesBrowser::getDiffRequestProducer);
    }

    public static <T> void showStandaloneDiff(@NotNull Project project, @NotNull ChangesBrowserBase changesBrowser, @NotNull ListSelection<T> selection, @NotNull NullableFunction<? super T, ? extends ChangeDiffRequestChain.Producer> getDiffRequestProducer) {
        if (project == null) {
            ChangesBrowserBase.$$$reportNull$$$0(22);
        }
        if (changesBrowser == null) {
            ChangesBrowserBase.$$$reportNull$$$0(23);
        }
        if (selection == null) {
            ChangesBrowserBase.$$$reportNull$$$0(24);
        }
        if (getDiffRequestProducer == null) {
            ChangesBrowserBase.$$$reportNull$$$0(25);
        }
        ListSelection producers = selection.map(getDiffRequestProducer);
        ChangeDiffRequestChain chain = new ChangeDiffRequestChain((ListSelection<? extends ChangeDiffRequestChain.Producer>)producers);
        changesBrowser.updateDiffContext((DiffRequestChain)chain);
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)chain, new DiffDialogHints(null, (Component)changesBrowser));
    }

    public static void selectObjectWithTag(@NotNull ChangesTree tree, @NotNull Object userObject, @Nullable ChangesBrowserNode.Tag tag) {
        TreePath path;
        if (tree == null) {
            ChangesBrowserBase.$$$reportNull$$$0(26);
        }
        if (userObject == null) {
            ChangesBrowserBase.$$$reportNull$$$0(27);
        }
        if ((path = ChangesBrowserBase.findPathToObjectWithTag(tree, userObject, tag)) == null) {
            return;
        }
        TreeUtil.selectPath((JTree)tree, (TreePath)path, (boolean)false);
    }

    @Nullable
    public static TreePath findPathToObjectWithTag(@NotNull ChangesTree tree, @NotNull Object userObject, @Nullable ChangesBrowserNode.Tag tag) {
        DefaultMutableTreeNode node;
        DefaultMutableTreeNode tagNode;
        if (tree == null) {
            ChangesBrowserBase.$$$reportNull$$$0(28);
        }
        if (userObject == null) {
            ChangesBrowserBase.$$$reportNull$$$0(29);
        }
        Object root = tree.getRoot();
        if (tag != null && (tagNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)tag)) != null) {
            root = tagNode;
        }
        if ((node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)userObject)) == null) {
            return null;
        }
        return TreeUtil.getPathFromRoot((TreeNode)node);
    }

    protected void updateDiffContext(@NotNull DiffRequestChain chain) {
        if (chain == null) {
            ChangesBrowserBase.$$$reportNull$$$0(30);
        }
        chain.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, this.createDiffActions());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 7, 8, 9, 10, 13, 14, 15, 16, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "border";
                break;
            }
            case 5: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesBrowser";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getDiffRequestProducer";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewerBorder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLastToolbarActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupMenuActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffActions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewerScrollPane";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewer";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrouping";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTreeList";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setViewerBorder";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequestProducer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "selectEntries";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addToolbarAction";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "showStandaloneDiff";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "selectObjectWithTag";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findPathToObjectWithTag";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateDiffContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 7, 8, 9, 10, 13, 14, 15, 16, 17, 19 -> new IllegalStateException(string);
        };
    }

    private class MyShowDiffAction
    extends DumbAwareAction {
        MyShowDiffAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowDiff");
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyShowDiffAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowDiffAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(ChangesBrowserBase.this.canShowDiff() || e.getInputEvent() instanceof KeyEvent);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowDiffAction.$$$reportNull$$$0(2);
            }
            if (ChangesBrowserBase.this.canShowDiff()) {
                ChangesBrowserBase.this.showDiff();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase$MyShowDiffAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase$MyShowDiffAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ChangesBrowserTreeList
    extends ChangesTree {
        @NotNull
        private final ChangesBrowserBase myBrowser;

        ChangesBrowserTreeList(@NotNull ChangesBrowserBase browser, @NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
            if (browser == null) {
                ChangesBrowserTreeList.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ChangesBrowserTreeList.$$$reportNull$$$0(1);
            }
            super(project, showCheckboxes, highlightProblems);
            this.myBrowser = browser;
            this.setDoubleClickAndEnterKeyHandler(this.myBrowser::onDoubleClick);
            this.setInclusionListener(this.myBrowser::onIncludedChanged);
        }

        public final void rebuildTree() {
            DefaultTreeModel newModel = this.myBrowser.buildTreeModel();
            this.updateTreeModel(newModel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "browser";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase$ChangesBrowserTreeList";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ShowStandaloneDiff
    implements AnActionExtensionProvider {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ShowStandaloneDiff.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isActive(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowStandaloneDiff.$$$reportNull$$$0(1);
            }
            Project project = e.getProject();
            ChangesBrowserBase changesBrowser = (ChangesBrowserBase)e.getData(DATA_KEY);
            return project != null && changesBrowser != null && changesBrowser.canShowDiff();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowStandaloneDiff.$$$reportNull$$$0(2);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ShowStandaloneDiff.$$$reportNull$$$0(3);
            }
            if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
                return;
            }
            ChangesBrowserBase changesBrowser = (ChangesBrowserBase)e.getData(DATA_KEY);
            if (changesBrowser == null) {
                return;
            }
            ChangesBrowserBase.showStandaloneDiff(project, changesBrowser);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase$ShowStandaloneDiff";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase$ShowStandaloneDiff";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isActive";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

