/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.util.CoroutinesKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import git4idea.actions.GitToggleAnnotationOptionsActionProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\n\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\f"}, d2={"Lgit4idea/annotate/GitAnnotationsListener;", "", "<init>", "()V", "registerListener", "", "project", "Lcom/intellij/openapi/project/Project;", "activeScope", "Lkotlinx/coroutines/CoroutineScope;", "RepoListener", "LogSettingsListener", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitAnnotationsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitAnnotationsListener.kt\ngit4idea/annotate/GitAnnotationsListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,46:1\n30#2,2:47\n*S KotlinDebug\n*F\n+ 1 GitAnnotationsListener.kt\ngit4idea/annotate/GitAnnotationsListener\n*L\n26#1:47,2\n*E\n"})
public final class GitAnnotationsListener {
    @NotNull
    public static final GitAnnotationsListener INSTANCE = new GitAnnotationsListener();

    private GitAnnotationsListener() {
    }

    @JvmStatic
    public static final void registerListener(@NotNull Project project, @NotNull CoroutineScope activeScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)activeScope, (String)"activeScope");
        SimpleMessageBusConnection busConnection = project.getMessageBus().connect(activeScope);
        Topic<GitRepositoryChangeListener> topic = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"GIT_REPO_CHANGE");
        busConnection.subscribe(topic, (Object)new RepoListener(project));
        LogSettingsListener logSettingsListener = new LogSettingsListener(project);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$service$iv = (ComponentManager)application;
        boolean $i$f$service = false;
        Class<VcsLogApplicationSettings> serviceClass$iv = VcsLogApplicationSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        VcsLogApplicationSettings logSettings = (VcsLogApplicationSettings)object;
        logSettings.addChangeListener((VcsLogUiProperties.PropertiesChangeListener)logSettingsListener);
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)activeScope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(logSettings, logSettingsListener, null){
            int label;
            final /* synthetic */ VcsLogApplicationSettings $logSettings;
            final /* synthetic */ LogSettingsListener $logSettingsListener;
            {
                this.$logSettings = $logSettings;
                this.$logSettingsListener = $logSettingsListener;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$logSettings.removeChangeListener((VcsLogUiProperties.PropertiesChangeListener)this.$logSettingsListener);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lgit4idea/annotate/GitAnnotationsListener$LogSettingsListener;", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$PropertiesChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "onPropertyChanged", "", "T", "property", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;", "intellij.vcs.git"})
    private static final class LogSettingsListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        @NotNull
        private final Project project;

        public LogSettingsListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            if (property.equals((Object)CommonUiProperties.PREFER_COMMIT_DATE)) {
                GitToggleAnnotationOptionsActionProvider.resetAllAnnotations(this.project, false);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lgit4idea/annotate/GitAnnotationsListener$RepoListener;", "Lgit4idea/repo/GitRepositoryChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "repositoryChanged", "", "repository", "Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
    private static final class RepoListener
    implements GitRepositoryChangeListener {
        @NotNull
        private final Project project;

        public RepoListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Override
        public void repositoryChanged(@NotNull GitRepository repository2) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Object object = BackgroundTaskUtil.syncPublisher((Project)this.project, (Topic)VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"syncPublisher(...)");
            VcsAnnotationRefresher refresher = (VcsAnnotationRefresher)object;
            refresher.dirtyUnder(repository2.getRoot());
        }
    }
}

