/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.ui.VcsBookmarkRef;
import com.intellij.vcs.log.ui.VcsLogBookmark;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/log/ui/VcsLogBookmarkReferenceProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getBookmarkRefs", "", "Lcom/intellij/vcs/log/ui/VcsBookmarkRef;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogBookmarkProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogBookmarkProvider.kt\ncom/intellij/vcs/log/ui/VcsLogBookmarkReferenceProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n808#2,11:191\n774#2:202\n865#2,2:203\n1563#2:205\n1634#2,3:206\n*S KotlinDebug\n*F\n+ 1 VcsLogBookmarkProvider.kt\ncom/intellij/vcs/log/ui/VcsLogBookmarkReferenceProvider\n*L\n138#1:191,11\n139#1:202\n139#1:203,2\n140#1:205\n140#1:206,3\n*E\n"})
public final class VcsLogBookmarkReferenceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public VcsLogBookmarkReferenceProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VcsBookmarkRef> getBookmarkRefs(@NotNull Hash hash, @NotNull VirtualFile root) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        VcsLogBookmark it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)this.project);
        if (bookmarksManager == null) {
            return CollectionsKt.emptyList();
        }
        BookmarksManager bookmarksManager2 = bookmarksManager;
        List list = bookmarksManager2.getBookmarks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBookmarks(...)");
        Iterable iterable = list;
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof VcsLogBookmark)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VcsLogBookmark)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getHash(), (Object)hash) && Intrinsics.areEqual((Object)it.getRoot(), (Object)root))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void logBookmark;
            it = (VcsLogBookmark)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BookmarkType bookmarkType = bookmarksManager2.getType((Bookmark)logBookmark);
            if (bookmarkType == null) {
                bookmarkType = BookmarkType.DEFAULT;
            }
            BookmarkType type = bookmarkType;
            if (type != BookmarkType.DEFAULT) {
                Object[] objectArray = new Object[]{Character.valueOf(type.getMnemonic())};
                string = VcsLogBundle.message("vcs.log.bookmark.label.mnemonic", objectArray);
            } else {
                string = VcsLogBundle.message("vcs.log.bookmark.label", new Object[0]);
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            String text = string2;
            collection.add(new VcsBookmarkRef((Bookmark)logBookmark, type, text));
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final List<VcsBookmarkRef> getBookmarkRefs(@NotNull Project project, @NotNull Hash hash, @NotNull VirtualFile root) {
        return Companion.getBookmarkRefs(project, hash, root);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/vcs/log/ui/VcsLogBookmarkReferenceProvider$Companion;", "", "<init>", "()V", "getBookmarkRefs", "", "Lcom/intellij/vcs/log/ui/VcsBookmarkRef;", "project", "Lcom/intellij/openapi/project/Project;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsLogBookmarkProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogBookmarkProvider.kt\ncom/intellij/vcs/log/ui/VcsLogBookmarkReferenceProvider$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,190:1\n30#2,2:191\n*S KotlinDebug\n*F\n+ 1 VcsLogBookmarkProvider.kt\ncom/intellij/vcs/log/ui/VcsLogBookmarkReferenceProvider$Companion\n*L\n131#1:191,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<VcsBookmarkRef> getBookmarkRefs(@NotNull Project project, @NotNull Hash hash, @NotNull VirtualFile root) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<VcsLogBookmarkReferenceProvider> serviceClass$iv = VcsLogBookmarkReferenceProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return ((VcsLogBookmarkReferenceProvider)object).getBookmarkRefs(hash, root);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

