/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.JsonBundle;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.MatchResult;
import com.jetbrains.jsonSchema.impl.inspections.JsonSchemaBasedInspectionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonSchemaDeprecationInspection
extends JsonSchemaBasedInspectionBase {
    @Override
    protected PsiElementVisitor doBuildVisitor(@NotNull JsonValue root, final @Nullable JsonSchemaObject schema, @NotNull JsonSchemaService service, final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (root == null) {
            JsonSchemaDeprecationInspection.$$$reportNull$$$0(0);
        }
        if (service == null) {
            JsonSchemaDeprecationInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            JsonSchemaDeprecationInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            JsonSchemaDeprecationInspection.$$$reportNull$$$0(3);
        }
        if (schema == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        final JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker((PsiElement)root, schema);
        if (walker == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        final Project project = root.getProject();
        return new JsonElementVisitor(this){

            public void visitProperty(@NotNull JsonProperty o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.annotate(o);
                super.visitProperty(o);
            }

            private void annotate(@NotNull JsonProperty o) {
                JsonPointerPosition position;
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((position = walker.findPosition((PsiElement)o, true)) == null) {
                    return;
                }
                JsonPropertyAdapter parentPropertyAdapter = walker.getParentPropertyAdapter((PsiElement)o);
                MatchResult result = new JsonSchemaResolver(project, schema, position, parentPropertyAdapter == null ? null : parentPropertyAdapter.getNameValueAdapter()).detailedResolve();
                Iterable<JsonSchemaObject> iterable = result.myExcludingSchemas.size() == 1 ? ContainerUtil.concat(result.mySchemas, (Iterable)result.myExcludingSchemas.get(0)) : result.mySchemas;
                for (JsonSchemaObject object : iterable) {
                    String message = object.getDeprecationMessage();
                    if (message == null) continue;
                    holder.registerProblem((PsiElement)o.getNameElement(), JsonBundle.message((String)"property.0.is.deprecated.1", (Object[])new Object[]{o.getName(), message}), new LocalQuickFix[0]);
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "o";
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/inspections/JsonSchemaDeprecationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitProperty";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "annotate";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "service";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/jsonSchema/impl/inspections/JsonSchemaDeprecationInspection";
        objectArray[2] = "doBuildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

