/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Utilities {
    private static final int CTRL_WILDCARD_MASK = 32768;
    private static final int ALT_WILDCARD_MASK = 65536;
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_TRU64 = 512;
    public static final int OS_OS2 = 2048;
    public static final int OS_MAC = 4096;
    public static final int OS_WIN2000 = 8192;
    public static final int OS_VMS = 16384;
    public static final int OS_WIN_OTHER = 32768;
    public static final int OS_OTHER = 65536;
    public static final int OS_FREEBSD = 131072;
    public static final int OS_WINDOWS_MASK = 40967;
    public static final int OS_UNIX_MASK = 136184;
    public static final int TYPICAL_WINDOWS_TASKBAR_HEIGHT = 27;
    private static final int TYPICAL_MACOSX_MENU_HEIGHT = 24;
    private static int operatingSystem = -1;
    private static Reference<Object> namesAndValues;

    private Utilities() {
    }

    public static int getOperatingSystem() {
        if (operatingSystem == -1) {
            String osName = System.getProperty("os.name");
            operatingSystem = "Windows NT".equals(osName) ? 1 : ("Windows 95".equals(osName) ? 2 : ("Windows 98".equals(osName) ? 4 : ("Windows 2000".equals(osName) ? 8192 : (osName.startsWith("Windows ") ? 32768 : ("Solaris".equals(osName) ? 8 : (osName.startsWith("SunOS") ? 8 : (osName.endsWith("Linux") ? 16 : ("HP-UX".equals(osName) ? 32 : ("AIX".equals(osName) ? 64 : ("Irix".equals(osName) ? 128 : ("SunOS".equals(osName) ? 256 : ("Digital UNIX".equals(osName) ? 512 : ("OS/2".equals(osName) ? 2048 : ("OpenVMS".equals(osName) ? 16384 : (osName.equals("Mac OS X") ? 4096 : (osName.startsWith("Darwin") ? 4096 : (osName.toLowerCase(Locale.US).startsWith("freebsd") ? 131072 : 65536)))))))))))))))));
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return (Utilities.getOperatingSystem() & 0xA007) != 0;
    }

    public static boolean isUnix() {
        return (Utilities.getOperatingSystem() & 0x213F8) != 0;
    }

    public static boolean isLargeFrameIcons() {
        return Utilities.getOperatingSystem() == 8 || Utilities.getOperatingSystem() == 32;
    }

    private static GraphicsConfiguration getCurrentGraphicsConfiguration() {
        Window w;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner != null && (w = SwingUtilities.getWindowAncestor(focusOwner)) != null) {
            return w.getGraphicsConfiguration();
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static Rectangle getUsableScreenBounds() {
        return Utilities.getUsableScreenBounds(Utilities.getCurrentGraphicsConfiguration());
    }

    public static Rectangle getUsableScreenBounds(GraphicsConfiguration gconf) {
        if (gconf == null) {
            gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle bounds = new Rectangle(gconf.getBounds());
        String str = System.getProperty("netbeans.screen.insets");
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, ", ");
            if (st.countTokens() == 4) {
                try {
                    bounds.y = Integer.parseInt(st.nextToken());
                    bounds.x = Integer.parseInt(st.nextToken());
                    bounds.height -= bounds.y + Integer.parseInt(st.nextToken());
                    bounds.width -= bounds.x + Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException ex2) {
                    Logger.getAnonymousLogger().log(Level.WARNING, null, ex2);
                }
            }
            return bounds;
        }
        str = System.getProperty("netbeans.taskbar.height");
        if (str != null) {
            bounds.height -= Integer.getInteger(str, 0).intValue();
            return bounds;
        }
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Insets insets = toolkit.getScreenInsets(gconf);
            bounds.y += insets.top;
            bounds.x += insets.left;
            bounds.height -= insets.top + insets.bottom;
            bounds.width -= insets.left + insets.right;
        }
        catch (Exception ex3) {
            Logger.getAnonymousLogger().log(Level.WARNING, null, ex3);
        }
        return bounds;
    }

    private static synchronized HashMap[] initNameAndValues() {
        Field[] fields;
        HashMap[] arr;
        if (namesAndValues != null && (arr = (HashMap[])namesAndValues.get()) != null) {
            return arr;
        }
        try {
            fields = KeyEvent.class.getDeclaredFields();
        }
        catch (SecurityException e2) {
            fields = new Field[]{};
        }
        HashMap<String, Integer> names = new HashMap<String, Integer>(fields.length * 4 / 3 + 5, 0.75f);
        HashMap<Integer, String> values = new HashMap<Integer, String>(fields.length * 4 / 3 + 5, 0.75f);
        for (int i2 = 0; i2 < fields.length; ++i2) {
            String name;
            if (!Modifier.isStatic(fields[i2].getModifiers()) || !(name = fields[i2].getName()).startsWith("VK_")) continue;
            name = name.substring(3);
            try {
                int numb = fields[i2].getInt(null);
                Integer value = new Integer(numb);
                names.put(name, value);
                values.put(value, name);
                continue;
            }
            catch (IllegalArgumentException ex2) {
                continue;
            }
            catch (IllegalAccessException ex3) {
                // empty catch block
            }
        }
        if (names.get("CONTEXT_MENU") == null) {
            Integer n = new Integer(524);
            names.put("CONTEXT_MENU", n);
            values.put(n, "CONTEXT_MENU");
            n = new Integer(525);
            names.put("WINDOWS", n);
            values.put(n, "WINDOWS");
        }
        HashMap[] arr2 = new HashMap[]{names, values};
        namesAndValues = new SoftReference<HashMap[]>(arr2);
        return arr2;
    }

    public static String keyToString(KeyStroke stroke) {
        HashMap[] namesAndValues;
        String c;
        StringBuffer sb = new StringBuffer();
        if (Utilities.addModifiers(sb, stroke.getModifiers())) {
            sb.append('-');
        }
        if ((c = (String)(namesAndValues = Utilities.initNameAndValues())[1].get(new Integer(stroke.getKeyCode()))) == null) {
            sb.append(stroke.getKeyChar());
        } else {
            sb.append(c);
        }
        return sb.toString();
    }

    public static KeyStroke stringToKey(String s) {
        StringTokenizer st = new StringTokenizer(s.toUpperCase(Locale.ENGLISH), "-", true);
        int needed = 0;
        HashMap names = Utilities.initNameAndValues()[0];
        int lastModif = -1;
        try {
            String el;
            while (true) {
                if ((el = st.nextToken()).equals("-")) {
                    if (lastModif == -1) continue;
                    needed |= lastModif;
                    lastModif = -1;
                    continue;
                }
                if (!st.hasMoreElements()) break;
                lastModif = Utilities.readModifiers(el);
            }
            Integer i2 = (Integer)names.get(el);
            boolean wildcard = (needed & 0x8000) != 0;
            boolean macAlt = ((needed &= 0xFFFF7FFF) & 0x10000) != 0;
            needed &= 0xFFFEFFFF;
            if (i2 != null) {
                if (wildcard && (Utilities.getOperatingSystem() & 0x1000) != 0 && !Utilities.usableKeyOnMac(i2, needed |= Utilities.getMenuShortCutKeyMask())) {
                    needed &= ~Utilities.getMenuShortCutKeyMask();
                    needed |= 2;
                }
                if (macAlt) {
                    needed = Utilities.getOperatingSystem() == 4096 ? (needed |= 2) : (needed |= 8);
                }
                return KeyStroke.getKeyStroke(i2, needed);
            }
            return null;
        }
        catch (NoSuchElementException ex2) {
            return null;
        }
    }

    private static int getMenuShortCutKeyMask() {
        if (GraphicsEnvironment.isHeadless()) {
            return (Utilities.getOperatingSystem() & 0x1000) != 0 ? 4 : 2;
        }
        return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    private static boolean usableKeyOnMac(int key, int mask) {
        boolean isOnlyMeta;
        if (key == 81) {
            return false;
        }
        boolean isMeta = (mask & 4) != 0 || (mask & 0x80) != 0;
        boolean isAlt = (mask & 8) != 0 || (mask & 0x200) != 0;
        boolean bl = isOnlyMeta = isMeta && (mask & 0xFFFFFEFB) == 0;
        if (isOnlyMeta) {
            return key != 72 && key != 32 && key != 9;
        }
        return key != 68 || !isMeta || !isAlt;
    }

    public static KeyStroke[] stringToKeys(String s) {
        StringTokenizer st = new StringTokenizer(s.toUpperCase(Locale.ENGLISH), " ");
        ArrayList<KeyStroke> arr = new ArrayList<KeyStroke>();
        while (st.hasMoreElements()) {
            s = st.nextToken();
            KeyStroke k = Utilities.stringToKey(s);
            if (k == null) {
                return null;
            }
            arr.add(k);
        }
        return arr.toArray(new KeyStroke[arr.size()]);
    }

    private static boolean addModifiers(StringBuffer buf, int modif) {
        boolean b = false;
        if ((modif & 2) != 0) {
            buf.append("C");
            b = true;
        }
        if ((modif & 8) != 0) {
            buf.append("A");
            b = true;
        }
        if ((modif & 1) != 0) {
            buf.append("S");
            b = true;
        }
        if ((modif & 4) != 0) {
            buf.append("M");
            b = true;
        }
        if ((modif & 0x8000) != 0) {
            buf.append("D");
            b = true;
        }
        if ((modif & 0x10000) != 0) {
            buf.append("O");
            b = true;
        }
        return b;
    }

    private static int readModifiers(String s) throws NoSuchElementException {
        int m = 0;
        block8: for (int i2 = 0; i2 < s.length(); ++i2) {
            switch (s.charAt(i2)) {
                case 'C': {
                    m |= 2;
                    continue block8;
                }
                case 'A': {
                    m |= 8;
                    continue block8;
                }
                case 'M': {
                    m |= 4;
                    continue block8;
                }
                case 'S': {
                    m |= 1;
                    continue block8;
                }
                case 'D': {
                    m |= 0x8000;
                    continue block8;
                }
                case 'O': {
                    m |= 0x10000;
                    continue block8;
                }
                default: {
                    throw new NoSuchElementException(s);
                }
            }
        }
        return m;
    }

    public static Object toPrimitiveArray(Object[] array) {
        if (array instanceof Integer[]) {
            int[] r2 = new int[array.length];
            int k = array.length;
            for (int i2 = 0; i2 < k; ++i2) {
                r2[i2] = array[i2] == null ? 0 : (Integer)array[i2];
            }
            return r2;
        }
        if (array instanceof Boolean[]) {
            boolean[] r3 = new boolean[array.length];
            int k = array.length;
            for (int i3 = 0; i3 < k; ++i3) {
                r3[i3] = array[i3] != null && (Boolean)array[i3] != false;
            }
            return r3;
        }
        if (array instanceof Byte[]) {
            byte[] r4 = new byte[array.length];
            int k = array.length;
            for (int i4 = 0; i4 < k; ++i4) {
                r4[i4] = array[i4] == null ? (byte)0 : (Byte)array[i4];
            }
            return r4;
        }
        if (array instanceof Character[]) {
            char[] r5 = new char[array.length];
            int k = array.length;
            for (int i5 = 0; i5 < k; ++i5) {
                r5[i5] = array[i5] == null ? (char)'\u0000' : ((Character)array[i5]).charValue();
            }
            return r5;
        }
        if (array instanceof Double[]) {
            double[] r6 = new double[array.length];
            int k = array.length;
            for (int i6 = 0; i6 < k; ++i6) {
                r6[i6] = array[i6] == null ? 0.0 : (Double)array[i6];
            }
            return r6;
        }
        if (array instanceof Float[]) {
            float[] r7 = new float[array.length];
            int k = array.length;
            for (int i7 = 0; i7 < k; ++i7) {
                r7[i7] = array[i7] == null ? 0.0f : ((Float)array[i7]).floatValue();
            }
            return r7;
        }
        if (array instanceof Long[]) {
            long[] r8 = new long[array.length];
            int k = array.length;
            for (int i8 = 0; i8 < k; ++i8) {
                r8[i8] = array[i8] == null ? 0L : (Long)array[i8];
            }
            return r8;
        }
        if (array instanceof Short[]) {
            short[] r9 = new short[array.length];
            int k = array.length;
            for (int i9 = 0; i9 < k; ++i9) {
                r9[i9] = array[i9] == null ? (short)0 : (Short)array[i9];
            }
            return r9;
        }
        throw new IllegalArgumentException();
    }

    public static Object[] toObjectArray(Object array) {
        if (array instanceof Object[]) {
            return (Object[])array;
        }
        if (array instanceof int[]) {
            int k = ((int[])array).length;
            Object[] r2 = new Integer[k];
            for (int i2 = 0; i2 < k; ++i2) {
                r2[i2] = new Integer(((int[])array)[i2]);
            }
            return r2;
        }
        if (array instanceof boolean[]) {
            int k = ((boolean[])array).length;
            Object[] r3 = new Boolean[k];
            for (int i3 = 0; i3 < k; ++i3) {
                r3[i3] = ((boolean[])array)[i3] ? Boolean.TRUE : Boolean.FALSE;
            }
            return r3;
        }
        if (array instanceof byte[]) {
            int k = ((byte[])array).length;
            Object[] r4 = new Byte[k];
            for (int i4 = 0; i4 < k; ++i4) {
                r4[i4] = new Byte(((byte[])array)[i4]);
            }
            return r4;
        }
        if (array instanceof char[]) {
            int k = ((char[])array).length;
            Object[] r5 = new Character[k];
            for (int i5 = 0; i5 < k; ++i5) {
                r5[i5] = new Character(((char[])array)[i5]);
            }
            return r5;
        }
        if (array instanceof double[]) {
            int k = ((double[])array).length;
            Object[] r6 = new Double[k];
            for (int i6 = 0; i6 < k; ++i6) {
                r6[i6] = new Double(((double[])array)[i6]);
            }
            return r6;
        }
        if (array instanceof float[]) {
            int k = ((float[])array).length;
            Object[] r7 = new Float[k];
            for (int i7 = 0; i7 < k; ++i7) {
                r7[i7] = new Float(((float[])array)[i7]);
            }
            return r7;
        }
        if (array instanceof long[]) {
            int k = ((long[])array).length;
            Object[] r8 = new Long[k];
            for (int i8 = 0; i8 < k; ++i8) {
                r8[i8] = new Long(((long[])array)[i8]);
            }
            return r8;
        }
        if (array instanceof short[]) {
            int k = ((short[])array).length;
            Object[] r9 = new Short[k];
            for (int i9 = 0; i9 < k; ++i9) {
                r9[i9] = new Short(((short[])array)[i9]);
            }
            return r9;
        }
        throw new IllegalArgumentException();
    }

    public static String[] wrapStringToArray(String original, int width, BreakIterator breakIterator, boolean removeNewLines) {
        int i2;
        String[] workingSet;
        block14: {
            if (original.length() == 0) {
                return new String[]{original};
            }
            if (removeNewLines) {
                original = Utilities.trimString(original);
                original = original.replace('\n', ' ');
                workingSet = new String[]{original};
            } else {
                StringTokenizer tokens = new StringTokenizer(original, "\n");
                int len = tokens.countTokens();
                workingSet = new String[len];
                for (i2 = 0; i2 < len; ++i2) {
                    workingSet[i2] = tokens.nextToken();
                }
            }
            if (width < 1) {
                width = 1;
            }
            if (original.length() <= width) {
                return workingSet;
            }
            boolean ok = true;
            for (int i3 = 0; i3 < workingSet.length; ++i3) {
                boolean bl = ok = ok && workingSet[i3].length() < width;
                if (ok) {
                    continue;
                }
                break block14;
            }
            return workingSet;
        }
        ArrayList<String> lines2 = new ArrayList<String>();
        int lineStart = 0;
        for (i2 = 0; i2 < workingSet.length; ++i2) {
            if (workingSet[i2].length() < width) {
                lines2.add(workingSet[i2]);
                continue;
            }
            breakIterator.setText(workingSet[i2]);
            int nextStart = breakIterator.next();
            int prevStart = 0;
            while (true) {
                if (nextStart - lineStart < width && nextStart != -1) {
                    prevStart = nextStart;
                    nextStart = breakIterator.next();
                    continue;
                }
                if (nextStart == -1) {
                    nextStart = prevStart = workingSet[i2].length();
                }
                if (prevStart == 0) {
                    prevStart = nextStart;
                }
                lines2.add(workingSet[i2].substring(lineStart, prevStart));
                lineStart = prevStart;
                prevStart = 0;
                if (lineStart >= workingSet[i2].length()) break;
            }
            lineStart = 0;
        }
        String[] s = new String[lines2.size()];
        return lines2.toArray(s);
    }

    private static String trimString(String s) {
        char c;
        int idx = 0;
        int slen = s.length();
        if (slen == 0) {
            return s;
        }
        while (((c = s.charAt(idx++)) == '\n' || c == '\r') && idx < slen) {
        }
        --idx;
        if ((idx = (s = s.substring(idx)).length() - 1) < 0) {
            return s;
        }
        while (((c = s.charAt(idx--)) == '\n' || c == '\r') && idx >= 0) {
        }
        return s.substring(0, idx + 2);
    }
}

