# This file has been autogenerated by the pywayland scanner

# Copyright © 2023 Valve Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import Global, Interface, Proxy, Resource


class WpFifoV1(Interface):
    """Fifo interface

    A fifo object for a surface that may be used to add display refresh
    constraints to content updates.
    """

    name = "wp_fifo_v1"
    version = 1

    class error(enum.IntEnum):
        surface_destroyed = 0


class WpFifoV1Proxy(Proxy[WpFifoV1]):
    interface = WpFifoV1

    @WpFifoV1.request()
    def set_barrier(self) -> None:
        """Sets the start point for a fifo constraint

        When the content update containing the "set_barrier" is applied, it
        sets a "fifo_barrier" condition on the surface associated with the fifo
        object. The condition is cleared immediately after the following
        latching deadline for non-tearing presentation.

        The compositor may clear the condition early if it must do so to ensure
        client forward progress assumptions.

        To wait for this condition to clear, use the "wait_barrier" request.

        "set_barrier" is double-buffered state, see :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>`.

        Requesting set_barrier after the fifo object's surface is destroyed
        will generate a "surface_destroyed" error.
        """
        self._marshal(0)

    @WpFifoV1.request()
    def wait_barrier(self) -> None:
        """Adds a fifo constraint to a content update

        Indicate that this content update is not ready while a "fifo_barrier"
        condition is present on the surface.

        This means that when the content update containing "set_barrier" was
        made active at a latching deadline, it will be active for at least one
        refresh cycle. A content update which is allowed to tear might become
        active after a latching deadline if no content update became active at
        the deadline.

        The constraint must be ignored if the surface is a subsurface in
        synchronized mode. If the surface is not being updated by the
        compositor (off-screen, occluded) the compositor may ignore the
        constraint. Clients must use an additional mechanism such as frame
        callbacks or timestamps to ensure throttling occurs under all
        conditions.

        "wait_barrier" is double-buffered state, see :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>`.

        Requesting "wait_barrier" after the fifo object's surface is destroyed
        will generate a "surface_destroyed" error.
        """
        self._marshal(1)

    @WpFifoV1.request()
    def destroy(self) -> None:
        """Destroy the fifo interface

        Informs the server that the client will no longer be using this
        protocol object.

        Surface state changes previously made by this protocol are unaffected
        by this object's destruction.
        """
        self._marshal(2)
        self._destroy()


class WpFifoV1Resource(Resource):
    interface = WpFifoV1


class WpFifoV1Global(Global):
    interface = WpFifoV1


WpFifoV1._gen_c()
WpFifoV1.proxy_class = WpFifoV1Proxy
WpFifoV1.resource_class = WpFifoV1Resource
WpFifoV1.global_class = WpFifoV1Global
