\name{LaplacianSegmentationLevelSetImageFilter}
\alias{LaplacianSegmentationLevelSetImageFilter}
\title{LaplacianSegmentationLevelSetImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Segments structures in images based on a second derivative image
features.
LaplacianSegmentationLevelSetImageFilter}
\details{
IMPORTANT
The SegmentationLevelSetImageFilter class and the LaplacianSegmentationLevelSetFunction class contain additional information necessary to the full
understanding of how to use this filter.
OVERVIEW
This class is a level set method segmentation filter. It constructs a
speed function which is zero at image edges as detected by a Laplacian
filter. The evolving level set front will therefore tend to lock onto
zero crossings in the image. The level set front moves fastest near
edges.
The Laplacian segmentation filter is intended primarily as a tool for
refining existing segmentations. The initial isosurface (as given in
the seed input image) should ideally be very close to the segmentation
boundary of interest. The idea is that a rough segmentation can be
refined by allowing the isosurface to deform slightly to achieve a
better fit to the edge features of an image. One example of such an
application is to refine the output of a hand segmented image.
Because values in the Laplacian feature image will tend to be low
except near edge features, this filter is not effective for segmenting
large image regions from small seed surfaces.
INPUTS
This filter requires two inputs. The first input is a seed image. This
seed image must contain an isosurface that you want to use as the seed
for your segmentation. It can be a binary, graylevel, or floating
point image. The only requirement is that it contain a closed
isosurface that you will identify as the seed by setting the
IsosurfaceValue parameter of the filter. For a binary image you will
want to set your isosurface value halfway between your on and off
values (i.e. for 0's and 1's, use an isosurface value of 0.5).
The second input is the feature image. This is the image from which
the speed function will be calculated. For most applications, this is
the image that you want to segment. The desired isosurface in your
seed image should lie within the region of your feature image that you
are trying to segment.
 Note that this filter does no preprocessing of the feature image
before thresholding. Because second derivative calculations are highly
sensitive to noise, isotropic or anisotropic smoothing of the feature
image can dramatically improve the results.
See SegmentationLevelSetImageFilter for more information on Inputs.
OUTPUTS
The filter outputs a single, scalar, real-valued image. Positive
*values in the output image are inside the segmented region and
negative *values in the image are outside of the inside region. The
zero crossings of *the image correspond to the position of the level
set front.
See SparseFieldLevelSetImageFilter and SegmentationLevelSetImageFilter for more information.
PARAMETERS
This filter has no parameters other than those described in SegmentationLevelSetImageFilter .
See:
SegmentationLevelSetImageFilter
LaplacianSegmentationLevelSetFunction ,
SparseFieldLevelSetImageFilter
LaplacianSegmentationLevelSet for the procedural interface
itk::LaplacianSegmentationLevelSetImageFilter for the Doxygen on the original ITK class.
LaplacianSegmentationLevelSetImageFilter}
%C++ includes: sitkLaplacianSegmentationLevelSetImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &initialImage, const Image &featureImage):}{}
\item{Image Execute(Image &&initialImage, const Image &featureImage):}{
Execute the filter on the input image
}
\item{double GetCurvatureScaling() const:}{}
\item{uint32_t GetElapsedIterations() const:}{
Number of iterations run.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetMaximumRMSError() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfIterations() const:}{}
\item{double GetPropagationScaling() const:}{}
\item{bool GetReverseExpansionDirection() const:}{}
\item{double GetRMSChange() const:}{
The Root Mean Square of the levelset upon termination.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{ LaplacianSegmentationLevelSetImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self ReverseExpansionDirectionOff():}{}
\item{Self ReverseExpansionDirectionOn():}{
Set the value of ReverseExpansionDirection to true or false
respectfully.
}
\item{Self SetCurvatureScaling(double CurvatureScaling):}{}
\item{Self SetMaximumRMSError(double MaximumRMSError):}{}
\item{Self SetNumberOfIterations(uint32_t NumberOfIterations):}{}
\item{Self SetPropagationScaling(double PropagationScaling):}{}
\item{Self SetReverseExpansionDirection(bool ReverseExpansionDirection):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~LaplacianSegmentationLevelSetImageFilter():}{
Destructor
}
}
}
