/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bibgls.bib2gls.FieldValueElement;
import com.dickimawbooks.bibgls.common.Bib2GlsException;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValue;
import java.io.IOException;

public class FieldValueInterpret
implements FieldValueElement {
    private FieldValueElement fieldValueElem;
    protected boolean replace = true;

    public FieldValueInterpret(FieldValueElement fieldValueElement) {
        this(fieldValueElement, true);
    }

    public FieldValueInterpret(FieldValueElement fieldValueElement, boolean bl) {
        this.fieldValueElem = fieldValueElement;
        this.replace = bl;
    }

    @Override
    public BibValue getValue(Bib2GlsEntry bib2GlsEntry) throws Bib2GlsException, IOException {
        String string = this.getStringValue(bib2GlsEntry);
        if (string == null) {
            return null;
        }
        TeXParser teXParser = bib2GlsEntry.getResource().getParser();
        return new BibUserString(teXParser.getListener().createString(string));
    }

    @Override
    public String getStringValue(Bib2GlsEntry bib2GlsEntry) throws IOException, Bib2GlsException {
        Bib2Gls bib2Gls = bib2GlsEntry.getBib2Gls();
        BibValue bibValue = this.fieldValueElem.getValue(bib2GlsEntry);
        if (bibValue == null) {
            return null;
        }
        TeXParser teXParser = bib2GlsEntry.getResource().getParser();
        TeXObjectList teXObjectList = (TeXObjectList)bibValue.expand(teXParser).clone();
        String string = teXObjectList.toString(teXParser);
        String string2 = bib2Gls.interpret(string, teXObjectList, false);
        if (this.replace) {
            string2 = bib2Gls.replaceSpecialChars(string2);
        }
        return string2;
    }

    public String toString() {
        return String.format("\\%s{%s}", this.replace ? "INTERPRET" : "INTERPRETNOREPL", this.fieldValueElem);
    }
}

