﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/greengrass/GreengrassRequest.h>
#include <aws/greengrass/Greengrass_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Greengrass {
namespace Model {

/**
 */
class GetGroupCertificateAuthorityRequest : public GreengrassRequest {
 public:
  AWS_GREENGRASS_API GetGroupCertificateAuthorityRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetGroupCertificateAuthority"; }

  AWS_GREENGRASS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * The ID of the certificate authority.
   */
  inline const Aws::String& GetCertificateAuthorityId() const { return m_certificateAuthorityId; }
  inline bool CertificateAuthorityIdHasBeenSet() const { return m_certificateAuthorityIdHasBeenSet; }
  template <typename CertificateAuthorityIdT = Aws::String>
  void SetCertificateAuthorityId(CertificateAuthorityIdT&& value) {
    m_certificateAuthorityIdHasBeenSet = true;
    m_certificateAuthorityId = std::forward<CertificateAuthorityIdT>(value);
  }
  template <typename CertificateAuthorityIdT = Aws::String>
  GetGroupCertificateAuthorityRequest& WithCertificateAuthorityId(CertificateAuthorityIdT&& value) {
    SetCertificateAuthorityId(std::forward<CertificateAuthorityIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The ID of the Greengrass group.
   */
  inline const Aws::String& GetGroupId() const { return m_groupId; }
  inline bool GroupIdHasBeenSet() const { return m_groupIdHasBeenSet; }
  template <typename GroupIdT = Aws::String>
  void SetGroupId(GroupIdT&& value) {
    m_groupIdHasBeenSet = true;
    m_groupId = std::forward<GroupIdT>(value);
  }
  template <typename GroupIdT = Aws::String>
  GetGroupCertificateAuthorityRequest& WithGroupId(GroupIdT&& value) {
    SetGroupId(std::forward<GroupIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_certificateAuthorityId;
  bool m_certificateAuthorityIdHasBeenSet = false;

  Aws::String m_groupId;
  bool m_groupIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Greengrass
}  // namespace Aws
