/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.VcsConfigurationChangeListener;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.RootsAndBranches;
import org.jetbrains.idea.svn.integrate.Merger;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public class MergeInfoUpdatesListener {
    private static final int DELAY = 300;
    private final Project myProject;
    private final MessageBusConnection myConnection;
    private List<RootsAndBranches> myMergeInfoRefreshActions;
    private final ZipperUpdater myUpdater;

    public MergeInfoUpdatesListener(@NotNull Project project, MessageBusConnection connection) {
        if (project == null) {
            MergeInfoUpdatesListener.$$$reportNull$$$0(0);
        }
        this.myConnection = connection;
        this.myProject = project;
        this.myUpdater = new ZipperUpdater(300, (Disposable)project);
    }

    public void addPanel(RootsAndBranches action) {
        if (this.myMergeInfoRefreshActions == null) {
            this.myMergeInfoRefreshActions = new ArrayList<RootsAndBranches>();
            this.myMergeInfoRefreshActions.add(action);
            this.myConnection.subscribe(VcsConfigurationChangeListener.BRANCHES_CHANGED, (project, vcsRoot) -> this.callReloadMergeInfo());
            Consumer reloadConsumer = aBoolean -> {
                if (Boolean.TRUE.equals(aBoolean)) {
                    this.callReloadMergeInfo();
                }
            };
            final Runnable reloadRunnable = () -> this.callReloadMergeInfo();
            this.myConnection.subscribe(SvnVcs.WC_CONVERTED, (Object)reloadRunnable);
            this.myConnection.subscribe(RootsAndBranches.REFRESH_REQUEST, (Object)reloadRunnable);
            this.myConnection.subscribe(SvnVcs.ROOTS_RELOADED, (Object)reloadConsumer);
            this.myConnection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> this.callReloadMergeInfo());
            this.myConnection.subscribe(CommittedChangesTreeBrowser.ITEMS_RELOADED, (Object)new CommittedChangesTreeBrowser.CommittedChangesReloadListener(){

                public void itemsReloaded() {
                    reloadRunnable.run();
                }

                public void emptyRefresh() {
                }
            });
            this.myConnection.subscribe(SvnMergeInfoCache.SVN_MERGE_INFO_CACHE, () -> this.doForEachInitialized((Consumer<RootsAndBranches>)((Consumer)rootsAndBranches -> rootsAndBranches.fireRepaint())));
            this.myConnection.subscribe(Merger.COMMITTED_CHANGES_MERGED_STATE, list -> this.doForEachInitialized((Consumer<RootsAndBranches>)((Consumer)rootsAndBranches -> rootsAndBranches.refreshByLists(list))));
        } else {
            this.myMergeInfoRefreshActions.add(action);
        }
    }

    private void doForEachInitialized(Consumer<RootsAndBranches> consumer) {
        this.myUpdater.queue(() -> {
            for (RootsAndBranches action : this.myMergeInfoRefreshActions) {
                if (!action.strategyInitialized()) continue;
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    consumer.consume((Object)action);
                    continue;
                }
                ApplicationManager.getApplication().invokeLater(() -> consumer.consume((Object)action));
            }
        });
    }

    private void callReloadMergeInfo() {
        this.doForEachInitialized((Consumer<RootsAndBranches>)((Consumer)rootsAndBranches -> {
            rootsAndBranches.reloadPanels();
            rootsAndBranches.refresh();
        }));
    }

    public void removePanel(RootsAndBranches action) {
        if (this.myMergeInfoRefreshActions != null) {
            this.myMergeInfoRefreshActions.remove(action);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/history/MergeInfoUpdatesListener", "<init>"));
    }
}

