/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizerImpl;

public final class StandardFilter
extends TokenFilter {
    private static final String APOSTROPHE_TYPE;
    private static final String ACRONYM_TYPE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StandardFilter(TokenStream in) {
        super(in);
    }

    public final Token next(Token reusableToken) throws IOException {
        if (!$assertionsDisabled && reusableToken == null) {
            throw new AssertionError();
        }
        Token nextToken = this.input.next(reusableToken);
        if (nextToken == null) {
            return null;
        }
        char[] buffer = nextToken.termBuffer();
        int bufferLength = nextToken.termLength();
        String type = nextToken.type();
        if (type == APOSTROPHE_TYPE && bufferLength >= 2 && buffer[bufferLength - 2] == '\'' && (buffer[bufferLength - 1] == 's' || buffer[bufferLength - 1] == 'S')) {
            nextToken.setTermLength(bufferLength - 2);
        } else if (type == ACRONYM_TYPE) {
            int upto = 0;
            for (int i = 0; i < bufferLength; ++i) {
                char c = buffer[i];
                if (c == '.') continue;
                buffer[upto++] = c;
            }
            nextToken.setTermLength(upto);
        }
        return nextToken;
    }

    static {
        $assertionsDisabled = !StandardFilter.class.desiredAssertionStatus();
        APOSTROPHE_TYPE = StandardTokenizerImpl.TOKEN_TYPES[1];
        ACRONYM_TYPE = StandardTokenizerImpl.TOKEN_TYPES[2];
    }
}

