/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.WaitFor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchResult;
import org.jetbrains.idea.maven.indices.MavenSearcher;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.reposearch.DependencySearchService;
import org.jetbrains.idea.reposearch.SearchParameters;

public class MavenArtifactSearcher
extends MavenSearcher<MavenArtifactSearchResult> {
    @Override
    protected List<MavenArtifactSearchResult> searchImpl(Project project, String pattern, int maxResult) {
        if (StringUtil.isEmpty((String)pattern)) {
            return Collections.emptyList();
        }
        ArrayList<MavenRepositoryArtifactInfo> searchResults = new ArrayList<MavenRepositoryArtifactInfo>();
        DependencySearchService searchService = DependencySearchService.getInstance((Project)project);
        boolean useLocalProvidersOnly = ApplicationManager.getApplication().isUnitTestMode();
        SearchParameters parameters = new SearchParameters(false, useLocalProvidersOnly);
        final Promise asyncPromise = searchService.fulltextSearch(pattern, parameters, mdci -> {
            if (mdci instanceof MavenRepositoryArtifactInfo) {
                searchResults.add((MavenRepositoryArtifactInfo)mdci);
            }
        });
        new WaitFor(1000){

            protected boolean condition() {
                return asyncPromise.getState() != Promise.State.PENDING;
            }
        };
        return MavenArtifactSearcher.processResults(searchResults);
    }

    private static List<MavenArtifactSearchResult> processResults(List<MavenRepositoryArtifactInfo> searchResults) {
        return ContainerUtil.map(searchResults, MavenArtifactSearchResult::new);
    }
}

