/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ModuleLoweringPass;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/ExcludeDeclarationsFromCodegen;", "Lorg/jetbrains/kotlin/backend/common/ModuleLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "lower", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "backend.wasm"})
public final class ExcludeDeclarationsFromCodegen
implements ModuleLoweringPass {
    @NotNull
    private final WasmBackendContext context;

    public ExcludeDeclarationsFromCodegen(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public void lower(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        for (IrFile file : irModule.getFiles()) {
            Iterator it = file.getDeclarations().iterator();
            while (it.hasNext()) {
                IrDeclarationWithName d;
                Object e = it.next();
                IrDeclarationWithName irDeclarationWithName = e instanceof IrDeclarationWithName ? (IrDeclarationWithName)e : null;
                if (irDeclarationWithName == null || !ExcludeDeclarationsFromCodegen.lower$isExcluded((IrDeclaration)(d = irDeclarationWithName))) continue;
                it.remove();
                IrUtilsKt.addChild((IrDeclarationContainer)((IrDeclarationContainer)this.context.getExcludedPackageFragment(file.getPackageFqName())), (IrDeclaration)((IrDeclaration)d));
            }
        }
    }

    private static final boolean lower$isExcluded(IrDeclaration declaration) {
        IrFile parentFile;
        if (AnnotationsKt.hasExcludedFromCodegenAnnotation((IrAnnotationContainer)declaration)) {
            return true;
        }
        IrDeclarationParent irDeclarationParent = declaration.getParent();
        IrFile irFile = parentFile = irDeclarationParent instanceof IrFile ? (IrFile)irDeclarationParent : null;
        return irFile != null ? AnnotationsKt.hasExcludedFromCodegenAnnotation((IrAnnotationContainer)irFile) : false;
    }
}

