/*
 * Decompiled with CFR 0.152.
 */
package git4idea.applyChanges;

import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.GitApplyChangesNotification;
import git4idea.GitApplyChangesProcess;
import git4idea.GitDisposable;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.index.GitFileStatus;
import git4idea.repo.GitRepository;
import git4idea.stash.GitChangesSaver;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013BH\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J1\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002\u00a8\u0006\u0014"}, d2={"Lgit4idea/applyChanges/GitApplyChangesLocalChangesDetectedNotification;", "Lgit4idea/GitApplyChangesNotification;", "operationName", "", "Lorg/jetbrains/annotations/Nls;", "failedOnCommit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "successfulCommits", "", "repository", "Lgit4idea/repo/GitRepository;", "retryAction", "Lkotlin/Function1;", "Lgit4idea/stash/GitChangesSaver;", "", "<init>", "(Ljava/lang/String;Lcom/intellij/vcs/log/VcsCommitMetadata;Ljava/util/List;Lgit4idea/repo/GitRepository;Lkotlin/jvm/functions/Function1;)V", "saveAndRetryAction", "Lcom/intellij/notification/NotificationAction;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitApplyChangesLocalChangesDetectedNotification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitApplyChangesLocalChangesDetectedNotification.kt\ngit4idea/applyChanges/GitApplyChangesLocalChangesDetectedNotification\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1563#2:111\n1634#2,3:112\n1563#2:115\n1634#2,3:116\n*S KotlinDebug\n*F\n+ 1 GitApplyChangesLocalChangesDetectedNotification.kt\ngit4idea/applyChanges/GitApplyChangesLocalChangesDetectedNotification\n*L\n45#1:111\n45#1:112,3\n56#1:115\n56#1:116,3\n*E\n"})
public final class GitApplyChangesLocalChangesDetectedNotification
extends GitApplyChangesNotification {
    @NotNull
    private static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public GitApplyChangesLocalChangesDetectedNotification(@NotNull String operationName, @Nullable VcsCommitMetadata failedOnCommit, @NotNull List<? extends VcsCommitMetadata> successfulCommits, @NotNull GitRepository repository2, @NotNull Function1<? super GitChangesSaver, Unit> retryAction) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter(successfulCommits, (String)"successfulCommits");
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter(retryAction, (String)"retryAction");
        String string = VcsNotifier.importantNotification().getDisplayId();
        Object[] objectArray = new Object[]{StringsKt.capitalize((String)operationName)};
        String string2 = GitBundle.message("apply.changes.operation.failed", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        super(string, string2, Companion.getDescription(operationName, repository2, failedOnCommit, successfulCommits), NotificationType.ERROR);
        Project project = repository2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        List<GitFileStatus> list = repository2.getStagingAreaHolder().getAllRecords();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllRecords(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GitFileStatus gitFileStatus = (GitFileStatus)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        List affectedPaths = (List)destination$iv$iv;
        Collection<Change> collection = GitChangeUtils.getLocalChangesDiff(project2, repository2.getRoot(), affectedPaths);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getLocalChangesDiff(...)");
        List localChanges = CollectionsKt.toList((Iterable)collection);
        this.setDisplayId("git.apply.changes.local.changes.detected");
        this.addAction((AnAction)NotificationAction.createSimple((Supplier)IdeBundle.messagePointer((String)"action.show.files", (Object[])new Object[0]), () -> GitApplyChangesLocalChangesDetectedNotification._init_$lambda$2(project2, operationName, localChanges, affectedPaths)));
        if (!((Collection)localChanges).isEmpty()) {
            this.addAction((AnAction)this.saveAndRetryAction(repository2, operationName, retryAction));
        }
    }

    private final NotificationAction saveAndRetryAction(GitRepository repository2, String operationName, Function1<? super GitChangesSaver, Unit> retryAction) {
        Project project = repository2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        GitSaveChangesPolicy savingStrategy = Companion.getSavingStrategy(project);
        Object[] objectArray = new Object[]{savingStrategy.getText()};
        String string = GitBundle.message("apply.changes.save.and.retry.operation", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String actionText = string;
        NotificationAction notificationAction = NotificationAction.createExpiring((String)actionText, (arg_0, arg_1) -> GitApplyChangesLocalChangesDetectedNotification.saveAndRetryAction$lambda$4((arg_0, arg_1) -> GitApplyChangesLocalChangesDetectedNotification.saveAndRetryAction$lambda$3(repository2, savingStrategy, operationName, retryAction, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createExpiring(...)");
        return notificationAction;
    }

    /*
     * WARNING - void declaration
     */
    private static final void _init_$lambda$2(Project $project, String $operationName, List $localChanges, List $affectedPaths) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $affectedPaths;
        List list = $localChanges;
        String string = null;
        String string2 = $operationName;
        Project project = $project;
        boolean $i$f$map = false;
        void var6_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FilePath filePath = (FilePath)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        collection = (List)destination$iv$iv;
        LocalChangesWouldBeOverwrittenHelper.showErrorDialog(project, string2, string, list, collection);
    }

    private static final Unit saveAndRetryAction$lambda$3(GitRepository $repository, GitSaveChangesPolicy $savingStrategy, String $operationName, Function1 $retryAction, AnActionEvent anActionEvent, Notification notification) {
        Project project = $repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        BuildersKt.launch$default((CoroutineScope)GitDisposable.Companion.getInstance(project).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($repository, $savingStrategy, $operationName, (Function1<? super GitChangesSaver, Unit>)$retryAction, null){
            int label;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ GitSaveChangesPolicy $savingStrategy;
            final /* synthetic */ String $operationName;
            final /* synthetic */ Function1<GitChangesSaver, Unit> $retryAction;
            {
                this.$repository = $repository;
                this.$savingStrategy = $savingStrategy;
                this.$operationName = $operationName;
                this.$retryAction = $retryAction;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Project project = this.$repository.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        String string = this.$savingStrategy.selectBundleMessage(GitBundle.message("stashing.progress.title", new Object[0]), VcsBundle.message((String)"shelve.changes.progress.text", (Object[])new Object[0]));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selectBundleMessage(...)");
                        this.label = 1;
                        Object object2 = TasksKt.withBackgroundProgress((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$repository, this.$operationName, this.$savingStrategy, this.$retryAction, null){
                            int label;
                            final /* synthetic */ GitRepository $repository;
                            final /* synthetic */ String $operationName;
                            final /* synthetic */ GitSaveChangesPolicy $savingStrategy;
                            final /* synthetic */ Function1<GitChangesSaver, Unit> $retryAction;
                            {
                                this.$repository = $repository;
                                this.$operationName = $operationName;
                                this.$savingStrategy = $savingStrategy;
                                this.$retryAction = $retryAction;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object[] objectArray = new Object[]{this.$operationName};
                                        GitChangesSaver gitChangesSaver = GitChangesSaver.getSaver(this.$repository.getProject(), Git.getInstance(), (ProgressIndicator)new EmptyProgressIndicator(), VcsBundle.message((String)"stash.changes.message", (Object[])objectArray), this.$savingStrategy);
                                        Intrinsics.checkNotNullExpressionValue((Object)gitChangesSaver, (String)"getSaver(...)");
                                        GitChangesSaver changesSaver = gitChangesSaver;
                                        this.$retryAction.invoke((Object)changesSaver);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final void saveAndRetryAction$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J8\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u000b\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011\u00a8\u0006\u0012"}, d2={"Lgit4idea/applyChanges/GitApplyChangesLocalChangesDetectedNotification$Companion;", "", "<init>", "()V", "getSavingStrategy", "Lgit4idea/config/GitSaveChangesPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "getDescription", "", "Lorg/jetbrains/annotations/Nls;", "operationName", "repository", "Lgit4idea/repo/GitRepository;", "failedOnCommit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "successfulCommits", "", "intellij.vcs.git"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitSaveChangesPolicy getSavingStrategy(@NotNull Project project) {
            GitSaveChangesPolicy gitSaveChangesPolicy;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (GitVcsApplicationSettings.getInstance().isStagingAreaEnabled()) {
                gitSaveChangesPolicy = GitSaveChangesPolicy.STASH;
            } else {
                GitSaveChangesPolicy gitSaveChangesPolicy2 = GitVcsSettings.getInstance(project).getSaveChangesPolicy();
                gitSaveChangesPolicy = gitSaveChangesPolicy2;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)gitSaveChangesPolicy2), (String)"getSaveChangesPolicy(...)");
            }
            return gitSaveChangesPolicy;
        }

        @NotNull
        public final String getDescription(@NotNull String operationName, @NotNull GitRepository repository2, @Nullable VcsCommitMetadata failedOnCommit, @NotNull List<? extends VcsCommitMetadata> successfulCommits) {
            Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter(successfulCommits, (String)"successfulCommits");
            Object description = failedOnCommit != null ? GitApplyChangesProcess.Companion.commitDetails(failedOnCommit) + "<br/>" : "";
            Object[] objectArray = new Object[2];
            objectArray[0] = operationName;
            Project project = repository2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            objectArray[1] = StringUtil.toLowerCase((String)this.getSavingStrategy(project).getText());
            description = (String)description + GitBundle.message("warning.your.local.changes.would.be.overwritten.by", objectArray);
            description = (String)description + GitApplyChangesProcess.Companion.getSuccessfulCommitDetailsIfAny(successfulCommits, operationName);
            return description;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

