/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.server.application.PipelineCall;
import io.ktor.server.routing.RoutingNode;
import io.ktor.server.routing.RoutingResolveResult;
import io.ktor.server.routing.RoutingResolveTraceEntry;
import io.ktor.server.routing.Stack;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J%\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u001b\u0010 \u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0004\u00a2\u0006\u0004\b \u0010!R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\"\u001a\u0004\b#\u0010$R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010%\u001a\u0004\b&\u0010'R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0018\u0010+\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0016\u0010-\u001a\u00020\u00148\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b-\u0010.R \u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00040/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u0010%\u00a8\u00061"}, d2={"Lio/ktor/server/routing/RoutingResolveTrace;", "", "Lio/ktor/server/application/PipelineCall;", "call", "", "", "segments", "<init>", "(Lio/ktor/server/application/PipelineCall;Ljava/util/List;)V", "Lio/ktor/server/routing/RoutingResolveTraceEntry;", "entry", "", "register", "(Lio/ktor/server/routing/RoutingResolveTraceEntry;)V", "Lio/ktor/server/routing/RoutingNode;", "route", "", "segmentIndex", "begin", "(Lio/ktor/server/routing/RoutingNode;I)V", "Lio/ktor/server/routing/RoutingResolveResult;", "result", "finish", "(Lio/ktor/server/routing/RoutingNode;ILio/ktor/server/routing/RoutingResolveResult;)V", "skip", "registerFinalResult", "(Lio/ktor/server/routing/RoutingResolveResult;)V", "toString", "()Ljava/lang/String;", "buildText", "Lio/ktor/server/routing/RoutingResolveResult$Success;", "trait", "addCandidate", "(Ljava/util/List;)V", "Lio/ktor/server/application/PipelineCall;", "getCall", "()Lio/ktor/server/application/PipelineCall;", "Ljava/util/List;", "getSegments", "()Ljava/util/List;", "Lio/ktor/server/routing/Stack;", "stack", "Lio/ktor/server/routing/Stack;", "routing", "Lio/ktor/server/routing/RoutingResolveTraceEntry;", "finalResult", "Lio/ktor/server/routing/RoutingResolveResult;", "", "resolveCandidates", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nRoutingResolveTrace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoutingResolveTrace.kt\nio/ktor/server/routing/RoutingResolveTrace\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
public final class RoutingResolveTrace {
    @NotNull
    private final PipelineCall call;
    @NotNull
    private final List<String> segments;
    @NotNull
    private final Stack<RoutingResolveTraceEntry> stack;
    @Nullable
    private RoutingResolveTraceEntry routing;
    private RoutingResolveResult finalResult;
    @NotNull
    private final List<List<RoutingResolveResult.Success>> resolveCandidates;

    public RoutingResolveTrace(@NotNull PipelineCall call, @NotNull List<String> segments) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        this.call = call;
        this.segments = segments;
        this.stack = new Stack();
        this.resolveCandidates = new ArrayList();
    }

    @NotNull
    public final PipelineCall getCall() {
        return this.call;
    }

    @NotNull
    public final List<String> getSegments() {
        return this.segments;
    }

    private final void register(RoutingResolveTraceEntry entry) {
        if (this.stack.empty()) {
            this.routing = entry;
        } else {
            this.stack.peek().append(entry);
        }
    }

    public final void begin(@NotNull RoutingNode route, int segmentIndex) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        this.stack.push(new RoutingResolveTraceEntry(route, segmentIndex, null, 4, null));
    }

    public final void finish(@NotNull RoutingNode route, int segmentIndex, @NotNull RoutingResolveResult result2) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        RoutingResolveTraceEntry entry = this.stack.pop();
        if (!Intrinsics.areEqual((Object)entry.getRoute(), (Object)route)) {
            boolean $i$a$-require-RoutingResolveTrace$finish$32 = false;
            String $i$a$-require-RoutingResolveTrace$finish$32 = "end should be called for the same route as begin";
            throw new IllegalArgumentException($i$a$-require-RoutingResolveTrace$finish$32.toString());
        }
        if (!(entry.getSegmentIndex() == segmentIndex)) {
            boolean bl = false;
            String string = "end should be called for the same segmentIndex as begin";
            throw new IllegalArgumentException(string.toString());
        }
        entry.setResult(result2);
        this.register(entry);
    }

    public final void skip(@NotNull RoutingNode route, int segmentIndex, @NotNull RoutingResolveResult result2) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.register(new RoutingResolveTraceEntry(route, segmentIndex, result2));
    }

    public final void registerFinalResult(@NotNull RoutingResolveResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.finalResult = result2;
    }

    @NotNull
    public String toString() {
        return "Trace for " + this.segments;
    }

    @NotNull
    public final String buildText() {
        StringBuilder stringBuilder;
        StringBuilder $this$buildText_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildText_u24lambda_u244.append(this.toString()).append('\n');
        RoutingResolveTraceEntry routingResolveTraceEntry = this.routing;
        if (routingResolveTraceEntry != null) {
            routingResolveTraceEntry.buildText($this$buildText_u24lambda_u244, 0);
        }
        if (this.finalResult != null) {
            $this$buildText_u24lambda_u244.append("Matched routes:").append('\n');
            StringBuilder stringBuilder2 = this.resolveCandidates.isEmpty() ? $this$buildText_u24lambda_u244.append("  No results").append('\n') : $this$buildText_u24lambda_u244.append(CollectionsKt.joinToString$default((Iterable)this.resolveCandidates, (CharSequence)"\n", null, null, (int)0, null, RoutingResolveTrace::buildText$lambda$4$lambda$3, (int)30, null)).append('\n');
            $this$buildText_u24lambda_u244.append("Routing resolve result:").append('\n');
            StringBuilder stringBuilder3 = new StringBuilder().append("  ");
            RoutingResolveResult routingResolveResult = this.finalResult;
            if (routingResolveResult == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"finalResult");
                routingResolveResult = null;
            }
            $this$buildText_u24lambda_u244.append(stringBuilder3.append(routingResolveResult).toString());
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final void addCandidate(@NotNull List<RoutingResolveResult.Success> trait) {
        Intrinsics.checkNotNullParameter(trait, (String)"trait");
        int n = trait.size();
        ArrayList<RoutingResolveResult.Success> arrayList = new ArrayList<RoutingResolveResult.Success>(n);
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<RoutingResolveResult.Success> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(trait.get((int)it));
        }
        List candidate = arrayList;
        this.resolveCandidates.add(candidate);
    }

    private static final CharSequence buildText$lambda$4$lambda$3$lambda$2(RoutingResolveResult.Success it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "" + '\"' + it.getRoute().getSelector() + '\"';
    }

    private static final CharSequence buildText$lambda$4$lambda$3(List path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return CollectionsKt.joinToString$default((Iterable)path, (CharSequence)" -> ", (CharSequence)"  ", null, (int)0, null, RoutingResolveTrace::buildText$lambda$4$lambda$3$lambda$2, (int)28, null);
    }
}

