/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.preferences.ColorInfo;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.gui.MapScaler;
import org.openstreetmap.josm.gui.MapStatus;
import org.openstreetmap.josm.gui.conflict.ConflictColors;
import org.openstreetmap.josm.gui.dialogs.ConflictDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.gpx.GpxDrawHelper;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.preferences.ExtensibleTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.advanced.PreferencesTable;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.gui.widgets.FilterField;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ColorPreference
extends ExtensibleTabPreferenceSetting
implements ListSelectionListener,
TableModelListener {
    private ColorTableModel tableModel;
    private JTable colors;
    private JButton colorEdit;
    private JButton defaultSet;
    private JButton remove;

    ColorPreference() {
        super("color", I18n.tr("Colors", new Object[0]), I18n.tr("Change colors used in program dialogs and in map paint styles.", new Object[0]));
    }

    public void setColors(Map<String, ColorInfo> colorMap) {
        if (this.tableModel == null) {
            this.tableModel = new ColorTableModel();
        }
        this.tableModel.clear();
        colorMap.entrySet().stream().map(e -> new ColorEntry((String)e.getKey(), (ColorInfo)e.getValue())).sorted((e1, e2) -> {
            int cat = Integer.compare(ColorPreference.getCategoryPriority(e1.info.getCategory()), ColorPreference.getCategoryPriority(e2.info.getCategory()));
            if (cat != 0) {
                return cat;
            }
            return Collator.getInstance().compare(e1.getDisplay(), e2.getDisplay());
        }).forEach(this.tableModel::addEntry);
        if (this.colors != null) {
            this.colors.repaint();
        }
    }

    private static int getCategoryPriority(String category) {
        switch (category) {
            case "general": {
                return 1;
            }
            case "mappaint": {
                return 2;
            }
        }
        return 3;
    }

    public Map<String, ColorInfo> getColors() {
        return this.tableModel.getData().stream().collect(Collectors.toMap(e -> e.key, e -> e.info));
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        ColorPreference.fixColorPrefixes();
        this.setColors(Preferences.main().getAllNamedColors());
        this.colorEdit = new JButton(I18n.tr("Choose", new Object[0]), ImageProvider.get("colorchooser", ImageProvider.ImageSizes.SMALLICON));
        this.colorEdit.addActionListener(e -> {
            int sel = this.colors.getSelectedRow();
            ColorEntry ce = (ColorEntry)this.colors.getValueAt(sel, 0);
            JColorChooser chooser = new JColorChooser(ce.getDisplayColor());
            int answer = JOptionPane.showConfirmDialog(gui, chooser, I18n.tr("Choose a color for {0}", ce.getDisplay()), 2, -1);
            if (answer == 0) {
                this.colors.setValueAt(chooser.getColor(), sel, 1);
            }
        });
        this.defaultSet = new JButton(I18n.tr("Reset to default", new Object[0]), ImageProvider.get("undo", ImageProvider.ImageSizes.SMALLICON));
        this.defaultSet.addActionListener(e -> {
            int sel = this.colors.getSelectedRow();
            ColorEntry ce = (ColorEntry)this.colors.getValueAt(sel, 0);
            Color c = ce.info.getDefaultValue();
            if (c != null) {
                this.colors.setValueAt(c, sel, 1);
            }
        });
        JButton defaultAll = new JButton(I18n.tr("Set all to default", new Object[0]), ImageProvider.get("undo", ImageProvider.ImageSizes.SMALLICON));
        defaultAll.addActionListener(e -> {
            List<ColorEntry> data = this.tableModel.getData();
            for (ColorEntry ce : data) {
                Color c = ce.info.getDefaultValue();
                if (c == null) continue;
                ce.info.setValue(c);
            }
            this.tableModel.fireTableDataChanged();
        });
        this.remove = new JButton(I18n.tr("Remove", new Object[0]), ImageProvider.get("dialogs/delete", ImageProvider.ImageSizes.SMALLICON));
        this.remove.addActionListener(e -> {
            int sel = this.colors.getSelectedRow();
            sel = this.colors.convertRowIndexToModel(sel);
            this.tableModel.removeEntry(sel);
        });
        this.remove.setEnabled(false);
        this.colorEdit.setEnabled(false);
        this.defaultSet.setEnabled(false);
        this.colors = new JTable(this.tableModel);
        TableHelper.setFont(this.colors, PreferencesTable.class);
        this.colors.setAutoCreateRowSorter(true);
        FilterField colorFilter = new FilterField().filter(this.colors, this.tableModel);
        this.colors.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    ColorPreference.this.colorEdit.doClick();
                }
            }
        });
        this.colors.setSelectionMode(0);
        this.colors.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null && comp instanceof JLabel) {
                    JLabel label = (JLabel)comp;
                    ColorEntry e = (ColorEntry)value;
                    label.setText(e.getDisplay());
                    if (!e.isDefault()) {
                        label.setFont(label.getFont().deriveFont(1));
                    } else {
                        label.setFont(label.getFont().deriveFont(0));
                    }
                    return label;
                }
                return comp;
            }
        });
        this.colors.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null && comp instanceof JLabel) {
                    JLabel label = (JLabel)comp;
                    Color c = (Color)value;
                    label.setText(ColorHelper.color2html(c));
                    GuiHelper.setBackgroundReadable(label, c);
                    label.setOpaque(true);
                    return label;
                }
                return comp;
            }
        });
        this.colors.getColumnModel().getColumn(1).setWidth(100);
        this.colors.setToolTipText(I18n.tr("Colors used by different objects in JOSM.", new Object[0]));
        this.colors.setPreferredScrollableViewportSize(new Dimension(100, 112));
        this.colors.getSelectionModel().addListSelectionListener(this);
        this.colors.getModel().addTableModelListener(this);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)colorFilter, GBC.eol().insets(0, 0, 0, 5).fill(2));
        JScrollPane scrollpane = new JScrollPane(this.colors);
        panel.add((Component)scrollpane, GBC.eol().fill(1));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        panel.add((Component)buttonPanel, GBC.eol().insets(5, 0, 5, 5).fill(2));
        buttonPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        buttonPanel.add((Component)this.colorEdit, GBC.std().insets(0, 5, 0, 0));
        buttonPanel.add((Component)this.defaultSet, GBC.std().insets(5, 5, 5, 0));
        buttonPanel.add((Component)defaultAll, GBC.std().insets(0, 5, 0, 0));
        buttonPanel.add((Component)this.remove, GBC.std().insets(0, 5, 0, 0));
        this.getTabPane().addTab(I18n.tr("Colors", new Object[0]), panel);
        super.addGui(gui);
    }

    private static boolean isRemoveColor(ColorEntry ce) {
        return false;
    }

    private static void fixColorPrefixes() {
        PaintColors.values();
        ConflictColors.getColors();
        Severity.getColors();
        MarkerLayer.DEFAULT_COLOR_PROPERTY.get();
        GpxDrawHelper.DEFAULT_COLOR_PROPERTY.get();
        OsmDataLayer.getOutsideColor();
        MapScaler.getColor();
        MapStatus.getColors();
        ConflictDialog.getColor();
    }

    @Override
    public boolean ok() {
        for (ColorEntry d : this.tableModel.getDeleted()) {
            d.toProperty().remove();
        }
        for (ColorEntry e : this.tableModel.getData()) {
            if (e.info.getValue() == null) continue;
            e.toProperty().put(e.info.getValue());
        }
        OsmDataLayer.createHatchTexture();
        return false;
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateEnabledState();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        int sel = this.colors.getSelectedRow();
        ColorEntry ce = sel >= 0 && sel < this.colors.getRowCount() ? (ColorEntry)this.colors.getValueAt(sel, 0) : null;
        this.remove.setEnabled(ce != null && ColorPreference.isRemoveColor(ce));
        this.colorEdit.setEnabled(ce != null);
        this.defaultSet.setEnabled(ce != null && !ce.isDefault());
    }

    @Override
    public String getHelpContext() {
        return HelpUtil.ht("/Preferences/ColorPreference");
    }

    private static class ColorTableModel
    extends AbstractTableModel {
        private final List<ColorEntry> data = new ArrayList<ColorEntry>();
        private final List<ColorEntry> deleted = new ArrayList<ColorEntry>();

        ColorTableModel() {
        }

        public void addEntry(ColorEntry entry) {
            this.data.add(entry);
        }

        public void removeEntry(int row) {
            this.deleted.add(this.data.get(row));
            this.data.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public ColorEntry getEntry(int row) {
            return this.data.get(row);
        }

        public List<ColorEntry> getData() {
            return this.data;
        }

        public List<ColorEntry> getDeleted() {
            return this.deleted;
        }

        public void clear() {
            this.data.clear();
            this.deleted.clear();
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return columnIndex == 0 ? this.data.get(rowIndex) : this.data.get(rowIndex).getDisplayColor();
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? I18n.tr("Name", new Object[0]) : I18n.tr("Color", new Object[0]);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1 && aValue instanceof Color) {
                this.getEntry((int)rowIndex).info.setValue((Color)aValue);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
    }

    private static class ColorEntry {
        String key;
        ColorInfo info;

        ColorEntry(String key, ColorInfo info) {
            CheckParameterUtil.ensureParameterNotNull(key, "key");
            CheckParameterUtil.ensureParameterNotNull(info, "info");
            this.key = key;
            this.info = info;
        }

        public String getDisplay() {
            if (this.info.getSource() != null) {
                if (this.info.getCategory() == "mappaint") {
                    return I18n.tr("Paint style {0}: {1}", I18n.tr(I18n.escape(this.info.getSource()), new Object[0]), I18n.tr(this.info.getName(), new Object[0]));
                }
                return I18n.tr(I18n.escape(this.info.getSource()), new Object[0]) + " - " + I18n.tr(I18n.escape(this.info.getName()), new Object[0]);
            }
            return I18n.tr(I18n.escape(this.info.getName()), new Object[0]);
        }

        public Color getDisplayColor() {
            return Optional.ofNullable(this.info.getValue()).orElse(this.info.getDefaultValue());
        }

        public boolean isDefault() {
            return this.info.getValue() == null || Objects.equals(this.info.getValue(), this.info.getDefaultValue());
        }

        public NamedColorProperty toProperty() {
            return new NamedColorProperty(this.info.getCategory(), this.info.getSource(), this.info.getName(), this.info.getDefaultValue());
        }

        public String toString() {
            return "ColorEntry{" + this.getDisplay() + " " + ColorHelper.color2html(this.getDisplayColor()) + "}";
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ColorPreference();
        }
    }
}

