/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="uninstall", header={"Uninstall Keycloak Windows service."}, description={"%nUninstall Keycloak Windows service installed with 'kc.bat tools windows-service install'.", "", "This command requires prunsrv.exe to be present in the bin directory."}, footerHeading="Examples:", footer={"  Uninstall with default service name:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME}%n%n  Uninstall a custom-named service:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --name=my-keycloak%n"})
public class WindowsServiceUninstall
extends AbstractCommand {
    public static final String NAME = "uninstall";
    private static final String DEFAULT_SERVICE_NAME = "keycloak";
    @CommandLine.Option(names={"--name"}, description={"The name of the Windows service to uninstall."}, defaultValue="keycloak")
    String serviceName;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isHelpAll() {
        return false;
    }

    @Override
    protected void runCommand() {
        Path homePath;
        Path prunsrvPath;
        if (!Environment.isWindows()) {
            this.executionError(this.spec.commandLine(), "Windows service management is only available on Windows.");
        }
        if (!Files.exists(prunsrvPath = (homePath = Environment.getHomePath().orElseThrow(() -> new CommandLine.ExecutionException(this.spec.commandLine(), "Could not determine Keycloak home directory"))).resolve("bin").resolve("prunsrv.exe"), new LinkOption[0])) {
            this.picocli.println("Looking for prunsrv.exe in: " + String.valueOf(prunsrvPath));
            this.picocli.println("Download from https://downloads.apache.org/commons/daemon/binaries/windows/");
            this.executionError(this.spec.commandLine(), "Apache Commons Daemon (Procrun) executable not found at " + String.valueOf(prunsrvPath));
        }
        this.picocli.println("Deleting Keycloak service '" + this.serviceName + "'...");
        ArrayList<String> command = new ArrayList<String>();
        command.add(prunsrvPath.toString());
        command.add("delete");
        command.add(this.serviceName);
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.inheritIO();
            Process process = pb.start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                this.picocli.println("Service '" + this.serviceName + "' uninstalled successfully.");
            } else {
                this.executionError(this.spec.commandLine(), "Failed to uninstall service '" + this.serviceName + "'. Exit code: " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            this.executionError(this.spec.commandLine(), "Failed to execute prunsrv: " + e.getMessage(), e);
        }
    }
}

