/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.parser.lexparser.BoundaryRemover;
import edu.stanford.nlp.parser.lexparser.CNFTransformers;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import java.util.ArrayList;

public class Debinarizer
implements TreeTransformer {
    private final TreeFactory tf;
    private final boolean forceCNF;

    protected Tree transformTreeHelper(Tree t) {
        if (t.isLeaf()) {
            Tree leaf = this.tf.newLeaf(t.label());
            leaf.setScore(t.score());
            return leaf;
        }
        ArrayList<Tree> newChildren = new ArrayList<Tree>(20);
        int numKids = t.numChildren();
        for (int childNum = 0; childNum < numKids; ++childNum) {
            Tree child = t.getChild(childNum);
            Tree newChild = this.transformTreeHelper(child);
            if (!newChild.isLeaf() && newChild.label().value().indexOf(64) >= 0) {
                newChildren.addAll(newChild.getChildrenAsList());
                continue;
            }
            newChildren.add(newChild);
        }
        Tree node = this.tf.newTreeNode(t.label(), newChildren);
        node.setScore(t.score());
        return node;
    }

    public Tree transformTree(Tree t) {
        Tree result = this.transformTreeHelper(t);
        if (this.forceCNF) {
            result = new CNFTransformers.FromCNFTransformer().transformTree(result);
        }
        return new BoundaryRemover().transformTree(result);
    }

    public Debinarizer(boolean forceCNF) {
        this(forceCNF, CoreLabel.factory());
    }

    public Debinarizer(boolean forceCNF, LabelFactory lf) {
        this.forceCNF = forceCNF;
        this.tf = new LabeledScoredTreeFactory(lf);
    }
}

