/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.tuebadz;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TueBaDZPennTreeNormalizer
extends TreeNormalizer {
    private final int nodeCleanup;
    private final String root;
    protected final TreebankLanguagePack tlp;
    private List<TreeNormalizer> tns = new ArrayList<TreeNormalizer>();
    private static final long serialVersionUID = 8009544230321390490L;

    public String rootSymbol() {
        return this.root;
    }

    public TueBaDZPennTreeNormalizer(TreebankLanguagePack tlp, int nodeCleanup) {
        this.tlp = tlp;
        this.nodeCleanup = nodeCleanup;
        this.root = tlp.startSymbol();
    }

    public TueBaDZPennTreeNormalizer(TreebankLanguagePack tlp, int nodeCleanup, List<TreeNormalizer> tns) {
        this.tlp = tlp;
        this.nodeCleanup = nodeCleanup;
        this.root = tlp.startSymbol();
        this.tns.addAll(tns);
    }

    @Override
    public String normalizeTerminal(String leaf) {
        return leaf.intern();
    }

    @Override
    public String normalizeNonterminal(String category) {
        return this.cleanUpLabel(category).intern();
    }

    protected String cleanUpLabel(String label) {
        if (label == null) {
            return this.root;
        }
        if (this.nodeCleanup == 1) {
            return this.tlp.categoryAndFunction(label);
        }
        if (this.nodeCleanup == 2) {
            return this.tlp.basicCategory(label);
        }
        return label;
    }

    @Override
    public Tree normalizeWholeTree(Tree tree, TreeFactory tf) {
        if (tree.label().value().equals(this.root) && tree.children().length > 1) {
            Tree underRoot = tree.treeFactory().newTreeNode(this.root, tree.getChildrenAsList());
            tree.setChildren(new Tree[1]);
            tree.setChild(0, underRoot);
        }
        return tree;
    }
}

