! 
!     Copyright (c) 2017, NVIDIA CORPORATION.  All rights reserved.
!
! NVIDIA CORPORATION and its licensors retain all intellectual property
! and proprietary rights in and to this software, related documentation
! and any modifications thereto.  Any use, reproduction, disclosure or
! distribution of this software and related documentation without an express
! license agreement from NVIDIA CORPORATION is strictly prohibited.
! 


! Interfaces for lib3f routines.
! Version 3.4

      interface

        subroutine abort()
        end subroutine

        integer function access(fil,mod)
        character*(*), intent(in) :: fil, mod
        end function

        integer function alarm(time,proc)
        integer, intent(in) :: time
        external proc
        end function

        pure real function besj0(x)
        real, intent(in) :: x
        end function

        pure real function besj1(x)
        real, intent(in) :: x
        end function

        pure real function besjn(n,x)
        integer, intent(in) :: n
        real, intent(in) :: x
        end function

        pure real function besy0(x)
        real, intent(in) :: x
        end function

        pure real function besy1(x)
        real, intent(in) :: x
        end function

        pure real function besyn(n,x)
        integer, intent(in) :: n
        real, intent(in) :: x
        end function

        pure double precision function dbesj0(x)
        double precision, intent(in) :: x
        end function

        pure double precision function dbesj1(x)
        double precision, intent(in) :: x
        end function

        pure double precision function dbesjn(n,x)
        integer, intent(in) :: n
        double precision, intent(in) :: x
        end function

        pure double precision function dbesy0(x)
        double precision, intent(in) :: x
        end function

        pure double precision function dbesy1(x)
        double precision, intent(in) :: x
        end function

        pure double precision function dbesyn(n,x)
        integer, intent(in) :: n
        double precision, intent(in) :: x
        end function

        integer function chdir(path)
        character*(*), intent(in) :: path
        end function

        integer function chmod(nam,mode)
        character*(*), intent(in) :: nam
        integer, intent(in) :: mode
        end function

        pure character*(24) function ctime(stime)
        integer, intent(in) :: stime
        end function

        pure subroutine date(str)
        character*(*), intent(out) :: str
        end subroutine

        pure real function erf(x)
        real, intent(in) :: x
        end function

        pure real function erfc(x)
        real, intent(in) :: x
        end function

        pure double precision function derf(x)
        double precision, intent(in) :: x
        end function

        pure double precision function derfc(x)
        double precision, intent(in) :: x
        end function

        pure real function etime(tarray)
        real, intent(out) :: tarray(2)
        end function

        pure real function dtime(tarray)
        real, intent(out) :: tarray(2)
        end function

        subroutine exit(s)
        integer, intent(in) :: s
        end subroutine

        pure subroutine fdate(str)
        character*(*), intent(out) :: str
        end subroutine

        integer function fgetc(lu,ch)
        integer, intent(in) :: lu
        character*(*), intent(out) :: ch
        end function

        subroutine flush(lu)
        integer, intent(in) :: lu
        end subroutine

        integer function fork()
        end function

        integer function fputc(lu,ch)
        integer, intent(in) :: lu
        character*(*), intent(in) :: ch
        end function

        subroutine free(p)
        integer, intent(in) :: p
        end subroutine

        integer function fseek(lu,offset,from)
        integer, intent(in) :: lu, offset, from
        end function

        integer function ftell(lu)
        integer, intent(in) :: lu
        end function

        subroutine gerror(str)
        character*(*), intent(out) :: str
        end subroutine

        subroutine getarg(i,c)
        integer, intent(in) :: i
        character*(*), intent(out) :: c
        end subroutine

        integer function iargc()
        end function

        integer function getc(ch)
        character*(*), intent(out) :: ch
        end function

        integer function getcwd(dir)
        character*(*), intent(out) :: dir
        end function

        subroutine getenv(en,ev)
        character*(*), intent(in) :: en
        character*(*), intent(out) :: ev
        end subroutine

        integer function getfd(lu)
	integer, intent(in) :: lu
        end function

        integer function getgid()
        end function

        subroutine getlog(name)
        character*(*), intent(out) :: name
        end subroutine

        integer function getpid()
        end function

        integer function getuid()
        end function

        pure subroutine gmtime(stime,tarray)
        integer, intent(in) :: stime
        integer, intent(out) :: tarray(9)
        end subroutine

        integer function hostnm(nm)
        character*(*), intent(out) :: nm
        end function

        pure subroutine idate(date_array)
        integer, intent(out) :: date_array(3)
        end subroutine

        integer function ierrno()
        end function

        subroutine ioinit(cc,bz,ap,pf,vb)
        logical, intent(in) :: cc, bz, ap, vb
        character*(*), intent(in) :: pf
        end subroutine

        logical function isatty(lu)
        integer, intent(in) :: lu
        end function

        pure subroutine itime(iarray)
        integer, intent(out) :: iarray(3)
        end subroutine

        integer function kill(pid,sig)
        integer, intent(in) :: pid, sig
        end function

        integer function link(n1,n2)
        character*(*), intent(in) :: n1, n2
        end function

        pure integer function lnblnk(a1)
        character*(*), intent(in) :: a1
        end function

        pure integer function loc(a)
        integer, intent(in) :: a
        end function

        pure subroutine ltime(stime,tarray)
        integer, intent(in) :: stime
        integer, intent(out) :: tarray(9)
        end subroutine

        integer function malloc(n)
        integer, intent(in) :: n
        end function

        pure integer function mclock()
        end function

        integer function outstr(ch)
        character*(*), intent(in) :: ch
        end function

        subroutine perror(str)
        character*(*), intent(in) :: str
        end subroutine

        integer function putc(ch)
        character*(*), intent(in) :: ch
        end function

        integer function putenv(str)
        character*(*), intent(in) :: str
        end function

        pure subroutine qsort(arr,len,isiz,comp)
        integer, intent(inout) :: arr(*)
        integer, intent(in) :: len, isiz
        external comp
        integer comp
        end subroutine

        double precision function rand()
        end function

        integer function irand()
        end function

        subroutine srand(iseed)
        integer, intent(in) :: iseed
        end subroutine

        real function random(flag)
        integer, intent(in) :: flag
        end function

        integer function irandm(flag)
        integer, intent(in) :: flag
        end function

        double precision function drandm(flag)
        integer, intent(in) :: flag
        end function

        pure real function flmin()
        end function

        pure real function flmax()
        end function

        pure real function ffrac()
        end function

        pure double precision function dflmin()
        end function

        pure double precision function dflmax()
        end function

        pure double precision function dffrac()
        end function

        pure integer function inmax()
        end function

        integer function rename(from,to)
        character*(*), intent(in) :: from, to
        end function

        pure integer function rindex(a1,a2)
        character*(*), intent(in) :: a1, a2
        end function

        pure real function secnds(x)
        real, intent(in) :: x
        end function

        pure double precision function dsecnds(x)
        double precision, intent(in) :: x
        end function

        integer function signal(sig,proc,flag)
        integer, intent(in) :: sig, flag
        external proc
        end function

        subroutine sleep(itime)
        integer, intent(in) :: itime
        end subroutine

        integer function stat(nm,statb)
        character*(*), intent(in) :: nm
        integer, intent(out) :: statb(*)
        end function

        integer function lstat(nm,statb)
        character*(*), intent(in) :: nm
        integer, intent(out) :: statb(*)
        end function

        integer function fstat(lu,statb)
        integer, intent(in) :: lu
        integer, intent(out) :: statb(*)
        end function

        integer function stime(tp)
        integer, intent(in) :: tp
        end function

        integer function symlnk(n1,n2)
        character*(*), intent(in) :: n1, n2
        end function

        integer function system(str)
        character*(*), intent(in) :: str
        end function

        pure integer function time()
        end function

        pure integer function times(buf)
        integer, intent(out) :: buf(*)
        end function

        character*(100) function ttynam(lu)
        integer, intent(in) :: lu
        end function

        integer function unlink(fil)
        character*(*), intent(in) :: fil
        end function

        integer function wait(st)
        integer, intent(out) :: st
        end function

        subroutine pxffileno(lu,fd,err)
        integer, intent(in) :: lu
	integer, intent(out) :: fd,err
        end subroutine

      end interface
